/*
 * Decompiled with CFR 0.152.
 */
package minicdj.util;

import minicdj.util.AbstractCollection;
import minicdj.util.AbstractSet;
import minicdj.util.Collection;
import minicdj.util.Iterator;
import minicdj.util.Map;
import minicdj.util.Set;

public abstract class AbstractMap
implements Map {
    static final int KEYS = 0;
    static final int VALUES = 1;
    static final int ENTRIES = 2;
    Set keys;
    Collection values;

    protected AbstractMap() {
    }

    @Override
    public abstract Set entrySet();

    @Override
    public void clear() {
        this.entrySet().clear();
    }

    protected Object clone() throws CloneNotSupportedException {
        AbstractMap copy = (AbstractMap)super.clone();
        copy.keys = null;
        copy.values = null;
        return copy;
    }

    @Override
    public boolean containsKey(Object key) {
        Iterator entries = this.entrySet().iterator();
        int pos = this.size();
        while (--pos >= 0) {
            if (!AbstractMap.equals(key, ((Map.Entry)entries.next()).getKey())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        Iterator entries = this.entrySet().iterator();
        int pos = this.size();
        while (--pos >= 0) {
            if (!AbstractMap.equals(value, ((Map.Entry)entries.next()).getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        return o == this || o instanceof Map && this.entrySet().equals(((Map)o).entrySet());
    }

    @Override
    public Object get(Object key) {
        Iterator entries = this.entrySet().iterator();
        int pos = this.size();
        while (--pos >= 0) {
            Map.Entry entry = (Map.Entry)entries.next();
            if (!AbstractMap.equals(key, entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public int hashCode() {
        return this.entrySet().hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Set keySet() {
        if (this.keys == null) {
            this.keys = new AbstractSet(){

                @Override
                public int size() {
                    return AbstractMap.this.size();
                }

                @Override
                public boolean contains(Object key) {
                    return AbstractMap.this.containsKey(key);
                }

                @Override
                public Iterator iterator() {
                    return new Iterator(){
                        private final Iterator map_iterator;
                        {
                            this.map_iterator = AbstractMap.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.map_iterator.hasNext();
                        }

                        @Override
                        public Object next() {
                            return ((Map.Entry)this.map_iterator.next()).getKey();
                        }

                        @Override
                        public void remove() {
                            this.map_iterator.remove();
                        }
                    };
                }
            };
        }
        return this.keys;
    }

    @Override
    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map m) {
        Iterator entries = m.entrySet().iterator();
        int pos = m.size();
        while (--pos >= 0) {
            Map.Entry entry = (Map.Entry)entries.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Object remove(Object key) {
        Iterator entries = this.entrySet().iterator();
        int pos = this.size();
        while (--pos >= 0) {
            Map.Entry entry = (Map.Entry)entries.next();
            if (!AbstractMap.equals(key, entry.getKey())) continue;
            Object r = entry.getValue();
            entries.remove();
            return r;
        }
        return null;
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    public String toString() {
        Iterator entries = this.entrySet().iterator();
        StringBuffer r = new StringBuffer("{");
        int pos = this.size();
        while (pos > 0) {
            Map.Entry entry = (Map.Entry)entries.next();
            r.append(entry.getKey());
            r.append('=');
            r.append(entry.getValue());
            if (pos > 1) {
                r.append(", ");
            }
            --pos;
        }
        r.append("}");
        return r.toString();
    }

    @Override
    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(){

                @Override
                public int size() {
                    return AbstractMap.this.size();
                }

                @Override
                public boolean contains(Object value) {
                    return AbstractMap.this.containsValue(value);
                }

                @Override
                public Iterator iterator() {
                    return new Iterator(){
                        private final Iterator map_iterator;
                        {
                            this.map_iterator = AbstractMap.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.map_iterator.hasNext();
                        }

                        @Override
                        public Object next() {
                            return ((Map.Entry)this.map_iterator.next()).getValue();
                        }

                        @Override
                        public void remove() {
                            this.map_iterator.remove();
                        }
                    };
                }
            };
        }
        return this.values;
    }

    static final boolean equals(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    static final int hashCode(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    static class BasicMapEntry
    implements Map.Entry {
        Object key;
        Object value;

        BasicMapEntry(Object newKey, Object newValue) {
            this.key = newKey;
            this.value = newValue;
        }

        @Override
        public final boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof BasicMapEntry) {
                BasicMapEntry e = (BasicMapEntry)o;
                return AbstractMap.equals(this.key, e.key) && AbstractMap.equals(this.value, e.value);
            }
            Map.Entry e = (Map.Entry)o;
            return AbstractMap.equals(this.key, e.getKey()) && AbstractMap.equals(this.value, e.getValue());
        }

        @Override
        public final Object getKey() {
            return this.key;
        }

        @Override
        public final Object getValue() {
            return this.value;
        }

        @Override
        public final int hashCode() {
            return AbstractMap.hashCode(this.key) ^ AbstractMap.hashCode(this.value);
        }

        @Override
        public Object setValue(Object newVal) {
            Object r = this.value;
            this.value = newVal;
            return r;
        }

        public final String toString() {
            return this.key + "=" + this.value;
        }
    }
}

