/*
 * Decompiled with CFR 0.152.
 */
package minicdj.cdx;

import minicdj.cdx.CallSign;
import minicdj.statetable.Vector3d;
import minicdj.util.HashMap;

public class StateTable {
    private static final int MAX_AIRPLANES = 10000;
    private Vector3d[] allocatedVectors;
    private int usedVectors;
    private final HashMap motionVectors = new HashMap();
    private final R r = new R();

    StateTable() {
        this.allocatedVectors = new Vector3d[10000];
        int i = 0;
        while (i < this.allocatedVectors.length) {
            this.allocatedVectors[i] = new Vector3d();
            ++i;
        }
        this.usedVectors = 0;
    }

    public void put(CallSign callsign, float x, float y, float z) {
        this.r.callsign = callsign;
        this.r.x = x;
        this.r.y = y;
        this.r.z = z;
    }

    public Vector3d get(CallSign callsign) {
        return (Vector3d)this.motionVectors.get(callsign);
    }

    private class R
    implements Runnable {
        CallSign callsign;
        float x;
        float y;
        float z;

        private R() {
        }

        @Override
        public void run() {
            Vector3d v = (Vector3d)StateTable.this.motionVectors.get(this.callsign);
            if (v == null) {
                Vector3d[] vector3dArray = StateTable.this.allocatedVectors;
                StateTable stateTable = StateTable.this;
                int n = stateTable.usedVectors;
                stateTable.usedVectors = n + 1;
                v = vector3dArray[n];
                StateTable.this.motionVectors.put(this.callsign, v);
            }
            v.x = this.x;
            v.y = this.y;
            v.z = this.z;
        }
    }
}

