/*
 * Decompiled with CFR 0.152.
 */
package minicdj.cdx;

import minicdj.cdx.Benchmarker;
import minicdj.cdx.Motion;
import minicdj.cdx.Vector2d;
import minicdj.cdx.VectorMath;
import minicdj.collision.Vector3d;
import minicdj.util.ArrayList;
import minicdj.util.HashMap;
import minicdj.util.Iterator;
import minicdj.util.LinkedList;

class Reducer {
    public float voxel_size;
    public Vector2d horizontal;
    public Vector2d vertical;

    protected void voxelHash(Vector3d position, Vector2d voxel) {
        Benchmarker.set(7);
        int x_div = (int)(position.x / this.voxel_size);
        voxel.x = this.voxel_size * (float)x_div;
        if (position.x < 0.0f) {
            voxel.x -= this.voxel_size;
        }
        int y_div = (int)(position.y / this.voxel_size);
        voxel.y = this.voxel_size * (float)y_div;
        if (position.y < 0.0f) {
            voxel.y -= this.voxel_size;
        }
        Benchmarker.done(7);
    }

    protected void putIntoMap(HashMap voxel_map, Vector2d voxel, Motion motion) {
        Benchmarker.set(8);
        if (!voxel_map.containsKey(voxel)) {
            voxel_map.put(new Vector2d(voxel), new ArrayList());
        }
        ((ArrayList)voxel_map.get(voxel)).add(motion);
        Benchmarker.done(8);
    }

    protected boolean isInVoxel(Vector2d voxel, Motion motion) {
        Benchmarker.set(9);
        if (voxel.x > 1000.0f || voxel.x + this.voxel_size < 0.0f || voxel.y > 1000.0f || voxel.y + this.voxel_size < 0.0f) {
            Benchmarker.done(9);
            return false;
        }
        Vector3d init = motion.getFirstPosition();
        Vector3d fin = motion.getSecondPosition();
        float v_s = this.voxel_size;
        float r = 0.5f;
        float v_x = voxel.x;
        float x0 = init.x;
        float xv = fin.x - init.x;
        float v_y = voxel.y;
        float y0 = init.y;
        float yv = fin.y - init.y;
        float low_x = (v_x - r - x0) / xv;
        float high_x = (v_x + v_s + r - x0) / xv;
        if (xv < 0.0f) {
            float tmp = low_x;
            low_x = high_x;
            high_x = tmp;
        }
        float low_y = (v_y - r - y0) / yv;
        float high_y = (v_y + v_s + r - y0) / yv;
        if (yv < 0.0f) {
            float tmp = low_y;
            low_y = high_y;
            high_y = tmp;
        }
        boolean result = ((double)xv == 0.0 && v_x <= x0 + r && x0 - r <= v_x + v_s || low_x <= 1.0f && 1.0f <= high_x || low_x <= 0.0f && 0.0f <= high_x || 0.0f <= low_x && high_x <= 1.0f) && ((double)yv == 0.0 && v_y <= y0 + r && y0 - r <= v_y + v_s || low_y <= 1.0f && 1.0f <= high_y || low_y <= 0.0f && 0.0f <= high_y || 0.0f <= low_y && high_y <= 1.0f) && (xv == 0.0f || yv == 0.0f || low_y <= high_x && high_x <= high_y || low_y <= low_x && low_x <= high_y || low_x <= low_y && high_y <= high_x);
        Benchmarker.done(9);
        return result;
    }

    protected void dfsVoxelHashRecurse(Motion motion, Vector2d next_voxel, HashMap voxel_map, HashMap graph_colors) {
        Benchmarker.set(10);
        Vector2d tmp = new Vector2d();
        if (!graph_colors.containsKey(next_voxel) && this.isInVoxel(next_voxel, motion)) {
            graph_colors.put(new Vector2d(next_voxel), "");
            this.putIntoMap(voxel_map, next_voxel, motion);
            VectorMath.subtract(next_voxel, this.horizontal, tmp);
            this.dfsVoxelHashRecurse(motion, tmp, voxel_map, graph_colors);
            VectorMath.add(next_voxel, this.horizontal, tmp);
            this.dfsVoxelHashRecurse(motion, tmp, voxel_map, graph_colors);
            VectorMath.add(next_voxel, this.vertical, tmp);
            this.dfsVoxelHashRecurse(motion, tmp, voxel_map, graph_colors);
            VectorMath.subtract(next_voxel, this.vertical, tmp);
            this.dfsVoxelHashRecurse(motion, tmp, voxel_map, graph_colors);
            VectorMath.subtract(next_voxel, this.horizontal, tmp);
            VectorMath.add(tmp, this.vertical, tmp);
            this.dfsVoxelHashRecurse(motion, tmp, voxel_map, graph_colors);
            VectorMath.add(next_voxel, this.horizontal, tmp);
            VectorMath.add(tmp, this.vertical, tmp);
            this.dfsVoxelHashRecurse(motion, tmp, voxel_map, graph_colors);
            VectorMath.subtract(next_voxel, this.horizontal, tmp);
            VectorMath.subtract(tmp, this.vertical, tmp);
            this.dfsVoxelHashRecurse(motion, tmp, voxel_map, graph_colors);
            VectorMath.add(next_voxel, this.horizontal, tmp);
            VectorMath.subtract(tmp, this.vertical, tmp);
            this.dfsVoxelHashRecurse(motion, tmp, voxel_map, graph_colors);
        }
        Benchmarker.done(10);
    }

    protected void performVoxelHashing(Motion motion, HashMap voxel_map, HashMap graph_colors) {
        Benchmarker.set(11);
        graph_colors.clear();
        Vector2d voxel = new Vector2d();
        this.voxelHash(motion.getFirstPosition(), voxel);
        this.dfsVoxelHashRecurse(motion, voxel, voxel_map, graph_colors);
        Benchmarker.done(11);
    }

    public LinkedList reduceCollisionSet(LinkedList motions) {
        Benchmarker.set(12);
        HashMap voxel_map = new HashMap();
        HashMap graph_colors = new HashMap();
        Iterator iter = motions.iterator();
        while (iter.hasNext()) {
            this.performVoxelHashing((Motion)iter.next(), voxel_map, graph_colors);
        }
        LinkedList ret = new LinkedList();
        Iterator iter2 = voxel_map.values().iterator();
        while (iter2.hasNext()) {
            LinkedList cur_set = (LinkedList)iter2.next();
            if (cur_set.size() <= 1) continue;
            ret.add(cur_set);
        }
        Benchmarker.done(12);
        return ret;
    }

    public Reducer(float voxel_size) {
        this.voxel_size = voxel_size;
        this.horizontal = new Vector2d(voxel_size, 0.0f);
        this.vertical = new Vector2d(0.0f, voxel_size);
    }
}

