/*
 * Decompiled with CFR 0.152.
 */
package minicdj.cdx;

import minicdj.cdx.Constants;

public class NoiseGenerator {
    private Object[] noiseRoot;
    private int noisePtr;

    public NoiseGenerator() {
        if (Constants.DETECTOR_NOISE) {
            this.noiseRoot = new Object[Constants.DETECTOR_NOISE_REACHABLE_POINTERS];
            this.noisePtr = 0;
        }
    }

    private void generateNoise() {
        int i = 0;
        while (i < Constants.DETECTOR_NOISE_ALLOCATE_POINTERS) {
            this.noiseRoot[this.noisePtr++ % this.noiseRoot.length] = new byte[Constants.DETECTOR_NOISE_ALLOCATION_SIZE];
            ++i;
        }
    }

    private void generateNoiseWithVariableObjectSize() {
        int currentIncrement = 0;
        int maxIncrement = Constants.DETECTOR_NOISE_MAX_ALLOCATION_SIZE - Constants.DETECTOR_NOISE_MIN_ALLOCATION_SIZE;
        int i = 0;
        while (i < Constants.DETECTOR_NOISE_ALLOCATE_POINTERS) {
            this.noiseRoot[this.noisePtr++ % this.noiseRoot.length] = new byte[Constants.DETECTOR_NOISE_MIN_ALLOCATION_SIZE + currentIncrement % maxIncrement];
            currentIncrement += Constants.DETECTOR_NOISE_ALLOCATION_SIZE_INCREMENT;
            ++i;
        }
    }

    public void generateNoiseIfEnabled() {
        if (Constants.DETECTOR_NOISE) {
            if (Constants.DETECTOR_NOISE_VARIABLE_ALLOCATION_SIZE) {
                this.generateNoiseWithVariableObjectSize();
            } else {
                this.generateNoise();
            }
        }
    }
}

