/*
 * Decompiled with CFR 0.152.
 */
package minicdj.cdx;

import minicdj.cdx.Aircraft;
import minicdj.collision.Vector3d;

class Motion {
    private final Aircraft aircraft;
    private final Vector3d pos_one;
    private final Vector3d pos_two;

    public Motion(Aircraft _aircraft, Vector3d _pos_one, Vector3d _pos_two) {
        this.aircraft = _aircraft;
        this.pos_one = _pos_one;
        this.pos_two = _pos_two;
    }

    public Motion(Aircraft _aircraft, Vector3d _pos) {
        this(_aircraft, _pos, _pos);
    }

    public Aircraft getAircraft() {
        return this.aircraft;
    }

    public Vector3d getFirstPosition() {
        return this.pos_one;
    }

    public Vector3d getSecondPosition() {
        return this.pos_two;
    }

    public String toString() {
        return "MOTION of " + this.getAircraft().toString() + " from " + this.getFirstPosition().toString() + " to " + this.getSecondPosition().toString();
    }

    public Vector3d findIntersection(Motion other) {
        Vector3d i1 = new Vector3d();
        Vector3d f1 = new Vector3d();
        Vector3d i2 = new Vector3d();
        Vector3d f2 = new Vector3d();
        i1.set(this.getFirstPosition());
        f1.set(this.getSecondPosition());
        i2.set(other.getFirstPosition());
        f2.set(other.getSecondPosition());
        float r = 1.0f;
        float vx1 = f1.x - i1.x;
        float vx2 = f2.x - i2.x;
        float vy1 = f1.y - i1.y;
        float vy2 = f2.y - i2.y;
        float vz1 = f1.z - i1.z;
        float vz2 = f2.z - i2.z;
        float a = (vx2 - vx1) * (vx2 - vx1) + (vy2 - vy1) * (vy2 - vy1) + (vz2 - vz1) * (vz2 - vz1);
        if (a != 0.0f) {
            float v2;
            float b = 2.0f * (i2.x * vx2 - i2.x * vx1 - i1.x * vx2 + i1.x * vx1 + i2.y * vy2 - i2.y * vy1 - i1.y * vy2 + i1.y * vy1 + i2.z * vz2 - i2.z * vz1 - i1.z * vz2 + i1.z * vz1);
            float c = -r * r + (i2.x - i1.x) * (i2.x - i1.x) + (i2.y - i1.y) * (i2.y - i1.y) + (i2.z - i1.z) * (i2.z - i1.z);
            float discr = b * b - 4.0f * a * c;
            if (discr < 0.0f) {
                return null;
            }
            float v1 = (-b - (float)Math.sqrt(discr)) / (2.0f * a);
            if (v1 <= (v2 = (-b + (float)Math.sqrt(discr)) / (2.0f * a)) && (v1 <= 1.0f && 1.0f <= v2 || v1 <= 0.0f && 0.0f <= v2 || 0.0f <= v1 && v2 <= 1.0f)) {
                float x1col = i1.x + vx1 * (v1 + v2) / 2.0f;
                float y1col = i1.y + vy1 * (v1 + v2) / 2.0f;
                float z1col = i1.z + vz1 * (v1 + v2) / 2.0f;
                if (z1col > 0.0f && z1col <= 10.0f && x1col >= 0.0f && x1col <= 1000.0f && y1col >= 0.0f && y1col <= 1000.0f) {
                    return new Vector3d(x1col, y1col, z1col);
                }
            }
        } else {
            float dist = (i2.x - i1.x) * (i2.x - i1.x) + (i2.y - i1.y) * (i2.y - i1.y) + (i2.z - i1.z) * (i2.z - i1.z);
            if ((dist = (float)Math.sqrt(dist)) <= r) {
                return this.getFirstPosition();
            }
        }
        return null;
    }
}

