/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical.extension;

import javax.realtime.AbsoluteTime;
import javax.realtime.Clock;
import javax.realtime.PriorityParameters;
import javax.realtime.ReleaseParameters;
import javax.safetycritical.DeadlineMissHandler;
import javax.safetycritical.Services;
import javax.safetycritical.StorageParameters;
import javax.safetycritical.extension.ManagedRealtimeThread;

public abstract class PeriodicThread
extends ManagedRealtimeThread {
    private AbsoluteTime nextRelease;
    private AbsoluteTime nextDeadline;
    private int period;
    private int deadline;
    private DeadlineMissHandler deadlineMissDetection;
    boolean started = false;

    public PeriodicThread(PriorityParameters priority, StorageParameters storage, int peroid, int deadline, DeadlineMissHandler deadlineMissDetection, boolean isAutoStart, String name) {
        super(priority, storage, isAutoStart, name);
        this.period = peroid;
        this.deadline = deadline;
        this.nextRelease = new AbsoluteTime();
        this.nextDeadline = new AbsoluteTime();
        this.deadlineMissDetection = deadlineMissDetection;
    }

    public synchronized void firstRelease() {
        this.nextRelease = Clock.getRealtimeClock().getTime(this.nextRelease);
        this.nextDeadline.set(this.nextRelease.getMilliseconds() + (long)this.deadline);
        if (this.deadlineMissDetection != null) {
            this.deadlineMissDetection.scheduleNextReleaseTime(this.nextDeadline);
        }
    }

    @Override
    public void run() {
        this.firstRelease();
        while (!this.getMission().terminationPending()) {
            this.nextRelease = this.nextRelease.add(this.period, 0);
            this.work();
            this.nextDeadline = this.nextDeadline.add(this.period, 0);
            if (this.deadlineMissDetection != null) {
                this.deadlineMissDetection.scheduleNextReleaseTime(this.nextDeadline);
            }
            Services.delay(this.nextRelease);
        }
    }

    @Override
    public ReleaseParameters getReleaseParameter() {
        return null;
    }
}

