/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import javax.realtime.AbsoluteTime;
import javax.realtime.Clock;
import javax.safetycritical.CyclicScheduler;
import javax.safetycritical.Launcher;
import javax.safetycritical.ManagedSchedulable;
import javax.safetycritical.Monitor;
import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.ScjProcess;
import javax.safetycritical.annotate.Level;
import javax.safetycritical.annotate.SCJAllowed;
import vm.RealtimeClock;

@SCJAllowed
public class Services {
    @SCJAllowed
    public static void captureBackTrace(Throwable association) {
    }

    @SCJAllowed
    public static ManagedSchedulable currentManagedSchedulable() {
        if (Launcher.level == 0) {
            return CyclicScheduler.instance().seq;
        }
        return PriorityScheduler.instance().getCurrentProcess().getTarget();
    }

    public static ScjProcess getCurrentProcess() {
        if (Launcher.level != 0) {
            return PriorityScheduler.instance().getCurrentProcess();
        }
        return CyclicScheduler.instance().getCurrentProcess();
    }

    @SCJAllowed(value=Level.LEVEL_1)
    public static int getDefaultCeiling() {
        return PriorityScheduler.instance().getMaxPriority();
    }

    @SCJAllowed(value=Level.LEVEL_1)
    public static void setCeiling(Object target, int ceiling) {
        Monitor monitor = new Monitor(ceiling);
        monitor.attach(target);
    }

    @SCJAllowed(value=Level.LEVEL_0)
    public static void nanoSpin(int nanos) {
        Clock clock = Clock.getRealtimeClock();
        AbsoluteTime time = new AbsoluteTime();
        AbsoluteTime next = new AbsoluteTime();
        clock.getTime(time);
        time.add(0L, nanos, next);
        while (time.compareTo(next) < 0) {
            clock.getTime(time);
        }
    }

    public static void delay(AbsoluteTime delay) {
        RealtimeClock.delayNativeUntil(delay);
    }
}

