/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import javax.realtime.AbsoluteTime;
import javax.realtime.AperiodicParameters;
import javax.realtime.Clock;
import javax.realtime.HighResolutionTime;
import javax.realtime.PriorityParameters;
import javax.realtime.RelativeTime;
import javax.safetycritical.ManagedEventHandler;
import javax.safetycritical.ManagedSchedulableSet;
import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.StorageParameters;
import javax.safetycritical.annotate.Level;
import javax.safetycritical.annotate.Phase;
import javax.safetycritical.annotate.SCJAllowed;
import javax.safetycritical.annotate.SCJRestricted;
import vm.ClockInterruptHandler;

@SCJAllowed(value=Level.LEVEL_1)
public abstract class OneShotEventHandler
extends ManagedEventHandler {
    HighResolutionTime releaseTime;
    PriorityScheduler sch;

    @SCJAllowed(value=Level.LEVEL_1)
    @SCJRestricted(value=Phase.INITIALIZE)
    public OneShotEventHandler(PriorityParameters priority, HighResolutionTime releaseTime, AperiodicParameters release, StorageParameters storage, String name) {
        super(priority, release, storage, name);
        if (releaseTime instanceof RelativeTime && (releaseTime.getMilliseconds() < 0L || releaseTime.getMilliseconds() == 0L && releaseTime.getNanoseconds() < 0)) {
            throw new IllegalArgumentException("releaseTime is a negative time");
        }
        this.releaseTime = releaseTime;
    }

    public OneShotEventHandler(PriorityParameters priority, HighResolutionTime releaseTime, AperiodicParameters release, StorageParameters storage) {
        this(priority, releaseTime, release, storage, null);
    }

    public OneShotEventHandler(PriorityParameters priority, AperiodicParameters release, StorageParameters storage) {
        this(priority, null, release, storage, null);
    }

    @SCJAllowed(value=Level.LEVEL_1)
    public boolean deschedule() {
        ManagedSchedulableSet hs = this.mission.MSSetForMission;
        if (hs.contains(this)) {
            hs.removeMSO(this);
            return true;
        }
        return false;
    }

    @Override
    public final void cleanUp() {
        super.cleanUp();
    }

    @Override
    @SCJAllowed(value=Level.INFRASTRUCTURE)
    @SCJRestricted(value=Phase.INITIALIZE)
    public final void register() {
        super.register();
        this.sch = PriorityScheduler.instance();
    }

    public AbsoluteTime getNextReleaseTime(AbsoluteTime dest) {
        if (dest != null) {
            dest.set(this.process.getNext());
        } else {
            dest = new AbsoluteTime(this.process.getNext());
        }
        return dest;
    }

    public void scheduleNextReleaseTime(HighResolutionTime time) {
        ClockInterruptHandler.instance.disable();
        this.sch.removeReleaseQueue(this.process);
        if (time instanceof RelativeTime) {
            RelativeTime releaseTime = (RelativeTime)time;
            this.process.getNext().add(releaseTime, this.process.getNext());
        } else {
            AbsoluteTime releaseTime = (AbsoluteTime)time;
            int compare = releaseTime.compareTo(Clock.getRealtimeClock().getTime(new AbsoluteTime(Clock.getRealtimeClock())));
            if (compare < 0) {
                this.process.getNext().add(new RelativeTime(), this.process.getNext());
            } else {
                this.process.getNext().set(releaseTime);
            }
        }
        this.sch.insertReleaseQueue(this.process);
        ClockInterruptHandler.instance.enable();
    }
}

