/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import javax.realtime.AperiodicParameters;
import javax.realtime.PriorityParameters;
import javax.safetycritical.Launcher;
import javax.safetycritical.ManagedEventHandler;
import javax.safetycritical.Mission;
import javax.safetycritical.MissionMemory;
import javax.safetycritical.Monitor;
import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.StorageParameters;
import javax.safetycritical.annotate.Level;
import javax.safetycritical.annotate.Phase;
import javax.safetycritical.annotate.SCJAllowed;
import javax.safetycritical.annotate.SCJRestricted;
import javax.scj.util.Const;
import vm.ClockInterruptHandler;
import vm.RealtimeClock;

@SCJAllowed
public abstract class MissionSequencer<SpecificMission extends Mission>
extends ManagedEventHandler {
    MissionMemory missionMemory;
    SpecificMission currMission;
    int currState;
    boolean terminateSeq = false;
    static volatile boolean isOuterMostSeq = true;
    Monitor lock;

    @SCJAllowed
    @SCJRestricted(value=Phase.INITIALIZE)
    public MissionSequencer(PriorityParameters priority, StorageParameters storage, String name) {
        super(priority, new AperiodicParameters(), storage, name);
        this.missionMemory = new MissionMemory((int)storage.maxMissionMemory, this.privateMemory);
        this.currState = 1;
        if (isOuterMostSeq && Launcher.level != 0) {
            PriorityScheduler.instance().addOuterMostSeq(this, new int[Const.HANDLER_STACK_SIZE]);
        }
        if (Launcher.level == 2) {
            isOuterMostSeq = false;
        }
        this.lock = new Monitor(this.getPriorityParameter().getPriority());
    }

    @SCJAllowed
    @SCJRestricted(value=Phase.INITIALIZE)
    public MissionSequencer(PriorityParameters priority, StorageParameters storage) {
        this(priority, storage, null);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @SCJAllowed(value=Level.INFRASTRUCTURE)
    public final void handleAsyncEvent() {
        do {
            switch (this.currState) {
                case 1: {
                    this.currMission = this.getNextMission();
                    if (this.currMission == null || this.terminateSeq) {
                        this.terminateSeq = true;
                        this.currState = 5;
                        break;
                    }
                    this.currMission.missionTerminate = false;
                    desiredMissionSize = this.currMission.missionMemorySize();
                    if (desiredMissionSize > this.missionMemory.size()) {
                        this.currState = 1;
                        break;
                    }
                    if (desiredMissionSize < this.missionMemory.size()) {
                        this.missionMemory.resizeArea(desiredMissionSize);
                    }
                    this.currState = 2;
                    break;
                }
                case 2: {
                    this.currMission.setMissionSeq(this);
                    this.missionMemory.enterToInitialize((Mission)this.currMission);
                    this.currState = 3;
                    break;
                }
                case 3: {
                    this.missionMemory.enterToExecute((Mission)this.currMission);
                    if (Launcher.level == 0) ** GOTO lbl33
                    this.lock.lockWithOutEnable();
                    while (this.currMission.MSSetForMission.noOfActived > 0) {
                        PriorityScheduler.instance().waitForMS(this.lock);
                    }
                    this.lock.unlock();
                    ** GOTO lbl34
lbl-1000:
                    // 1 sources

                    {
                        RealtimeClock.awaitNextTick();
lbl33:
                        // 2 sources

                        ** while (!this.currMission.terminationPending() && this.currMission.MSSetForMission.noOfActived == 0)
                    }
lbl34:
                    // 2 sources

                    this.currState = 4;
                    break;
                }
                case 4: {
                    shouldMSContinue = this.currMission.cleanUp();
                    this.missionMemory.enterToCleanup((Mission)this.currMission);
                    this.missionMemory.resizeArea(this.storage.maxMissionMemory);
                    this.currState = shouldMSContinue != false ? 1 : 5;
                    break;
                }
                case 5: {
                    this.currState = 6;
                }
            }
        } while (this.currState < 6);
    }

    @SCJAllowed(value=Level.SUPPORT)
    protected abstract SpecificMission getNextMission();

    @Override
    public final void register() {
        super.register();
    }

    @SCJAllowed
    public final boolean sequenceTerminationPending() {
        return this.terminateSeq;
    }

    @Override
    public final void cleanUp() {
        this.missionMemory.removeArea();
        super.cleanUp();
    }

    @Override
    public void signalTermination() {
        ClockInterruptHandler.instance.disable();
        this.terminateSeq = true;
        ((Mission)this.currMission).requestTermination();
        ClockInterruptHandler.instance.enable();
    }

    public Monitor getLock() {
        return this.lock;
    }

    static interface State {
        public static final int START = 1;
        public static final int INITIALIZE = 2;
        public static final int EXECUTE = 3;
        public static final int CLEANUP = 4;
        public static final int TERMINATE = 5;
        public static final int END = 6;
    }
}

