/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import javax.safetycritical.CyclicSchedule;
import javax.safetycritical.CyclicScheduler;
import javax.safetycritical.Launcher;
import javax.safetycritical.ManagedSchedulableSet;
import javax.safetycritical.MissionMemory;
import javax.safetycritical.MissionSequencer;
import javax.safetycritical.PeriodicEventHandler;
import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.ScjProcess;
import javax.safetycritical.annotate.Level;
import javax.safetycritical.annotate.SCJAllowed;
import javax.scj.util.Const;
import vm.ClockInterruptHandler;

@SCJAllowed
public abstract class Mission {
    MissionSequencer<?> missionSeq = null;
    boolean missionTerminate = false;
    ManagedSchedulableSet MSSetForMission = null;
    protected int missionIndex = -1;
    static volatile Mission[] missionSet = null;
    boolean isMissionSetInitByThis = false;
    static volatile boolean isMissionSetInit = false;

    @SCJAllowed
    public Mission() {
    }

    @SCJAllowed(value=Level.SUPPORT)
    protected boolean cleanUp() {
        return true;
    }

    @SCJAllowed
    public static Mission getCurrentMission() {
        if (Launcher.level == 0 && CyclicScheduler.instance().seq != null) {
            return CyclicScheduler.instance().seq.currMission;
        }
        if (Launcher.level != 0 && PriorityScheduler.instance().getCurrentProcess() != null) {
            if (PriorityScheduler.instance().getCurrentProcess().getTarget() instanceof MissionSequencer) {
                return ((MissionSequencer)PriorityScheduler.instance().getCurrentProcess().getTarget()).currMission;
            }
            return PriorityScheduler.instance().getCurrentProcess().getTarget().getMission();
        }
        return null;
    }

    @SCJAllowed
    public MissionSequencer<?> getSequencer() {
        return this.missionSeq;
    }

    @SCJAllowed(value=Level.SUPPORT)
    protected abstract void initialize();

    void setMissionSeq(MissionSequencer<?> missSeq) {
        this.missionSeq = missSeq;
    }

    @SCJAllowed(value=Level.SUPPORT)
    public abstract long missionMemorySize();

    @SCJAllowed
    public final void requestTermination() {
        this.missionTerminate = true;
        int i = 0;
        while (i < this.MSSetForMission.noOfRegistered) {
            if (this.MSSetForMission.MSOs[i] != null) {
                this.MSSetForMission.MSOs[i].signalTermination();
            }
            ++i;
        }
    }

    public final boolean terminationPending() {
        return this.missionTerminate;
    }

    static synchronized int addNewMission(Mission mission) {
        int i = 0;
        while (i < missionSet.length) {
            if (missionSet[i] == null) {
                Mission.missionSet[i] = mission;
                return i;
            }
            ++i;
        }
        throw new IndexOutOfBoundsException("Mission set: too small");
    }

    void runInitialize() {
        ClockInterruptHandler.instance.disable();
        if (missionSet == null || !isMissionSetInit) {
            missionSet = new Mission[Const.DEFAULT_HANDLER_NUMBER];
            this.isMissionSetInitByThis = true;
            isMissionSetInit = true;
        }
        this.missionIndex = Mission.addNewMission(this);
        this.MSSetForMission = new ManagedSchedulableSet();
        this.initialize();
        ClockInterruptHandler.instance.enable();
    }

    void runExecute() {
        ClockInterruptHandler.instance.disable();
        ManagedSchedulableSet hs = this.MSSetForMission;
        PriorityScheduler sch = PriorityScheduler.instance();
        int index = this.missionIndex * 20;
        int i = 0;
        while (i < hs.noOfRegistered) {
            hs.scjProcesses[i] = new ScjProcess(hs.MSOs[i], new int[(int)hs.MSOs[i].getStorageParameter().configurationSizes[0]]);
            hs.scjProcesses[i].setIndex(index);
            ++index;
            sch.addProcess(hs.scjProcesses[i]);
            ++i;
        }
        ClockInterruptHandler.instance.enable();
    }

    void runCleanup(MissionMemory missMem) {
        ClockInterruptHandler.instance.disable();
        int i = 0;
        while (i < this.MSSetForMission.noOfRegistered) {
            this.MSSetForMission.scjProcesses[i] = null;
            this.MSSetForMission.MSOs[i] = null;
            ++i;
        }
        Mission.missionSet[this.missionIndex] = null;
        if (this.isMissionSetInitByThis) {
            isMissionSetInit = false;
        }
        missMem.resetArea();
        ClockInterruptHandler.instance.enable();
    }

    protected static ScjProcess getScjProcess(int missionIndex, int scjProcessIndex) {
        return Mission.missionSet[missionIndex].MSSetForMission.scjProcesses[scjProcessIndex];
    }

    boolean isRegistered(PeriodicEventHandler pevh) {
        return true;
    }

    boolean inMissionScope(PeriodicEventHandler pevh) {
        return true;
    }

    boolean inMissionScope(CyclicSchedule cs) {
        return true;
    }
}

