/*
 * Decompiled with CFR 0.152.
 */
package javax.safetycritical;

import devices.Console;
import javax.realtime.ImmortalMemory;
import javax.realtime.LTMemory;
import javax.realtime.MemoryArea;
import javax.safetycritical.CyclicScheduler;
import javax.safetycritical.InnerPrivateMemory;
import javax.safetycritical.InterfaceProvider;
import javax.safetycritical.Launcher;
import javax.safetycritical.ManagedSchedulable;
import javax.safetycritical.MissionMemory;
import javax.safetycritical.PriorityScheduler;
import javax.safetycritical.PrivateMemory;
import javax.safetycritical.ScjProcess;
import javax.safetycritical.annotate.Level;
import javax.safetycritical.annotate.SCJAllowed;
import vm.Memory;

@SCJAllowed
public abstract class ManagedMemory
extends LTMemory {
    private static final IllegalArgumentException exception = new IllegalArgumentException("exception thorwn when trying to enter or execute in a memory area.");

    static void allocateBackingStore(int size) {
        OverAllBackingStoreBase = Memory.allocateBackingStore(size);
        OverAllBackingStoreEnd = OverAllBackingStoreBase + size;
        Console.println("MemoryArea allocateBackingStore: base: " + OverAllBackingStoreBase + ";end: " + OverAllBackingStoreEnd + "; size: " + size);
    }

    ManagedMemory(int size, int BackingStoreOfThisMemory, ManagedMemory backingStoreProvider) {
        super(size, BackingStoreOfThisMemory, backingStoreProvider);
    }

    @Override
    @SCJAllowed(value=Level.INFRASTRUCTURE)
    protected void enter(Runnable logic) throws IllegalArgumentException {
        super.enter(logic);
    }

    @Override
    @SCJAllowed
    protected void executeInArea(Runnable logic) throws IllegalArgumentException {
        super.executeInArea(logic);
    }

    private static final MemoryArea getOuterMemory(MemoryArea m) {
        if (m instanceof ManagedMemory) {
            ManagedMemory thisMem = (ManagedMemory)m;
            if (thisMem instanceof InnerPrivateMemory) {
                return thisMem.backingStoreProvider;
            }
            if (thisMem instanceof PrivateMemory) {
                if (thisMem.backingStoreProvider != null) {
                    return thisMem.backingStoreProvider;
                }
                return ImmortalMemory.instance();
            }
            if (thisMem instanceof MissionMemory) {
                return thisMem.backingStoreProvider;
            }
        }
        return null;
    }

    @SCJAllowed
    public static void enterPrivateMemory(int size, Runnable logic) throws IllegalStateException {
        if (logic == null || !(logic instanceof ManagedSchedulable)) {
            throw exception;
        }
        ManagedSchedulable ms = (ManagedSchedulable)logic;
        if (ms.getCurrentMemory() != ms.getTopMemory() || !(ms.getCurrentMemory() instanceof PrivateMemory)) {
            throw new IllegalStateException();
        }
        ManagedMemory prev = (ManagedMemory)ms.getCurrentMemory();
        long prevFree = prev.memoryConsumed();
        InnerPrivateMemory inner = new InnerPrivateMemory(size, prev.getRemainingBackingstoreSize(), prev);
        inner.prev = prev;
        inner.enter(logic);
        if (prev.memoryConsumed() != prevFree) {
            prev.resetArea(prevFree);
        }
        inner.removeArea();
    }

    @SCJAllowed
    public static void executeInAreaOf(Object obj, Runnable logic) {
        if (obj == null || logic == null) {
            throw exception;
        }
        ScjProcess currentRunningProcess = Launcher.level != 0 ? PriorityScheduler.instance().getCurrentProcess() : CyclicScheduler.instance().getCurrentProcess();
        MemoryArea prev = currentRunningProcess == null ? null : currentRunningProcess.getTarget().getCurrentMemory();
        MemoryArea target = ManagedMemory.getMemoryArea(obj);
        if (target != ImmortalMemory.instance()) {
            boolean isOuterMemory = false;
            MemoryArea outerMem = prev instanceof ImmortalMemory ? null : ManagedMemory.getOuterMemory((ManagedMemory)prev);
            while (outerMem != null) {
                if (outerMem == target) {
                    isOuterMemory = true;
                    break;
                }
                outerMem = ManagedMemory.getOuterMemory(outerMem);
            }
            if (!isOuterMemory || target == null) {
                throw exception;
            }
        }
        if (target instanceof ManagedMemory) {
            ((ManagedMemory)target).executeInArea(logic);
        } else {
            InterfaceProvider.instance().executeInImmortal(ImmortalMemory.instance(), logic);
        }
    }

    @SCJAllowed
    public static void executeInOuterArea(Runnable logic) {
        if (logic == null) {
            throw exception;
        }
        ScjProcess currentRunningProcess = Launcher.level != 0 ? PriorityScheduler.instance().getCurrentProcess() : CyclicScheduler.instance().getCurrentProcess();
        MemoryArea prev = currentRunningProcess == null ? null : currentRunningProcess.getTarget().getCurrentMemory();
        MemoryArea target = ManagedMemory.getOuterMemory(prev);
        if (target == null) {
            throw exception;
        }
        if (target instanceof ManagedMemory) {
            ((ManagedMemory)target).executeInArea(logic);
        } else {
            InterfaceProvider.instance().executeInImmortal(ImmortalMemory.instance(), logic);
        }
    }

    @SCJAllowed
    public long getRemainingBackingStore() {
        return this.memoryRemaining();
    }

    private void resetArea(long newFree) {
        this.delegate.reset((int)newFree);
    }

    void resetArea() {
        this.delegate.reset(0);
    }

    void removeArea() {
        this.removeMemArea();
    }

    void resizeArea(long newSize) {
        this.resizeMemArea(newSize);
    }
}

