/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import javax.realtime.Clock;
import javax.realtime.HighResolutionTime;
import javax.safetycritical.annotate.SCJAllowed;

@SCJAllowed
public class RelativeTime
extends HighResolutionTime {
    public RelativeTime() {
        this(0L, 0);
    }

    public RelativeTime(long millis, int nanos) {
        this(millis, nanos, Clock.getRealtimeClock());
    }

    public RelativeTime(Clock clock) {
        this(0L, 0, clock == null ? Clock.getRealtimeClock() : clock);
    }

    public RelativeTime(long millis, int nanos, Clock clock) {
        super(millis, nanos, clock == null ? Clock.getRealtimeClock() : clock);
    }

    public RelativeTime(RelativeTime time) {
        this();
        if (time == null) {
            throw new IllegalArgumentException();
        }
        this.millis = time.millis;
        this.nanos = time.nanos;
        this.clock = time.clock;
    }

    public RelativeTime add(long millis, int nanos) {
        RelativeTime result = new RelativeTime(this.millis + millis, this.nanos + nanos, this.clock);
        result.setNormalized(result.millis, result.nanos);
        return result;
    }

    public RelativeTime add(RelativeTime time) {
        if (time == null) {
            throw new IllegalArgumentException("time is null");
        }
        if (this.clock != time.clock) {
            throw new IllegalArgumentException("clock mismatch");
        }
        RelativeTime result = new RelativeTime(this.millis + time.getMilliseconds(), this.nanos + time.getNanoseconds(), time.getClock());
        result.setNormalized(result.millis, result.nanos);
        return result;
    }

    public RelativeTime add(long millis, int nanos, RelativeTime dest) {
        if (dest == null) {
            dest = new RelativeTime(this.millis + millis, this.nanos + nanos);
        } else {
            dest.set(this.millis + millis, this.nanos + nanos);
        }
        dest.setNormalized(dest.millis, dest.nanos);
        return dest;
    }

    public RelativeTime add(RelativeTime time, RelativeTime dest) {
        if (time == null) {
            throw new IllegalArgumentException("time is null");
        }
        if (this.clock != time.clock) {
            throw new IllegalArgumentException("clock mismatch");
        }
        return this.add(time.getMilliseconds(), time.getNanoseconds(), dest);
    }

    public RelativeTime subtract(RelativeTime time) {
        if (time == null) {
            throw new IllegalArgumentException("time is null");
        }
        if (this.clock != time.clock) {
            throw new IllegalArgumentException("clock mismatch");
        }
        RelativeTime result = new RelativeTime(this.millis - time.getMilliseconds(), this.nanos - time.getNanoseconds(), this.clock);
        result.setNormalized(result.millis, result.nanos);
        return result;
    }

    public RelativeTime subtract(RelativeTime time, RelativeTime dest) {
        if (time == null) {
            throw new IllegalArgumentException("time is null");
        }
        if (this.clock != time.clock) {
            throw new IllegalArgumentException("clock mismatch");
        }
        if (dest == null) {
            dest = new RelativeTime(this.millis - time.getMilliseconds(), this.nanos - time.getNanoseconds(), this.clock);
        } else {
            dest.set(this.millis - time.getMilliseconds(), this.nanos - time.getNanoseconds());
        }
        dest.setNormalized(dest.millis, dest.nanos);
        return dest;
    }
}

