/*
 * Decompiled with CFR 0.152.
 */
package javax.realtime;

import devices.Console;
import javax.realtime.AllocationContext;
import javax.safetycritical.ManagedSchedulable;
import javax.safetycritical.ScjProcess;
import javax.safetycritical.Services;
import javax.safetycritical.annotate.Level;
import javax.safetycritical.annotate.SCJAllowed;
import reflect.ObjectInfo;
import vm.Memory;

@SCJAllowed(value=Level.INFRASTRUCTURE)
public abstract class MemoryArea
implements AllocationContext {
    protected static MemoryArea head;
    protected static int OverAllBackingStoreBase;
    protected static int OverAllBackingStoreEnd;
    private static boolean flag;
    private int remainingBackingstoreSize;
    private int backingstoreBase;
    private int backingstoreEnd;
    protected MemoryArea backingStoreProvider;
    protected MemoryArea next;
    protected Memory delegate;

    static {
        flag = true;
    }

    MemoryArea() {
    }

    protected MemoryArea(int size, int backingstoreSize, MemoryArea backingStoreProvider) {
        int backingStoreEnd;
        int base = this.getBase(backingstoreSize, backingStoreProvider);
        int n = backingStoreEnd = backingStoreProvider != null ? backingStoreProvider.getBackingstoreEnd() : OverAllBackingStoreEnd;
        if (backingstoreSize - size >= 0 && base + backingstoreSize <= backingStoreEnd) {
            this.backingStoreProvider = backingStoreProvider;
            this.delegate = new Memory(base, size);
            this.next = null;
            if (backingStoreProvider != null) {
                backingStoreProvider.setRemainingBackingstoreSize(backingStoreProvider.getRemainingBackingstoreSize() - backingstoreSize);
            }
        } else {
            throw new OutOfMemoryError("thrown from MemoryArea :: constructor : Out of backingstore exception: size: " + size + " backingStoreSize: " + backingstoreSize + " base: " + base + " backingStoreEnd: " + backingStoreEnd);
        }
        this.backingstoreBase = this.delegate.getBase();
        this.backingstoreEnd = this.backingstoreBase + backingstoreSize;
        this.remainingBackingstoreSize = backingstoreSize - size;
        MemoryArea.linkMemoryArea(this);
    }

    private int getBase(int backingstoreSize, MemoryArea backingStoreProvider) {
        int endRange = backingStoreProvider == null ? OverAllBackingStoreEnd : backingStoreProvider.backingstoreEnd;
        int base = backingStoreProvider == null ? OverAllBackingStoreBase : backingStoreProvider.backingstoreBase;
        MemoryArea first = backingStoreProvider == null ? head : backingStoreProvider;
        while (first != null) {
            int baseRange = backingStoreProvider == first ? first.delegate.getSize() + first.delegate.getBase() : first.backingstoreEnd;
            MemoryArea next = this.getFirstMemoryInRange(baseRange, endRange);
            if (next != null && next.delegate.getBase() - baseRange >= backingstoreSize) {
                return baseRange;
            }
            base = baseRange;
            first = next;
        }
        return base;
    }

    private MemoryArea getFirstMemoryInRange(int base, int end) {
        MemoryArea current = head;
        while (current != null) {
            if (current.delegate.getBase() >= base && current.delegate.getBase() + current.delegate.getSize() <= end) {
                return current;
            }
            current = current.next;
        }
        return null;
    }

    private static void linkMemoryArea(MemoryArea memoryArea) {
        if (head == null) {
            head = memoryArea;
        } else {
            MemoryArea current = head;
            while (current.next != null && current.next.delegate.getBase() < memoryArea.delegate.getBase()) {
                current = current.next;
            }
            MemoryArea temp = current.next;
            current.next = memoryArea;
            memoryArea.next = temp;
        }
    }

    protected void removeMemArea() {
        if (this != head) {
            MemoryArea current = head;
            while (current.next != this) {
                current = current.next;
            }
            current.next = this.next;
            if (this.backingStoreProvider != null) {
                this.backingStoreProvider.setRemainingBackingstoreSize(this.backingStoreProvider.getRemainingBackingstoreSize() + this.backingstoreEnd - this.backingstoreBase);
            }
        }
    }

    @SCJAllowed
    public static MemoryArea getMemoryArea(Object object) {
        int ref = ObjectInfo.getAddress(object);
        MemoryArea current = head;
        while (current != null) {
            if (current.delegate.getBase() <= ref && ref < current.delegate.getBase() + current.delegate.getSize()) {
                return current;
            }
            current = current.next;
        }
        return null;
    }

    @Override
    @SCJAllowed
    public abstract long memoryConsumed();

    @Override
    @SCJAllowed
    public abstract long memoryRemaining();

    @Override
    @SCJAllowed
    public abstract long size();

    protected void resizeMemArea(long newSize) {
        if (this.memoryConsumed() <= newSize && (long)this.delegate.getBase() + newSize <= (long)this.backingstoreEnd && (long)this.remainingBackingstoreSize == (long)this.getBackingStoreSize() - this.size()) {
            this.remainingBackingstoreSize += (int)((long)this.delegate.getSize() - newSize);
        } else {
            throw new OutOfMemoryError("thrown from MemoryArea :: resizeMem : Out of backingstore exception ");
        }
        this.delegate.resize((int)newSize);
    }

    public static int getRemainingMemorySize() {
        if (head == null) {
            return OverAllBackingStoreEnd - OverAllBackingStoreBase;
        }
        int maxEnd = 0;
        MemoryArea current = head;
        while (current != null) {
            maxEnd = maxEnd > current.backingstoreEnd ? maxEnd : current.backingstoreEnd;
            current = current.next;
        }
        return OverAllBackingStoreEnd - maxEnd;
    }

    protected int getBackingstoreEnd() {
        return this.backingstoreEnd;
    }

    public int getRemainingBackingstoreSize() {
        return this.remainingBackingstoreSize;
    }

    public void setRemainingBackingstoreSize(int BackingstoreSizeOfThisMemory) {
        this.remainingBackingstoreSize = BackingstoreSizeOfThisMemory;
    }

    private int getBackingStoreSize() {
        return this.backingstoreEnd - this.backingstoreBase;
    }

    @SCJAllowed(value=Level.INFRASTRUCTURE)
    protected void enter(Runnable logic) throws IllegalArgumentException {
        if (logic == null || !(logic instanceof ManagedSchedulable)) {
            throw new IllegalArgumentException();
        }
        ManagedSchedulable ms = (ManagedSchedulable)logic;
        MemoryArea outer = ms.getCurrentMemory();
        ms.setCurrentMemory(this);
        ms.setTopMemory(this);
        outer.delegate.switchToArea(this.delegate);
        logic.run();
        this.delegate.switchToArea(outer.delegate);
        this.delegate.reset(0);
        ms.setCurrentMemory(outer);
        ms.setTopMemory(outer);
    }

    @SCJAllowed
    protected void executeInArea(Runnable logic) throws IllegalArgumentException {
        if (logic == null) {
            throw new IllegalArgumentException("executeInArea: logic is null");
        }
        if (flag) {
            flag = false;
            Memory currentMem = Memory.getHeapArea();
            currentMem.switchToArea(this.delegate);
            logic.run();
            this.delegate.switchToArea(currentMem);
        } else {
            ScjProcess currProcess = Services.getCurrentProcess();
            if (currProcess == null) {
                throw new IllegalArgumentException("executeInArea: process is null");
            }
            ManagedSchedulable currSO = currProcess.target;
            MemoryArea outer = currSO.getCurrentMemory();
            currSO.setCurrentMemory(this);
            outer.delegate.switchToArea(this.delegate);
            logic.run();
            this.delegate.switchToArea(outer.delegate);
            currSO.setCurrentMemory(outer);
        }
    }

    public static void showLink() {
        MemoryArea current = head;
        while (current != null) {
            Console.println("\t\t\t\t\t\t\t\t\t                                 \t \t***" + current.delegate.getBase());
            current = current.next;
        }
    }
}

