/*
 * Decompiled with CFR 0.152.
 */
package devices.CR16C.KT4585;

import devices.CR16C.KT4585.CR16CInterruptDispatcher;
import devices.CR16C.KT4585.DeviceRegShort;
import icecaptools.IcecapCompileMe;
import javax.realtime.AbsoluteTime;
import vm.InterruptDispatcher;
import vm.InterruptHandler;
import vm.RealtimeClock;

public class CR16CRealtimeClock
extends RealtimeClock
implements InterruptHandler {
    private DeviceRegShort INT1_PRIORITY_REG = new DeviceRegShort(16733190);
    private DeviceRegShort TIMER1_RELOAD_N_REG = new DeviceRegShort(16730490);
    private DeviceRegShort TIMER_CTRL_REG = new DeviceRegShort(16730480);
    private DeviceRegShort RESET_INT_PENDING_REG = new DeviceRegShort(16733186);
    private static final short TIM1_MODE = 32;
    private static final short TIM1_CTRL = 2;
    private static final short CLK_CTRL1 = 8;
    private static final short TIM1_INT_PEND = 256;
    private short tickCount;

    public CR16CRealtimeClock() {
        this.INT1_PRIORITY_REG.reg = (short)(this.INT1_PRIORITY_REG.reg | 1);
        this.TIMER1_RELOAD_N_REG.reg = (short)11520;
        this.TIMER_CTRL_REG.reg = (short)42;
        this.tickCount = 0;
    }

    @Override
    public int getGranularity() {
        return 100000000;
    }

    @Override
    public void getCurrentTime(AbsoluteTime now) {
        now.set(this.tickCount * 100);
    }

    @Override
    @IcecapCompileMe
    public void handle() {
        this.tickCount = (short)(this.tickCount + 1);
        this.RESET_INT_PENDING_REG.reg = (short)(this.RESET_INT_PENDING_REG.reg | 0x100);
    }

    public short getTickCount() {
        return this.tickCount;
    }

    @Override
    public void register() {
        CR16CInterruptDispatcher.init();
        InterruptDispatcher.registerHandler(this, (byte)24);
    }

    @Override
    public void enable() {
    }

    @Override
    public void disable() {
    }
}

