package uk.ac.york.tokeneer.realworld;

/**
 * Interface describing a controller for the real world Latch.
 * 
 * @author Jon Co
 * 
 */
public interface Latch {

	/**
	 * Get the current state of the latch as stored in this controller. If the
	 * current real world state is needed use {@link #updatelatchState()}.
	 * 
	 * @return The current state of the latch as stored in this controller.
	 */
	public LatchState getState();

	/**
	 * Get the current state of the latch in the real world and update this
	 * controllers internal representation.
	 * 
	 * @return The current state of the latch in the real world.
	 */
	public LatchState pollState();

	/**
	 * Lock the latch in the real world.
	 */
	public void lock();

	/**
	 * Unlock the latch.
	 */
	public void unlock();
}
