package uk.ac.york.tokeneer.realworld;


/**
 * Implementation of {@link TokenReader} for use in simulation.
 * 
 * @author Jon Co
 * 
 */
public class DummyTokenReader implements TokenReader {

	/**
	 * Internal representation of the last read token
	 */
	private volatile String token;

	/**
	 * Private constructor - instance controlled.
	 */
	public DummyTokenReader() {
		;
	}

	@Override
	public String getToken() {
		return this.token;
	}

	@Override
	public synchronized String pollToken() {
		this.token = DummyRealWorld.getInstance().getToken();
		return this.token;
	}

	@Override
	public void clearToken() {
		this.token = null;
	}
}
