package uk.ac.york.tokeneer.realworld;

import uk.ac.york.tokeneer.Log;

/**
 * Dummy implementation of {@link Latch} for simulation purposes.
 * 
 * @author Jon Co
 * 
 */
public class DummyLatch implements Latch {
	
	// Tag for logging purposes
	private static final String TAG = "DummyLatch";

	// Internal representation of Latch
	private volatile LatchState state = LatchState.UNKNOWN;

	/**
	 * Default Constructor
	 */
	public DummyLatch() {
		;
	}

	@Override
	public synchronized LatchState getState() {
		return this.state;
	}

	@Override
	public synchronized LatchState pollState() {
		this.state = DummyRealWorld.getInstance().getLatch();
		return this.state;
	}

	@Override
	public synchronized void lock() {
		DummyRealWorld.getInstance().setLatch(LatchState.LOCKED);
		this.state = LatchState.LOCKED;
		Log.i(TAG, "Latch Locked");
	}

	@Override
	public synchronized void unlock() {
		DummyRealWorld.getInstance().setLatch(LatchState.UNLOCKED);
		this.state = LatchState.UNLOCKED;
		Log.i(TAG, "Latch Unlocked");
	}

}
