package uk.ac.york.tokeneer.realworld;

import uk.ac.york.tokeneer.Log;

/**
 * Dummy implementation of {@link Alarm} for simulation purposes.
 * 
 * @author Jon Co
 * 
 */
public class DummyAlarm implements Alarm {
	
	// Tag for logging purposes
	private static final String TAG = "DummyAlarm";
	
	// Internal representation of Latch
	private volatile AlarmState state = AlarmState.UNKNOWN;

	/**
	 * Default Constructor
	 */
	public DummyAlarm() {
		;
	}

	@Override
	public synchronized AlarmState getState() {
		return this.state;
	}

	@Override
	public synchronized void activate() {
		DummyRealWorld.getInstance().setAlarm(AlarmState.ON);
		this.state = AlarmState.ON;
		Log.i(TAG, "Alarm Activated");
	}

	@Override
	public synchronized void deactivate() {
		DummyRealWorld.getInstance().setAlarm(AlarmState.OFF);
		this.state = AlarmState.OFF;
		Log.i(TAG, "Alarm Deactivated");
	}

	@Override
	public synchronized AlarmState pollState() {
		this.state = DummyRealWorld.getInstance().getAlarm();
		return this.state;
	}

}
