package uk.ac.york.tokeneer;

import javax.realtime.AperiodicParameters;
import javax.realtime.HighResolutionTime;
import javax.realtime.PriorityParameters;
import javax.safetycritical.OneShotEventHandler;
import javax.safetycritical.StorageConfigurationParameters;

/**
 * Generic implementation of a Timeout.
 * 
 * @author Jon Co
 * 
 */
public abstract class AbstractTimeout extends OneShotEventHandler {
	
	private final HighResolutionTime timeout;

	// @formatter:off
	public AbstractTimeout(HighResolutionTime timeout,
			PriorityParameters priority,
			AperiodicParameters release,
			StorageConfigurationParameters storage, 
			long size) {
		this(timeout, priority, release, storage, size, null);
	}

	public AbstractTimeout(HighResolutionTime timeout,
			PriorityParameters priority,
			AperiodicParameters release,
			StorageConfigurationParameters storage, 
			long size, 
			String name) {
		super(priority, null, release, storage, size, name);
		this.timeout = timeout;
	}
	// @formatter:on
	
	/**
	 * Start this Timeout. Once the timeout has elapsed, the 
	 * {@link #handleEvent()} method will be called.
	 */
	public void startTimeout() {
		super.scheduleNextReleaseTime(timeout);
	}

	/**
	 * @deprecated Unsafe to use as it ignores predefined timeout. Use
	 *             {@link #startTimeout()} method to schedule the next release.
	 * @throws UnsupportedOperationException
	 *             Thrown if this method is used - use {@link #startTimeout()}
	 *             instead.
	 */
	@Override
	public void scheduleNextReleaseTime(HighResolutionTime time) {
		throw new UnsupportedOperationException("Use startTimeout method");
	}
}
