/*
 * Decompiled with CFR 0.152.
 */
package test.icecaptools;

import icecaptools.ClassManager;
import icecaptools.RawByteCodes;
import icecaptools.stackanalyser.AbstractStack;
import icecaptools.stackanalyser.ArrayRefType;
import icecaptools.stackanalyser.NonRefType;
import icecaptools.stackanalyser.RefType;
import icecaptools.stackanalyser.StackReferencesAnalyser;
import icecaptools.stackanalyser.UnknownType;
import java.util.Iterator;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.junit.Assert;
import org.junit.Test;

public class TestMethodAnalyser {
    @Test
    public void testMergeStackCell() {
        AbstractStack.StackCell src = new AbstractStack.StackCell();
        Assert.assertNotNull((Object)src.content);
        Assert.assertTrue((boolean)(src.content instanceof UnknownType));
        AbstractStack.StackCell other = new AbstractStack.StackCell();
        other.content = new RefType();
        try {
            src.merge(other);
        }
        catch (Exception exception) {
            Assert.fail();
        }
        Assert.assertFalse((other.content == src.content ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(src.content instanceof RefType));
        src = new AbstractStack.StackCell();
        Assert.assertNotNull((Object)src.content);
        Assert.assertTrue((boolean)(src.content instanceof UnknownType));
        other = new AbstractStack.StackCell();
        other.content = new NonRefType();
        try {
            src.merge(other);
        }
        catch (Exception exception) {
            Assert.fail();
        }
        Assert.assertFalse((other.content == src.content ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(src.content instanceof NonRefType));
        src = new AbstractStack.StackCell();
        Assert.assertNotNull((Object)src.content);
        Assert.assertTrue((boolean)(src.content instanceof UnknownType));
        other = new AbstractStack.StackCell();
        RawByteCodes.Raw_aaload bcode = new RawByteCodes.Raw_aaload();
        other.content = new ArrayRefType(bcode);
        try {
            src.merge(other);
        }
        catch (Exception exception) {
            Assert.fail();
        }
        Assert.assertFalse((other.content == src.content ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(src.content instanceof ArrayRefType));
        src = new AbstractStack.StackCell();
        RefType srcContent = new RefType();
        src.content = srcContent;
        other = new AbstractStack.StackCell();
        try {
            src.merge(other);
        }
        catch (Exception exception) {
            Assert.fail();
        }
        Assert.assertTrue((src.content == srcContent ? 1 : 0) != 0);
        src = new AbstractStack.StackCell();
        srcContent = new RefType();
        src.content = srcContent;
        other = new AbstractStack.StackCell();
        other.content = new RefType();
        try {
            src.merge(other);
        }
        catch (Exception exception) {
            Assert.fail();
        }
        Assert.assertTrue((src.content == srcContent ? 1 : 0) != 0);
        src = new AbstractStack.StackCell();
        src.content = new RefType();
        other = new AbstractStack.StackCell();
        other.content = new ArrayRefType(bcode);
        try {
            src.merge(other);
        }
        catch (Exception exception) {
            Assert.fail();
        }
        Assert.assertTrue((src.content != other.content ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(src.content instanceof ArrayRefType));
        src = new AbstractStack.StackCell();
        src.content = new RefType();
        other = new AbstractStack.StackCell();
        other.content = new NonRefType();
        try {
            src.merge(other);
            Assert.fail();
        }
        catch (Exception exception) {}
        try {
            other.merge(src);
            Assert.fail();
        }
        catch (Exception exception) {}
        src = new AbstractStack.StackCell();
        src.content = new ArrayRefType(bcode);
        other = new AbstractStack.StackCell();
        other.content = new NonRefType();
        try {
            src.merge(other);
            Assert.fail();
        }
        catch (Exception exception) {}
        try {
            other.merge(src);
            Assert.fail();
        }
        catch (Exception exception) {}
    }

    @Test
    public void testCopyStackCell() {
        AbstractStack.StackCell src = new AbstractStack.StackCell();
        Assert.assertNotNull((Object)src.content);
        Assert.assertTrue((boolean)(src.content instanceof UnknownType));
        AbstractStack.StackCell copy = src.copy();
        Assert.assertFalse((copy == src ? 1 : 0) != 0);
        Assert.assertFalse((copy.content == src.content ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(copy.content instanceof UnknownType));
        src = new AbstractStack.StackCell();
        src.content = new RefType();
        copy = src.copy();
        Assert.assertFalse((copy.content == src.content ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(copy.content instanceof RefType));
        Assert.assertTrue((((RefType)src.content).getState() == RefType.RefState.UNKNOWN ? 1 : 0) != 0);
        Assert.assertTrue((((RefType)copy.content).getState() == RefType.RefState.UNKNOWN ? 1 : 0) != 0);
        ((RefType)src.content).setState(RefType.RefState.NONNULL);
        copy = src.copy();
        Assert.assertTrue((((RefType)copy.content).getState() == RefType.RefState.NONNULL ? 1 : 0) != 0);
        ((RefType)src.content).setState(RefType.RefState.NULL);
        copy = src.copy();
        Assert.assertTrue((((RefType)copy.content).getState() == RefType.RefState.NULL ? 1 : 0) != 0);
        src = new AbstractStack.StackCell();
        src.content = new NonRefType();
        copy = src.copy();
        Assert.assertTrue((boolean)(copy.content instanceof NonRefType));
        src = new AbstractStack.StackCell();
        copy = src.copy();
        Assert.assertTrue((boolean)(copy.content instanceof UnknownType));
        src = new AbstractStack.StackCell();
        RawByteCodes.Raw_aaload bcode = new RawByteCodes.Raw_aaload();
        src.content = new ArrayRefType(bcode);
        copy = src.copy();
        Assert.assertTrue((boolean)(copy.content instanceof ArrayRefType));
        Iterator<RawByteCodes.RawBytecode> pushers = ((ArrayRefType)copy.content).getPushers();
        int count = 0;
        while (pushers.hasNext()) {
            Assert.assertTrue((pushers.next() == bcode ? 1 : 0) != 0);
            ++count;
        }
        Assert.assertTrue((count == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testReferenceAnalyserInvokeSpecial() {
        int didIt = 0;
        try {
            Method[] methods;
            JavaClass clazz = Repository.lookupClass((String)"test.icecapvm.minitests.ANTTestInvokeSpecial");
            Method[] methodArray = methods = clazz.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractStack.StackCell top;
                StackReferencesAnalyser analyser;
                Method method = methodArray[n2];
                if (method.getName().equals("test1")) {
                    analyser = new StackReferencesAnalyser(method, clazz);
                    analyser.analyseStackUsage();
                    AbstractStack stackAt4 = analyser.getStackLayout(4);
                    top = stackAt4.peek();
                    Assert.assertTrue((boolean)(top.content instanceof RefType));
                    Assert.assertTrue((((RefType)top.content).getState() == RefType.RefState.NONNULL ? 1 : 0) != 0);
                    ++didIt;
                }
                if (method.getName().equals("test2")) {
                    analyser = new StackReferencesAnalyser(method, clazz);
                    analyser.analyseStackUsage();
                    AbstractStack stackAt7 = analyser.getStackLayout(7);
                    top = stackAt7.peek();
                    Assert.assertTrue((boolean)(top.content instanceof RefType));
                    Assert.assertTrue((((RefType)top.content).getState() == RefType.RefState.NONNULL ? 1 : 0) != 0);
                    AbstractStack stackAt8 = analyser.getStackLayout(8);
                    top = stackAt8.peek();
                    Assert.assertTrue((boolean)(top.content instanceof RefType));
                    Assert.assertTrue((((RefType)top.content).getState() == RefType.RefState.NONNULL ? 1 : 0) != 0);
                    AbstractStack stackAt11 = analyser.getStackLayout(11);
                    top = stackAt11.peek();
                    Assert.assertTrue((boolean)(top.content instanceof RefType));
                    Assert.assertTrue((((RefType)top.content).getState() == RefType.RefState.NONNULL ? 1 : 0) != 0);
                    AbstractStack stackAt16 = analyser.getStackLayout(16);
                    top = stackAt16.peek();
                    Assert.assertTrue((boolean)(top.content instanceof RefType));
                    Assert.assertTrue((((RefType)top.content).getState() == RefType.RefState.NULL ? 1 : 0) != 0);
                    AbstractStack stackAt17 = analyser.getStackLayout(17);
                    top = stackAt17.peek();
                    Assert.assertTrue((boolean)(top.content instanceof RefType));
                    Assert.assertTrue((((RefType)top.content).getState() == RefType.RefState.UNKNOWN ? 1 : 0) != 0);
                    ++didIt;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            Assert.fail();
        }
        Assert.assertTrue((didIt == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testReferenceAnalyserArrayAccess1() {
        int didIt = 0;
        try {
            Method[] methods;
            JavaClass clazz = Repository.lookupClass((String)"test.icecapvm.minitests.TestProgram1");
            Method[] methodArray = methods = clazz.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.getName().equals("quicksort")) {
                    StackReferencesAnalyser analyser = new StackReferencesAnalyser(method, clazz);
                    analyser.analyseStackUsage();
                    AbstractStack stackAt24 = analyser.getStackLayout(24);
                    AbstractStack.StackCell top = stackAt24.getAt(stackAt24.getSize() - 2);
                    Assert.assertTrue((boolean)(top.content instanceof RefType));
                    Assert.assertTrue((((RefType)top.content).getState() == RefType.RefState.NONNULL ? 1 : 0) != 0);
                    ++didIt;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            Assert.fail();
        }
        Assert.assertTrue((didIt == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testReferenceAnalyserArrayAccess2() {
        int didIt = 0;
        try {
            Method[] methods;
            JavaClass clazz = Repository.lookupClass((String)"test.icecapvm.minitests.ANTTestArray1");
            Method[] methodArray = methods = clazz.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.getName().equals("testArrayAccess")) {
                    StackReferencesAnalyser analyser = new StackReferencesAnalyser(method, clazz);
                    analyser.analyseStackUsage();
                    AbstractStack stackAt5 = analyser.getStackLayout(5);
                    AbstractStack.StackCell top = stackAt5.peek();
                    Assert.assertTrue((boolean)(top.content instanceof RefType));
                    Assert.assertTrue((((RefType)top.content).getState() == RefType.RefState.NONNULL ? 1 : 0) != 0);
                    AbstractStack stackAt10 = analyser.getStackLayout(10);
                    top = stackAt10.peek();
                    Assert.assertTrue((boolean)(top.content instanceof RefType));
                    Assert.assertTrue((((RefType)top.content).getState() == RefType.RefState.NONNULL ? 1 : 0) != 0);
                    ++didIt;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            Assert.fail();
        }
        Assert.assertTrue((didIt == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testReferenceAnalyserArraySimple() {
        int didIt = 0;
        try {
            Method[] methods;
            JavaClass clazz = Repository.lookupClass((String)"test.icecapvm.minitests.ANTTestArraySimple");
            Method[] methodArray = methods = clazz.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.getName().equals("test")) {
                    StackReferencesAnalyser analyser = new StackReferencesAnalyser(method, clazz);
                    analyser.analyseStackUsage();
                    AbstractStack stackAt21 = analyser.getStackLayout(21);
                    AbstractStack.StackCell top = stackAt21.peek();
                    Assert.assertTrue((boolean)(top.content instanceof ArrayRefType));
                    Assert.assertTrue((((RefType)top.content).getState() == RefType.RefState.NONNULL ? 1 : 0) != 0);
                    AbstractStack stackAt11 = analyser.getStackLayout(11);
                    top = stackAt11.peek();
                    Assert.assertTrue((boolean)(top.content instanceof ArrayRefType));
                    Assert.assertTrue((((RefType)top.content).getState() == RefType.RefState.NONNULL ? 1 : 0) != 0);
                    ++didIt;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            Assert.fail();
        }
        Assert.assertTrue((didIt == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testReferenceAnalyserArraySimple1() {
        int didIt = 0;
        try {
            Method[] methods;
            JavaClass clazz = Repository.lookupClass((String)"java.lang.IllegalArgumentException");
            Method[] methodArray = methods = clazz.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                String signature;
                Method method = methodArray[n2];
                if (method.getName().equals("<init>") && "(Ljava/lang/String;)V".equals(signature = method.getSignature())) {
                    StackReferencesAnalyser analyser = new StackReferencesAnalyser(method, clazz);
                    analyser.analyseStackUsage();
                    AbstractStack stackAt1 = analyser.getStackLayout(1);
                    AbstractStack.StackCell top = stackAt1.peek();
                    Assert.assertTrue((boolean)(top.content instanceof RefType));
                    Assert.assertTrue((((RefType)top.content).getState() == RefType.RefState.NONNULL ? 1 : 0) != 0);
                    AbstractStack stackAt2 = analyser.getStackLayout(2);
                    top = stackAt2.peek();
                    Assert.assertTrue((boolean)(top.content instanceof RefType));
                    Assert.assertTrue((((RefType)top.content).getState() == RefType.RefState.UNKNOWN ? 1 : 0) != 0);
                    ++didIt;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            Assert.fail();
        }
        Assert.assertTrue((didIt == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testReferenceAnalyserIf() {
        int didIt = 0;
        try {
            Method[] methods;
            JavaClass clazz = Repository.lookupClass((String)"test.icecapvm.minitests.ANTTestIf");
            Method[] methodArray = methods = clazz.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractStack stackAt17;
                AbstractStack.StackCell top;
                StackReferencesAnalyser analyser;
                Method method = methodArray[n2];
                if (method.getName().equals("test1")) {
                    analyser = new StackReferencesAnalyser(method, clazz);
                    analyser.analyseStackUsage();
                    AbstractStack stackAt5 = analyser.getStackLayout(5);
                    top = stackAt5.peek();
                    Assert.assertTrue((boolean)(top.content instanceof RefType));
                    Assert.assertTrue((((RefType)top.content).getState() == RefType.RefState.NULL ? 1 : 0) != 0);
                    stackAt17 = analyser.getStackLayout(17);
                    top = stackAt17.peek();
                    Assert.assertTrue((boolean)(top.content instanceof ArrayRefType));
                    Assert.assertTrue((((RefType)top.content).getState() == RefType.RefState.UNKNOWN ? 1 : 0) != 0);
                    ++didIt;
                }
                if (method.getName().equals("test2")) {
                    analyser = new StackReferencesAnalyser(method, clazz);
                    analyser.analyseStackUsage();
                    AbstractStack stackAt8 = analyser.getStackLayout(8);
                    top = stackAt8.peek();
                    Assert.assertTrue((boolean)(top.content instanceof ArrayRefType));
                    Assert.assertTrue((((RefType)top.content).getState() == RefType.RefState.NONNULL ? 1 : 0) != 0);
                    stackAt17 = analyser.getStackLayout(17);
                    top = stackAt17.peek();
                    Assert.assertTrue((boolean)(top.content instanceof ArrayRefType));
                    Assert.assertTrue((((RefType)top.content).getState() == RefType.RefState.NONNULL ? 1 : 0) != 0);
                    ++didIt;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            Assert.fail();
        }
        Assert.assertTrue((didIt == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testReferenceAnalyserIf1() {
        int didIt = 0;
        try {
            Method[] methods;
            JavaClass clazz = Repository.lookupClass((String)"test.icecapvm.minitests.ANTTestIf");
            Method[] methodArray = methods = clazz.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.getName().equals("test3")) {
                    StackReferencesAnalyser analyser = new StackReferencesAnalyser(method, clazz);
                    analyser.analyseStackUsage();
                    AbstractStack stackAt7 = analyser.getStackLayout(7);
                    AbstractStack.StackCell top = stackAt7.peek();
                    Assert.assertTrue((boolean)(top.content instanceof RefType));
                    Assert.assertTrue((((RefType)top.content).getState() == RefType.RefState.NONNULL ? 1 : 0) != 0);
                    AbstractStack stackAt15 = analyser.getStackLayout(15);
                    top = stackAt15.peek();
                    Assert.assertTrue((boolean)(top.content instanceof RefType));
                    Assert.assertTrue((((RefType)top.content).getState() == RefType.RefState.NONNULL ? 1 : 0) != 0);
                    AbstractStack stackAt19 = analyser.getStackLayout(19);
                    top = stackAt19.peek();
                    Assert.assertTrue((boolean)(top.content instanceof RefType));
                    Assert.assertTrue((((RefType)top.content).getState() == RefType.RefState.UNKNOWN ? 1 : 0) != 0);
                    AbstractStack stackAt21 = analyser.getStackLayout(21);
                    top = stackAt21.peek();
                    Assert.assertTrue((boolean)(top.content instanceof RefType));
                    Assert.assertTrue((((RefType)top.content).getState() == RefType.RefState.UNKNOWN ? 1 : 0) != 0);
                    ++didIt;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            Assert.fail();
        }
        Assert.assertTrue((didIt == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testReferenceAnalyserSimple() {
        boolean didIt = false;
        try {
            Method[] methods;
            JavaClass clazz = Repository.lookupClass((String)"test.icecapvm.minitests.ANTTestArray");
            Method[] methodArray = methods = clazz.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.getName().equals("test")) {
                    StackReferencesAnalyser analyser = new StackReferencesAnalyser(method, clazz);
                    analyser.analyseStackUsage();
                    AbstractStack stringAt4 = analyser.getStackLayout(4);
                    AbstractStack.StackCell top = stringAt4.peek();
                    Assert.assertTrue((boolean)(top.content instanceof RefType));
                    RefType topContent = (RefType)top.content;
                    Assert.assertTrue((topContent.getState() == RefType.RefState.NONNULL ? 1 : 0) != 0);
                    AbstractStack stringAt21 = analyser.getStackLayout(21);
                    top = stringAt21.peek();
                    Assert.assertTrue((boolean)(top.content instanceof RefType));
                    topContent = (RefType)top.content;
                    Assert.assertTrue((topContent.getState() == RefType.RefState.NONNULL ? 1 : 0) != 0);
                    didIt = true;
                }
                ++n2;
            }
            clazz = null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Assert.fail();
        }
        catch (Exception exception) {
            Assert.fail();
        }
        Assert.assertTrue((boolean)didIt);
    }

    @Test
    public void testReferenceAnalyserArrayLength() {
        boolean didIt = false;
        try {
            Method[] methods;
            JavaClass clazz = Repository.lookupClass((String)"test.icecapvm.minitests.ANTTestArrayLength");
            Method[] methodArray = methods = clazz.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.getName().equals("test")) {
                    StackReferencesAnalyser analyser = new StackReferencesAnalyser(method, clazz);
                    analyser.analyseStackUsage();
                    AbstractStack stackAt3 = analyser.getStackLayout(3);
                    AbstractStack.StackCell top = stackAt3.peek();
                    Assert.assertTrue((boolean)(top.content instanceof RefType));
                    RefType topContent = (RefType)top.content;
                    Assert.assertTrue((topContent.getState() == RefType.RefState.NONNULL ? 1 : 0) != 0);
                    AbstractStack stackAt5 = analyser.getStackLayout(5);
                    top = stackAt5.peek();
                    Assert.assertTrue((boolean)(top.content instanceof RefType));
                    topContent = (RefType)top.content;
                    Assert.assertTrue((topContent.getState() == RefType.RefState.NONNULL ? 1 : 0) != 0);
                    didIt = true;
                }
                ++n2;
            }
            clazz = null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Assert.fail();
        }
        catch (Exception exception) {
            Assert.fail();
        }
        Assert.assertTrue((boolean)didIt);
    }

    @Test
    public void testMethodAnalyser1() {
        try {
            Method[] methods;
            JavaClass clazz = Repository.lookupClass((String)"java.util.concurrent.locks.AbstractQueuedSynchronizer");
            Method[] methodArray = methods = clazz.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.getName().contains("acquireQueued")) {
                    StackReferencesAnalyser analyser = new StackReferencesAnalyser(method, clazz);
                    analyser.analyseStackUsage();
                }
                ++n2;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            Assert.fail();
        }
        catch (Exception exception) {
            Assert.fail();
        }
    }

    @Test
    public void testReferenceAnalyserInvokeSimple() {
        boolean didIt = false;
        try {
            Method[] methods;
            JavaClass clazz = Repository.lookupClass((String)"test.icecapvm.minitests.ANTTestInvokeVirtual");
            Method[] methodArray = methods = clazz.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.getName().equals("test")) {
                    StackReferencesAnalyser analyser = new StackReferencesAnalyser(method, clazz);
                    analyser.analyseStackUsage();
                    AbstractStack stringAt1 = analyser.getStackLayout(1);
                    AbstractStack.StackCell top = stringAt1.peek();
                    Assert.assertTrue((boolean)(top.content instanceof RefType));
                    Assert.assertTrue((((RefType)top.content).getState() == RefType.RefState.UNKNOWN ? 1 : 0) != 0);
                    AbstractStack stringAt5 = analyser.getStackLayout(5);
                    top = stringAt5.peek();
                    Assert.assertTrue((boolean)(top.content instanceof RefType));
                    Assert.assertTrue((((RefType)top.content).getState() == RefType.RefState.NONNULL ? 1 : 0) != 0);
                    AbstractStack stringAt9 = analyser.getStackLayout(9);
                    top = stringAt9.peek();
                    Assert.assertTrue((boolean)(top.content instanceof RefType));
                    Assert.assertTrue((((RefType)top.content).getState() == RefType.RefState.NONNULL ? 1 : 0) != 0);
                    AbstractStack stringAt13 = analyser.getStackLayout(13);
                    top = stringAt13.peek();
                    Assert.assertTrue((boolean)(top.content instanceof RefType));
                    Assert.assertTrue((((RefType)top.content).getState() == RefType.RefState.NONNULL ? 1 : 0) != 0);
                    AbstractStack stringAt17 = analyser.getStackLayout(17);
                    top = stringAt17.peek();
                    Assert.assertTrue((boolean)(top.content instanceof RefType));
                    Assert.assertTrue((((RefType)top.content).getState() == RefType.RefState.NONNULL ? 1 : 0) != 0);
                    didIt = true;
                }
                ++n2;
            }
            clazz = null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Assert.fail();
        }
        catch (Exception exception) {
            Assert.fail();
        }
        Assert.assertTrue((boolean)didIt);
    }

    @Test
    public void testReferenceAnalyserPutGetField() {
        boolean didIt = false;
        try {
            Method[] methods;
            JavaClass clazz = Repository.lookupClass((String)"test.icecapvm.minitests.ANTTestPutGetField");
            Method[] methodArray = methods = clazz.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.getName().equals("test")) {
                    StackReferencesAnalyser analyser = new StackReferencesAnalyser(method, clazz);
                    analyser.analyseStackUsage();
                    AbstractStack stackAt3 = analyser.getStackLayout(3);
                    AbstractStack.StackCell objRef = stackAt3.getAt(stackAt3.getSize() - 2);
                    Assert.assertTrue((boolean)(objRef.content instanceof RefType));
                    Assert.assertTrue((((RefType)objRef.content).getState() == RefType.RefState.UNKNOWN ? 1 : 0) != 0);
                    AbstractStack stackAt7 = analyser.getStackLayout(7);
                    objRef = stackAt7.peek();
                    Assert.assertTrue((boolean)(objRef.content instanceof RefType));
                    Assert.assertTrue((((RefType)objRef.content).getState() == RefType.RefState.NONNULL ? 1 : 0) != 0);
                    AbstractStack stackAt8 = analyser.getStackLayout(8);
                    objRef = stackAt8.peek();
                    Assert.assertTrue((boolean)(objRef.content instanceof RefType));
                    Assert.assertTrue((((RefType)objRef.content).getState() == RefType.RefState.NONNULL ? 1 : 0) != 0);
                    AbstractStack stackAt14 = analyser.getStackLayout(14);
                    objRef = stackAt14.getAt(stackAt14.getSize() - 2);
                    Assert.assertTrue((boolean)(objRef.content instanceof RefType));
                    Assert.assertTrue((((RefType)objRef.content).getState() == RefType.RefState.NONNULL ? 1 : 0) != 0);
                    AbstractStack stackAt18 = analyser.getStackLayout(18);
                    objRef = stackAt18.getAt(stackAt18.getSize() - 1);
                    Assert.assertTrue((boolean)(objRef.content instanceof RefType));
                    Assert.assertTrue((((RefType)objRef.content).getState() == RefType.RefState.NONNULL ? 1 : 0) != 0);
                    didIt = true;
                }
                ++n2;
            }
            clazz = null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Assert.fail();
        }
        catch (Exception exception) {
            Assert.fail();
        }
        Assert.assertTrue((boolean)didIt);
    }

    @Test
    public void testReferenceAnalyserThis() {
        int didIt = 0;
        try {
            Method[] methods;
            JavaClass clazz = Repository.lookupClass((String)"test.icecapvm.minitests.ANTTestThis");
            Method[] methodArray = methods = clazz.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractStack stackAt1;
                AbstractStack.StackCell objRef;
                AbstractStack stackAt0;
                StackReferencesAnalyser analyser;
                Method method = methodArray[n2];
                if (method.getName().equals("foo")) {
                    analyser = new StackReferencesAnalyser(method, clazz);
                    analyser.analyseStackUsage();
                    stackAt0 = analyser.getStackLayout(0);
                    objRef = stackAt0.peek();
                    Assert.assertTrue((boolean)(objRef.content instanceof RefType));
                    Assert.assertTrue((((RefType)objRef.content).getState() == RefType.RefState.NONNULL ? 1 : 0) != 0);
                    stackAt1 = analyser.getStackLayout(1);
                    objRef = stackAt1.peek();
                    Assert.assertTrue((boolean)(objRef.content instanceof RefType));
                    Assert.assertTrue((((RefType)objRef.content).getState() == RefType.RefState.NONNULL ? 1 : 0) != 0);
                    ++didIt;
                }
                if (method.getName().equals("bar")) {
                    analyser = new StackReferencesAnalyser(method, clazz);
                    analyser.analyseStackUsage();
                    stackAt0 = analyser.getStackLayout(0);
                    objRef = stackAt0.peek();
                    Assert.assertTrue((boolean)(objRef.content instanceof RefType));
                    Assert.assertTrue((((RefType)objRef.content).getState() == RefType.RefState.NONNULL ? 1 : 0) != 0);
                    stackAt1 = analyser.getStackLayout(1);
                    objRef = stackAt1.peek();
                    Assert.assertTrue((boolean)(objRef.content instanceof RefType));
                    Assert.assertTrue((((RefType)objRef.content).getState() == RefType.RefState.NONNULL ? 1 : 0) != 0);
                    AbstractStack stackAt3 = analyser.getStackLayout(3);
                    objRef = stackAt3.getAt(stackAt3.getSize() - 2);
                    Assert.assertTrue((boolean)(objRef.content instanceof RefType));
                    Assert.assertTrue((((RefType)objRef.content).getState() == RefType.RefState.NONNULL ? 1 : 0) != 0);
                    AbstractStack stackAt7 = analyser.getStackLayout(7);
                    objRef = stackAt7.peek();
                    Assert.assertTrue((boolean)(objRef.content instanceof RefType));
                    Assert.assertTrue((((RefType)objRef.content).getState() == RefType.RefState.NONNULL ? 1 : 0) != 0);
                    ++didIt;
                }
                ++n2;
            }
            clazz = null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            Assert.fail();
        }
        catch (Exception exception) {
            Assert.fail();
        }
        Assert.assertTrue((didIt == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testMethodAnalyser2() {
        try {
            Method[] methods;
            JavaClass clazz = Repository.lookupClass((String)"java.util.TreeMap$KeySet");
            Method[] methodArray = methods = clazz.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                if (method.getName().contains("comparator")) {
                    StackReferencesAnalyser analyser = new StackReferencesAnalyser(method, clazz);
                    analyser.analyseStackUsage();
                }
                ++n2;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            Assert.fail();
        }
        catch (Exception exception) {
            Assert.fail();
        }
    }

    public static class TestManager
    implements ClassManager {
        private void unimplemented() {
            System.out.println("unimplemented");
        }

        @Override
        public boolean skipMethodHack(String clazz, String targetMethodName, String targetMethodSignature) {
            this.unimplemented();
            return false;
        }
    }
}

