/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.views;

import icecaptools.MethodOrFieldDesc;
import icecaptools.views.UsedClass;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class UsedClasses {
    private HashMap<String, UsedClass> usedClasses = new HashMap();

    public void add(String className, String targetMethodName, String targetMethodSignature) {
        UsedClass usedClass = this.usedClasses.get(className);
        if (usedClass == null) {
            usedClass = new UsedClass(className);
            this.usedClasses.put(className, usedClass);
        }
        usedClass.add(targetMethodName, targetMethodSignature);
    }

    public Object[] toArray() {
        Object[] classes = new UsedClass[this.usedClasses.size()];
        Set<Map.Entry<String, UsedClass>> entries = this.usedClasses.entrySet();
        Iterator<Map.Entry<String, UsedClass>> iterator = entries.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Map.Entry<String, UsedClass> next = iterator.next();
            classes[i++] = next.getValue();
        }
        this.sort((UsedClass[])classes);
        return classes;
    }

    private void sort(UsedClass[] classes) {
        int top = 0;
        while (top < classes.length - 1) {
            UsedClass arg0 = classes[top];
            UsedClass arg1 = classes[top + 1];
            if (arg0.getClassName().compareTo(arg1.getClassName()) < 0) {
                ++top;
                continue;
            }
            UsedClass temp = classes[top];
            classes[top] = classes[top + 1];
            classes[top + 1] = temp;
            if (top <= 0) continue;
            --top;
        }
    }

    public UsedClass getUsedClass(MethodOrFieldDesc element) {
        return this.usedClasses.get(element.getClassName());
    }

    public int getSize() {
        return this.usedClasses.size();
    }
}

