/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.views;

import icecaptools.CanceledByUserException;
import icecaptools.IcecapIterator;
import icecaptools.MethodOrFieldDesc;
import icecaptools.RestartableMethodObserver;
import icecaptools.SetOutputFolderAction;
import icecaptools.compiler.CompilationRegistry;
import icecaptools.compiler.ICompilationRegistry;
import icecaptools.views.DELabelProvider;
import icecaptools.views.DependencyExtent;
import icecaptools.views.DependencyRoot;
import icecaptools.views.MethodListContentProvider;
import icecaptools.views.MethodListLabelProvider;
import icecaptools.views.UsedClass;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.osgi.service.prefs.BackingStoreException;

public class DependencyView
extends ViewPart
implements RestartableMethodObserver,
DELabelProvider,
IDoubleClickListener {
    private TreeViewer viewer;
    public static final String VIEWID = "icecaptools.views.dependencyextent";
    private DependencyRoot root;
    private IMethod prototype;
    private CompilationRegistry cregistry;
    private static final String COMPILATION_REGISTRY_STORE = "CompilationRegistry";
    private HashMap<String, String> addedElements;

    public void createPartControl(Composite parent) {
        this.addedElements = new HashMap();
        this.cregistry = new CompilationRegistry();
        this.viewer = new TreeViewer(parent);
        MethodListContentProvider contentProvider = new MethodListContentProvider();
        this.viewer.setContentProvider((IContentProvider)contentProvider);
        MethodListLabelProvider labelProvider = new MethodListLabelProvider(this.cregistry);
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.viewer.addDoubleClickListener((IDoubleClickListener)this);
        MenuManager menuMgr = new MenuManager("PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Action toggleAction = new Action(){

                    public void run() {
                        super.run();
                        DependencyView.this.togglePropertyOnSelection(new CompilationToggler());
                    }
                };
                toggleAction.setText("Toggle Compilation");
                manager.add((IAction)toggleAction);
                Action setOutputFolderAction = new Action(){

                    public void run() {
                        super.run();
                        DependencyView.this.setOutputFolder();
                    }
                };
                setOutputFolderAction.setText("Set output folder");
                manager.add((IAction)setOutputFolderAction);
                Action excludeMethodAction = new Action(){

                    public void run() {
                        super.run();
                        DependencyView.this.togglePropertyOnSelection(new ExclusionToggler());
                    }
                };
                excludeMethodAction.setText("Toggle exclusion");
                manager.add((IAction)excludeMethodAction);
                Action alwaysClearOutputFolder = new Action(){

                    public void run() {
                        super.run();
                        DependencyView.this.togglePropertyOnSelection(new ClearOutputFolderToggler());
                    }
                };
                alwaysClearOutputFolder.setText("Clear output folder");
                manager.add((IAction)alwaysClearOutputFolder);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.viewer.getTree());
        this.viewer.getTree().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void togglePropertyOnSelection(PropertyToggler toggler) {
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof TreeSelection) {
            TreeSelection tselection = (TreeSelection)selection;
            for (Object next : tselection) {
                if (next instanceof UsedClass) {
                    UsedClass usedClass = (UsedClass)next;
                    Iterator<MethodOrFieldDesc> methods = usedClass.getUsedMethods();
                    while (methods.hasNext()) {
                        toggler.toggleMethod(methods.next());
                    }
                    continue;
                }
                if (next instanceof MethodOrFieldDesc) {
                    MethodOrFieldDesc mdesc = (MethodOrFieldDesc)next;
                    toggler.toggleMethod(mdesc);
                    continue;
                }
                if (!(next instanceof DependencyExtent)) continue;
                toggler.toggleRootProperty();
            }
        }
        this.refresh();
    }

    private void setOutputFolder() {
        DirectoryDialog dialog = new DirectoryDialog(this.getSite().getShell(), 4096);
        String folder = dialog.open();
        SetOutputFolderAction.setOutputFolder(folder);
    }

    public void setFocus() {
    }

    @Override
    public void methodCodeUsed(String className, String targetMethodName, String targetMethodSignature, boolean report) throws CanceledByUserException {
        this.addToRoot(className, targetMethodName, targetMethodSignature);
    }

    private void addToRoot(String className, String targetMethodName, String targetMethodSignature) {
        StringBuffer key = new StringBuffer();
        key.append(className);
        key.append(targetMethodName);
        key.append(targetMethodSignature);
        String keyString = key.toString();
        if (!this.addedElements.containsKey(keyString)) {
            this.root.add(className, targetMethodName, targetMethodSignature);
            this.addedElements.put(keyString, keyString);
        }
    }

    @Override
    public void restart() {
        this.addedElements = new HashMap();
        this.root = new DependencyRoot();
        IcecapIterator<MethodOrFieldDesc> excludedMethods = this.cregistry.getExcludedMethods();
        while (excludedMethods.hasNext()) {
            MethodOrFieldDesc next = excludedMethods.next();
            this.addToRoot(next.getClassName(), next.getName(), next.getSignature());
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                DependencyView.this.viewer.setInput((Object)DependencyView.this.root);
            }
        });
        this.refresh();
    }

    @Override
    public void refresh() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                DependencyView.this.viewer.refresh();
            }
        });
    }

    @Override
    public void setLabelSource(IMethod prototype) {
        if (this.prototype != prototype) {
            this.saveCompilationPreferencesToStore();
            this.prototype = prototype;
            this.loadCompilationPreferences();
        }
    }

    @Override
    public IMethod getLabelSource() {
        return this.prototype;
    }

    public void doubleClick(DoubleClickEvent event) {
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof TreeSelection) {
            TreeSelection tselection = (TreeSelection)selection;
            Object fselection = tselection.getFirstElement();
            if (fselection instanceof UsedClass) {
                UsedClass selectedClass = (UsedClass)fselection;
                this.openJavaClassInEditor(selectedClass.getClassName());
            } else if (fselection instanceof MethodOrFieldDesc) {
                MethodOrFieldDesc selectedMethod = (MethodOrFieldDesc)fselection;
                this.openJavaMethodInEditor(selectedMethod);
            }
        }
    }

    private void openJavaMethodInEditor(MethodOrFieldDesc selectedMethod) {
        IJavaProject project = this.prototype.getJavaProject();
        try {
            IMethod[] methods;
            IType element = project.findType(selectedMethod.getClassName());
            IMethod[] iMethodArray = methods = element.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod iMethod = iMethodArray[n2];
                if (iMethod.getElementName().equals(selectedMethod.getName()) && this.compareReturnType(element.isBinary(), iMethod.getReturnType(), selectedMethod.getSignature()) && this.compareParameters(element.isBinary(), iMethod.getParameterTypes(), selectedMethod.getSignature())) {
                    try {
                        JavaUI.openInEditor((IJavaElement)iMethod);
                        return;
                    }
                    catch (PartInitException partInitException) {}
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    private boolean compareParameters(boolean isBinary, String[] parameterTypes, String methodSignature) {
        String[] pTypes = Signature.getParameterTypes((String)methodSignature);
        if (pTypes.length == parameterTypes.length) {
            int i = 0;
            while (i < pTypes.length) {
                String current = pTypes[i].replace('/', '.');
                if (isBinary) {
                    if (!current.equals(parameterTypes[i])) {
                        return false;
                    }
                } else {
                    String p1 = current;
                    String p2 = parameterTypes[i];
                    p1 = Signature.toString((String)p1);
                    p2 = Signature.toString((String)p2);
                    return p1.endsWith(p2);
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private boolean compareReturnType(boolean isBinary, String returnType, String methodSignature) {
        String rType = Signature.getReturnType((String)methodSignature);
        rType = rType.replace('/', '.');
        return returnType.equals(rType);
    }

    private void openJavaClassInEditor(String className) {
        IJavaProject project = this.prototype.getJavaProject();
        try {
            IType element = project.findType(className);
            JavaUI.openInEditor((IJavaElement)element);
        }
        catch (JavaModelException javaModelException) {
        }
        catch (PartInitException partInitException) {}
    }

    private void loadCompilationPreferences() {
        String value;
        IJavaProject project = this.prototype.getJavaProject();
        ProjectScope projectScope = new ProjectScope(project.getProject());
        IEclipsePreferences projectNode = projectScope.getNode(VIEWID);
        if (projectNode != null && (value = projectNode.get(COMPILATION_REGISTRY_STORE, null)) != null) {
            this.cregistry.initializeFromString(value);
        }
    }

    private void saveCompilationPreferencesToStore() {
        IJavaProject project;
        ProjectScope projectScope;
        IEclipsePreferences projectNode;
        if (this.prototype != null && (projectNode = (projectScope = new ProjectScope((project = this.prototype.getJavaProject()).getProject())).getNode(VIEWID)) != null) {
            projectNode.put(COMPILATION_REGISTRY_STORE, this.cregistry.encodeToString());
            try {
                projectNode.flush();
            }
            catch (BackingStoreException backingStoreException) {}
        }
    }

    public void dispose() {
        super.dispose();
        this.saveCompilationPreferencesToStore();
    }

    @Override
    public ICompilationRegistry getCompilationRegistry() {
        return this.cregistry;
    }

    private class ClearOutputFolderToggler
    implements PropertyToggler {
        private ClearOutputFolderToggler() {
        }

        @Override
        public void toggleMethod(MethodOrFieldDesc next) {
        }

        @Override
        public void toggleRootProperty() {
            DependencyView.this.cregistry.toggleFolderClearing();
        }
    }

    private class CompilationToggler
    implements PropertyToggler {
        private CompilationToggler() {
        }

        @Override
        public void toggleMethod(MethodOrFieldDesc next) {
            DependencyView.this.cregistry.toggleMethodCompilation(next);
        }

        @Override
        public void toggleRootProperty() {
        }
    }

    private class ExclusionToggler
    implements PropertyToggler {
        private ExclusionToggler() {
        }

        @Override
        public void toggleMethod(MethodOrFieldDesc next) {
            DependencyView.this.cregistry.toggleMethodExclusion(next);
        }

        @Override
        public void toggleRootProperty() {
        }
    }

    private static interface PropertyToggler {
        public void toggleMethod(MethodOrFieldDesc var1);

        public void toggleRootProperty();
    }
}

