/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.stackanalyser;

import icecaptools.ClassfileUtils;
import icecaptools.JavaArrayClass;
import icecaptools.MethodEntryPoints;
import icecaptools.RawByteCodes;
import icecaptools.compiler.LDCConstant;
import icecaptools.stackanalyser.AbstractStack;
import icecaptools.stackanalyser.RefType;
import icecaptools.stackanalyser.UnexpectedTypeException;
import icecaptools.stackanalyser.UnknownType;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantInterfaceMethodref;
import org.apache.bcel.classfile.ConstantMethodref;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class StackReferencesAnalyser {
    protected Method method;
    protected JavaClass clazz;
    private MethodEntryPoints methodEntryPoints;
    private Map<Integer, AbstractStack> stackUsage;
    Stack<WorkItem> workItems;

    public StackReferencesAnalyser(MethodEntryPoints javaMethod, JavaClass clazz) {
        this.methodEntryPoints = javaMethod;
        this.method = javaMethod.getMethod();
        this.clazz = clazz;
    }

    public StackReferencesAnalyser(Method method, JavaClass clazz2) {
        this.method = method;
    }

    private void analyseIt(int address, byte[] byteCode, AbstractStack entryStack) throws Exception {
        WorkItem newWorkItem = new WorkItem();
        newWorkItem.address = address;
        newWorkItem.byteCode = byteCode;
        newWorkItem.entryStack = entryStack;
        this.workItems = new Stack();
        this.workItems.push(newWorkItem);
        while (this.workItems.size() > 0) {
            newWorkItem = this.workItems.pop();
            this.analyseByteCode(newWorkItem.address, newWorkItem.byteCode, newWorkItem.entryStack);
        }
    }

    private void pushWorkItem(int address, byte[] byteCode, AbstractStack entryStack) {
        WorkItem newWorkItem = new WorkItem();
        newWorkItem.address = address;
        newWorkItem.byteCode = byteCode;
        newWorkItem.entryStack = entryStack;
        this.workItems.push(newWorkItem);
    }

    public void analyseStackUsage() throws Exception {
        Code code = this.method.getCode();
        if (code != null) {
            CodeException[] execptionTable;
            byte[] byteCode = code.getCode();
            AbstractStack aStack = this.createAbstractStack(code, this.method);
            this.stackUsage = new HashMap<Integer, AbstractStack>();
            this.analyseIt(0, byteCode, aStack);
            CodeException[] codeExceptionArray = execptionTable = code.getExceptionTable();
            int n = execptionTable.length;
            int n2 = 0;
            while (n2 < n) {
                CodeException codeException = codeExceptionArray[n2];
                int handlerPC = codeException.getHandlerPC();
                aStack = this.createAbstractStack(code, this.method);
                aStack.pushRef();
                this.analyseIt(handlerPC, byteCode, aStack);
                ++n2;
            }
        }
    }

    private AbstractStack createAbstractStack(Code code, Method javaMethod2) {
        Type[] args;
        AbstractStack aStack = new AbstractStack();
        int index = 0;
        if (!javaMethod2.isStatic()) {
            aStack.pushRef();
            ((RefType)aStack.peek().content).setState(RefType.RefState.NONNULL);
            ++index;
        }
        Type[] typeArray = args = javaMethod2.getArgumentTypes();
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Type type = typeArray[n2];
            switch (type.getType()) {
                case 13: 
                case 14: {
                    aStack.pushRef();
                    break;
                }
                default: {
                    aStack.pushUnknown();
                }
            }
            ++index;
            ++n2;
        }
        while (index < code.getMaxLocals()) {
            aStack.pushUnknown();
            ++index;
        }
        return aStack;
    }

    private void analyseByteCode(int address, byte[] byteCode, AbstractStack entryStack) throws Exception {
        AbstractStack exitStack;
        AbstractStack currentStack = this.stackUsage.get(address);
        if (currentStack != null) {
            if (currentStack.equals(entryStack)) {
                return;
            }
            currentStack.merge(entryStack);
            exitStack = currentStack.copy();
        } else {
            exitStack = entryStack.copy();
            this.stackUsage.put(address, entryStack);
        }
        AbstractStack.StackCell objAtTop = null;
        RawByteCodes.RawBytecode currentRawBytecode = this.methodEntryPoints.getRawByteCode(address);
        byte code = (byte)currentRawBytecode.getOpcode();
        switch (code) {
            case 0: {
                break;
            }
            case 1: {
                exitStack.pushRef();
                AbstractStack.StackCell top = exitStack.peek();
                ((RefType)top.content).setState(RefType.RefState.NULL);
                break;
            }
            case 2: {
                exitStack.pushNonRef();
                break;
            }
            case 3: {
                exitStack.pushNonRef();
                break;
            }
            case 4: {
                exitStack.pushNonRef();
                break;
            }
            case 5: {
                exitStack.pushNonRef();
                break;
            }
            case 6: {
                exitStack.pushNonRef();
                break;
            }
            case 7: {
                exitStack.pushNonRef();
                break;
            }
            case 8: {
                exitStack.pushNonRef();
                break;
            }
            case 9: {
                exitStack.pushNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 10: {
                exitStack.pushNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 11: {
                exitStack.pushNonRef();
                break;
            }
            case 12: {
                exitStack.pushNonRef();
                break;
            }
            case 13: {
                exitStack.pushNonRef();
                break;
            }
            case 14: {
                exitStack.pushNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 15: {
                exitStack.pushNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 16: {
                exitStack.pushNonRef();
                break;
            }
            case 17: {
                exitStack.pushNonRef();
                break;
            }
            case 18: {
                this.handleLDC(exitStack, currentRawBytecode, code);
                break;
            }
            case 19: {
                this.handleLDC(exitStack, currentRawBytecode, code);
                break;
            }
            case 20: {
                this.handleLDC(exitStack, currentRawBytecode, code);
                break;
            }
            case 21: {
                exitStack.pushNonRef();
                break;
            }
            case 22: {
                exitStack.pushNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 23: {
                exitStack.pushNonRef();
                break;
            }
            case 24: {
                exitStack.pushNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 26: {
                exitStack.pushNonRef();
                break;
            }
            case 27: {
                exitStack.pushNonRef();
                break;
            }
            case 28: {
                exitStack.pushNonRef();
                break;
            }
            case 29: {
                exitStack.pushNonRef();
                break;
            }
            case 30: {
                exitStack.pushNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 31: {
                exitStack.pushNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 32: {
                exitStack.pushNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 33: {
                exitStack.pushNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 34: {
                exitStack.pushNonRef();
                break;
            }
            case 35: {
                exitStack.pushNonRef();
                break;
            }
            case 36: {
                exitStack.pushNonRef();
                break;
            }
            case 37: {
                exitStack.pushNonRef();
                break;
            }
            case 38: {
                exitStack.pushNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 39: {
                exitStack.pushNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 40: {
                exitStack.pushNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 41: {
                exitStack.pushNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 25: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                int index;
                switch (code) {
                    case 42: {
                        index = 0;
                        break;
                    }
                    case 43: {
                        index = 1;
                        break;
                    }
                    case 44: {
                        index = 2;
                        break;
                    }
                    case 45: {
                        index = 3;
                        break;
                    }
                    default: {
                        index = ((RawByteCodes.Raw_aload)currentRawBytecode).localVariableIndex;
                    }
                }
                AbstractStack.StackCell element = exitStack.getAt(index);
                if (element.content.getClass() == UnknownType.class) {
                    element.content = new RefType();
                }
                element = element.copy();
                ((RefType)element.content).identicleWith = index;
                exitStack.push(element);
                break;
            }
            case 46: {
                exitStack.popNonRef();
                exitStack.popRef();
                exitStack.pushNonRef();
                break;
            }
            case 47: {
                exitStack.popNonRef();
                exitStack.popRef();
                exitStack.pushNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 48: {
                exitStack.popNonRef();
                exitStack.popRef();
                exitStack.pushNonRef();
                break;
            }
            case 49: {
                exitStack.popNonRef();
                exitStack.popRef();
                exitStack.pushNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 50: {
                exitStack.popNonRef();
                exitStack.popRef();
                exitStack.pushRef();
                break;
            }
            case 51: {
                exitStack.popNonRef();
                exitStack.popRef();
                exitStack.pushNonRef();
                break;
            }
            case 52: {
                exitStack.popNonRef();
                exitStack.popRef();
                exitStack.pushNonRef();
                break;
            }
            case 53: {
                exitStack.popNonRef();
                exitStack.popRef();
                exitStack.pushNonRef();
                break;
            }
            case 54: {
                exitStack.popNonRef();
                break;
            }
            case 55: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                break;
            }
            case 56: {
                exitStack.popNonRef();
                break;
            }
            case 57: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                break;
            }
            case 59: {
                exitStack.popNonRef();
                break;
            }
            case 60: {
                exitStack.popNonRef();
                break;
            }
            case 61: {
                exitStack.popNonRef();
                break;
            }
            case 62: {
                exitStack.popNonRef();
                break;
            }
            case 63: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                break;
            }
            case 64: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                break;
            }
            case 65: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                break;
            }
            case 66: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                break;
            }
            case 67: {
                exitStack.popNonRef();
                break;
            }
            case 68: {
                exitStack.popNonRef();
                break;
            }
            case 69: {
                exitStack.popNonRef();
                break;
            }
            case 70: {
                exitStack.popNonRef();
                break;
            }
            case 71: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                break;
            }
            case 72: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                break;
            }
            case 73: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                break;
            }
            case 74: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                break;
            }
            case 58: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                int index;
                switch (code) {
                    case 75: {
                        index = 0;
                        break;
                    }
                    case 76: {
                        index = 1;
                        break;
                    }
                    case 77: {
                        index = 2;
                        break;
                    }
                    case 78: {
                        index = 3;
                        break;
                    }
                    default: {
                        index = ((RawByteCodes.Raw_astore)currentRawBytecode).localVariableIndex;
                    }
                }
                AbstractStack.StackCell cell = exitStack.popRef();
                exitStack.setAt(index, cell.copy());
                exitStack.clear(index);
                break;
            }
            case 79: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popRef();
                break;
            }
            case 80: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popRef();
                break;
            }
            case 81: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popRef();
                break;
            }
            case 82: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popRef();
                break;
            }
            case 83: {
                exitStack.popRef();
                exitStack.popNonRef();
                exitStack.popRef();
                break;
            }
            case 84: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popRef();
                break;
            }
            case 85: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popRef();
                break;
            }
            case 86: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popRef();
                break;
            }
            case 87: {
                exitStack.popAny();
                break;
            }
            case 88: {
                exitStack.popAny();
                exitStack.popAny();
                break;
            }
            case 89: {
                AbstractStack.StackCell top = exitStack.popAny();
                int index = exitStack.getSize();
                exitStack.push(top);
                top = top.copy();
                if (top.content instanceof RefType) {
                    ((RefType)top.content).identicleWith = index;
                }
                exitStack.push(top);
                break;
            }
            case 90: {
                AbstractStack.StackCell value1 = exitStack.popAny();
                AbstractStack.StackCell value2 = exitStack.popAny();
                exitStack.push(value1);
                exitStack.push(value2);
                exitStack.push(value1);
                break;
            }
            case 91: {
                AbstractStack.StackCell value1 = exitStack.popAny();
                AbstractStack.StackCell value2 = exitStack.popAny();
                AbstractStack.StackCell value3 = exitStack.popAny();
                exitStack.push(value1);
                exitStack.push(value3);
                exitStack.push(value2);
                exitStack.push(value1);
                break;
            }
            case 92: {
                AbstractStack.StackCell value1 = exitStack.popAny();
                AbstractStack.StackCell value2 = exitStack.popAny();
                exitStack.push(value2);
                exitStack.push(value1);
                exitStack.push(value2);
                exitStack.push(value1);
                break;
            }
            case 93: {
                AbstractStack.StackCell value1 = exitStack.popAny();
                AbstractStack.StackCell value2 = exitStack.popAny();
                AbstractStack.StackCell value3 = exitStack.popAny();
                exitStack.push(value2);
                exitStack.push(value1);
                exitStack.push(value3);
                exitStack.push(value2);
                exitStack.push(value1);
                break;
            }
            case 94: {
                AbstractStack.StackCell value1 = exitStack.popAny();
                AbstractStack.StackCell value2 = exitStack.popAny();
                AbstractStack.StackCell value3 = exitStack.popAny();
                AbstractStack.StackCell value4 = exitStack.popAny();
                exitStack.push(value2);
                exitStack.push(value1);
                exitStack.push(value4);
                exitStack.push(value3);
                exitStack.push(value2);
                exitStack.push(value1);
                break;
            }
            case 95: {
                AbstractStack.StackCell value1 = exitStack.popAny();
                AbstractStack.StackCell value2 = exitStack.popAny();
                exitStack.push(value1);
                exitStack.push(value2);
                break;
            }
            case 96: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 97: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 98: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 99: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 100: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 101: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 102: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 103: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 104: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 105: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 106: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 107: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 108: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 109: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 110: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 111: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 112: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 113: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 114: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 115: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 116: {
                exitStack.popNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 117: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 118: {
                exitStack.popNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 119: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 120: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 121: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 122: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 123: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 124: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 125: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 126: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 127: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                exitStack.pushNonRef();
                break;
            }
            case -128: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                break;
            }
            case -126: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                break;
            }
            case -127: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                exitStack.pushNonRef();
                break;
            }
            case -125: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                exitStack.pushNonRef();
                break;
            }
            case -124: {
                break;
            }
            case -123: {
                exitStack.popNonRef();
                exitStack.pushNonRef();
                exitStack.pushNonRef();
                break;
            }
            case -122: {
                exitStack.popNonRef();
                exitStack.pushNonRef();
                break;
            }
            case -121: {
                exitStack.popNonRef();
                exitStack.pushNonRef();
                exitStack.pushNonRef();
                break;
            }
            case -120: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                break;
            }
            case -119: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                break;
            }
            case -118: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                exitStack.pushNonRef();
                break;
            }
            case -117: {
                exitStack.popNonRef();
                exitStack.pushNonRef();
                break;
            }
            case -116: {
                exitStack.popNonRef();
                exitStack.pushNonRef();
                exitStack.pushNonRef();
                break;
            }
            case -115: {
                exitStack.popNonRef();
                exitStack.pushNonRef();
                exitStack.pushNonRef();
                break;
            }
            case -114: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                break;
            }
            case -113: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                exitStack.pushNonRef();
                break;
            }
            case -112: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                break;
            }
            case -111: {
                exitStack.popNonRef();
                exitStack.pushNonRef();
                break;
            }
            case -110: {
                exitStack.popNonRef();
                exitStack.pushNonRef();
                break;
            }
            case -109: {
                exitStack.popNonRef();
                exitStack.pushNonRef();
                break;
            }
            case -108: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                break;
            }
            case -107: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                break;
            }
            case -106: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                break;
            }
            case -105: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                break;
            }
            case -104: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.popNonRef();
                exitStack.pushNonRef();
                break;
            }
            case -103: {
                exitStack.popNonRef();
                break;
            }
            case -102: {
                exitStack.popNonRef();
                break;
            }
            case -101: {
                exitStack.popNonRef();
                break;
            }
            case -100: {
                exitStack.popNonRef();
                break;
            }
            case -99: {
                exitStack.popNonRef();
                break;
            }
            case -98: {
                exitStack.popNonRef();
                break;
            }
            case -97: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                break;
            }
            case -96: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                break;
            }
            case -95: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                break;
            }
            case -94: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                break;
            }
            case -93: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                break;
            }
            case -92: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                break;
            }
            case -91: {
                exitStack.popRef();
                exitStack.popRef();
                break;
            }
            case -90: {
                exitStack.popRef();
                exitStack.popRef();
                break;
            }
            case -89: {
                break;
            }
            case -88: {
                break;
            }
            case -87: {
                return;
            }
            case -86: {
                exitStack.popNonRef();
                break;
            }
            case -85: {
                exitStack.popNonRef();
                break;
            }
            case -84: 
            case -83: 
            case -82: 
            case -81: 
            case -80: 
            case -79: {
                return;
            }
            case -78: {
                this.handlePutGetField(exitStack, currentRawBytecode, code);
                break;
            }
            case -77: {
                this.handlePutGetField(exitStack, currentRawBytecode, code);
                break;
            }
            case -76: {
                this.handlePutGetField(exitStack, currentRawBytecode, code);
                break;
            }
            case -75: {
                this.handlePutGetField(exitStack, currentRawBytecode, code);
                break;
            }
            case -70: {
                exitStack.pushRef();
                break;
            }
            case -74: {
                this.handleInvoke(exitStack, currentRawBytecode, code);
                break;
            }
            case -73: {
                this.handleInvoke(exitStack, currentRawBytecode, code);
                break;
            }
            case -72: {
                this.handleInvoke(exitStack, currentRawBytecode, code);
                break;
            }
            case -71: {
                this.handleInvoke(exitStack, currentRawBytecode, code);
                break;
            }
            case -69: {
                exitStack.pushRef();
                ((RefType)exitStack.peek().content).setState(RefType.RefState.NONNULL);
                break;
            }
            case -67: {
                this.handleANewArray(exitStack, currentRawBytecode);
                ((RefType)exitStack.peek().content).setState(RefType.RefState.NONNULL);
                break;
            }
            case -68: {
                this.handleNewArray(exitStack, currentRawBytecode);
                ((RefType)exitStack.peek().content).setState(RefType.RefState.NONNULL);
                break;
            }
            case -66: {
                exitStack.popRef();
                exitStack.pushNonRef();
                break;
            }
            case -65: {
                return;
            }
            case -64: {
                break;
            }
            case -63: {
                exitStack.popRef();
                exitStack.pushNonRef();
                break;
            }
            case -62: {
                exitStack.popRef();
                break;
            }
            case -61: {
                exitStack.popRef();
                break;
            }
            case -60: {
                this.handleWide(exitStack, currentRawBytecode, code);
                break;
            }
            case -59: {
                RawByteCodes.Raw_multianewarray multi = (RawByteCodes.Raw_multianewarray)currentRawBytecode;
                int dimensions = multi.count;
                while (dimensions > 0) {
                    exitStack.popNonRef();
                    --dimensions;
                }
                exitStack.pushRef();
                break;
            }
            case -58: {
                objAtTop = exitStack.popRef();
                break;
            }
            case -57: {
                objAtTop = exitStack.popRef();
                break;
            }
            case -56: {
                break;
            }
            case -55: {
                exitStack.pushNonRef();
                break;
            }
            default: {
                throw new Exception("Unknown byte code [" + code + "]");
            }
        }
        if (currentRawBytecode instanceof RawByteCodes.Raw_jsr || currentRawBytecode instanceof RawByteCodes.Raw_jsr_w) {
            RawByteCodes.RawShortBranchOperation jsr = (RawByteCodes.RawShortBranchOperation)currentRawBytecode;
            exitStack.pushRef();
            this.analyseByteCode((int)((long)address + jsr.branchoffset), byteCode, exitStack.copy());
            exitStack.popRef();
            this.pushWorkItem(address + currentRawBytecode.getSize(), byteCode, exitStack);
        } else if (currentRawBytecode instanceof RawByteCodes.RawShortBranchOperation) {
            RawByteCodes.RawShortBranchOperation branch = (RawByteCodes.RawShortBranchOperation)currentRawBytecode;
            if (code == -58) {
                RefType ref = (RefType)objAtTop.content;
                AbstractStack branchStack = exitStack.copy();
                this.storeInfoInLocal(branchStack, ref, RefType.RefState.NULL);
                this.pushWorkItem((int)((long)address + branch.branchoffset), byteCode, branchStack);
                this.storeInfoInLocal(exitStack, ref, RefType.RefState.NONNULL);
            } else {
                this.pushWorkItem((int)((long)address + branch.branchoffset), byteCode, exitStack);
            }
            if (!(currentRawBytecode instanceof RawByteCodes.Raw_goto || currentRawBytecode instanceof RawByteCodes.Raw_jsr || currentRawBytecode instanceof RawByteCodes.RawWideBranchOperation)) {
                this.pushWorkItem(address + branch.getSize(), byteCode, exitStack);
            }
        } else if (currentRawBytecode instanceof RawByteCodes.Raw_lookupswitch) {
            RawByteCodes.Raw_lookupswitch lookup = (RawByteCodes.Raw_lookupswitch)currentRawBytecode;
            RawByteCodes.Raw_lookupswitch.Pair[] pairs = lookup.pairs;
            int npairs = (int)lookup.npairs;
            int i = 0;
            while (i < npairs) {
                RawByteCodes.Raw_lookupswitch.Pair pair = pairs[i];
                this.pushWorkItem(address + pair.offset, byteCode, exitStack);
                ++i;
            }
            this.pushWorkItem((int)((long)address + lookup.defaultVal), byteCode, exitStack);
        } else if (currentRawBytecode instanceof RawByteCodes.Raw_tableswitch) {
            RawByteCodes.Raw_tableswitch table = (RawByteCodes.Raw_tableswitch)currentRawBytecode;
            long[] offsets = table.offsets;
            int i = 0;
            while (i < offsets.length) {
                this.pushWorkItem((int)((long)address + offsets[i]), byteCode, exitStack);
                ++i;
            }
            this.pushWorkItem((int)((long)address + table.defaultVal), byteCode, exitStack);
        } else {
            this.pushWorkItem(address + currentRawBytecode.getSize(), byteCode, exitStack);
        }
    }

    protected void handleNewArray(AbstractStack exitStack, RawByteCodes.RawBytecode currentRawBytecode) throws UnexpectedTypeException {
        exitStack.popNonRef();
        exitStack.pushArrayRef(currentRawBytecode);
    }

    protected void handleANewArray(AbstractStack exitStack, RawByteCodes.RawBytecode currentRawBytecode) throws UnexpectedTypeException {
        exitStack.popNonRef();
        exitStack.pushArrayRef(currentRawBytecode);
    }

    private void handleWide(AbstractStack exitStack, RawByteCodes.RawBytecode currentRawBytecode, byte code) throws UnexpectedTypeException {
        RawByteCodes.Raw_wide wide = (RawByteCodes.Raw_wide)currentRawBytecode;
        switch (wide.actualOpcode) {
            case 21: 
            case 23: {
                exitStack.pushNonRef();
                break;
            }
            case 25: {
                exitStack.pushRef();
                break;
            }
            case 22: 
            case 24: {
                exitStack.pushNonRef();
                exitStack.pushNonRef();
                break;
            }
            case 54: 
            case 56: {
                exitStack.popNonRef();
                exitStack.popNonRef();
                break;
            }
            case 58: {
                exitStack.popRef();
                break;
            }
            case 55: 
            case 57: {
                exitStack.popNonRef();
                exitStack.popNonRef();
            }
        }
    }

    private void handleInvoke(AbstractStack exitStack, RawByteCodes.RawBytecode currentRawBytecode, byte code) throws Exception {
        ConstantMethodref methodRef = null;
        ConstantClass classRef = null;
        int methodNameAndTypIndex = -1;
        if (currentRawBytecode instanceof RawByteCodes.Raw_invokevirtual) {
            RawByteCodes.Raw_invokevirtual rawInvokeVirtual = (RawByteCodes.Raw_invokevirtual)currentRawBytecode;
            int index = rawInvokeVirtual.cpIndex;
            methodRef = (ConstantMethodref)this.clazz.getConstantPool().getConstant(index);
            classRef = (ConstantClass)this.clazz.getConstantPool().getConstant(methodRef.getClassIndex());
            methodNameAndTypIndex = methodRef.getNameAndTypeIndex();
        } else if (currentRawBytecode instanceof RawByteCodes.Raw_invokespecial) {
            RawByteCodes.Raw_invokespecial rawInvokeSpecial = (RawByteCodes.Raw_invokespecial)currentRawBytecode;
            int index = rawInvokeSpecial.cpIndex;
            methodRef = (ConstantMethodref)this.clazz.getConstantPool().getConstant(index);
            classRef = (ConstantClass)this.clazz.getConstantPool().getConstant(methodRef.getClassIndex());
            methodNameAndTypIndex = methodRef.getNameAndTypeIndex();
        } else if (currentRawBytecode instanceof RawByteCodes.Raw_invokestatic) {
            RawByteCodes.Raw_invokestatic rawInvokeStatic = (RawByteCodes.Raw_invokestatic)currentRawBytecode;
            int index = rawInvokeStatic.cpIndex;
            methodRef = (ConstantMethodref)this.clazz.getConstantPool().getConstant(index);
            classRef = (ConstantClass)this.clazz.getConstantPool().getConstant(methodRef.getClassIndex());
            methodNameAndTypIndex = methodRef.getNameAndTypeIndex();
        } else if (currentRawBytecode instanceof RawByteCodes.Raw_invokeinterface) {
            RawByteCodes.Raw_invokeinterface rawInvokeInterface = (RawByteCodes.Raw_invokeinterface)currentRawBytecode;
            int index = rawInvokeInterface.cpIndex;
            ConstantInterfaceMethodref imethodRef = (ConstantInterfaceMethodref)this.clazz.getConstantPool().getConstant(index);
            classRef = (ConstantClass)this.clazz.getConstantPool().getConstant(imethodRef.getClassIndex());
            methodNameAndTypIndex = imethodRef.getNameAndTypeIndex();
        }
        ConstantNameAndType nameAndType = (ConstantNameAndType)this.clazz.getConstantPool().getConstant(methodNameAndTypIndex);
        ConstantUtf8 className = (ConstantUtf8)this.clazz.getConstantPool().getConstant(classRef.getNameIndex());
        ConstantUtf8 methodName = (ConstantUtf8)this.clazz.getConstantPool().getConstant(nameAndType.getNameIndex());
        ConstantUtf8 methodSig = (ConstantUtf8)this.clazz.getConstantPool().getConstant(nameAndType.getSignatureIndex());
        String class_name = JavaArrayClass.isArrayClass(className.getBytes()) && methodName.getBytes().equals("clone") && methodSig.getBytes().equals("()Ljava/lang/Object;") ? "java.lang.Object" : className.getBytes();
        JavaClass clazz = Repository.lookupClass((String)class_name);
        Method method = currentRawBytecode instanceof RawByteCodes.Raw_invokeinterface ? ClassfileUtils.findDeclaringInterface(clazz, methodName.getBytes(), methodSig.getBytes()).getMethod() : ClassfileUtils.findMethodInClassHierarchy(clazz, methodName.getBytes(), methodSig.getBytes()).getMethod();
        this.popArgs(exitStack, method);
        if (!(currentRawBytecode instanceof RawByteCodes.Raw_invokestatic)) {
            AbstractStack.StackCell thisPointer = exitStack.popRef();
            RefType refType = (RefType)thisPointer.content;
            this.storeInfoInLocal(exitStack, refType, RefType.RefState.NONNULL);
        }
        this.pushReturnValue(exitStack, method);
    }

    protected void storeInfoInLocal(AbstractStack exitStack, RefType refType, RefType.RefState refstate) {
        if (refType.identicleWith != -1) {
            AbstractStack.StackCell lv = exitStack.getAt(refType.identicleWith);
            refType = (RefType)lv.content;
            refType.setState(refstate);
        }
    }

    private void pushReturnValue(AbstractStack exitStack, Method method) throws Exception {
        Type returnType = method.getReturnType();
        if (returnType.getSize() > 0) {
            this.pushPopType(exitStack, returnType, false);
        }
    }

    private void popArgs(AbstractStack exitStack, Method method) throws Exception {
        Type[] args = method.getArgumentTypes();
        int i = args.length;
        while (i > 0) {
            Type currentType = args[i - 1];
            this.pushPopType(exitStack, currentType, true);
            --i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void pushPopType(AbstractStack exitStack, Type currentType, boolean pop) throws Exception {
        if (currentType instanceof BasicType) {
            isRef = false;
        } else if (currentType instanceof ReferenceType) {
            isRef = true;
        } else {
            throw new Exception("Unknown field type");
        }
        size = currentType.getSize();
        if (size != 0) ** GOTO lbl23
        throw new Exception("Zero size field");
lbl-1000:
        // 1 sources

        {
            if (isRef) {
                if (pop) {
                    exitStack.popRef();
                } else {
                    exitStack.pushRef();
                }
            } else if (pop) {
                exitStack.popNonRef();
            } else {
                exitStack.pushNonRef();
            }
            --size;
lbl23:
            // 2 sources

            ** while (size > 0)
        }
lbl24:
        // 1 sources

    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Field handlePutGetField(AbstractStack exitStack, RawByteCodes.RawBytecode currentRawBytecode, byte code) throws Exception {
        RefType refType;
        AbstractStack.StackCell objPointer;
        RawByteCodes.RawCpIndexOperation putgetfield = (RawByteCodes.RawCpIndexOperation)currentRawBytecode;
        int index = putgetfield.cpIndex;
        ConstantFieldref fieldRef = (ConstantFieldref)this.clazz.getConstantPool().getConstant(index);
        ConstantClass classIndex = (ConstantClass)this.clazz.getConstantPool().getConstant(fieldRef.getClassIndex());
        ConstantUtf8 className = (ConstantUtf8)this.clazz.getConstantPool().getConstant(classIndex.getNameIndex());
        ConstantNameAndType nameAndType = (ConstantNameAndType)this.clazz.getConstantPool().getConstant(fieldRef.getNameAndTypeIndex());
        String fieldName = nameAndType.getName(this.clazz.getConstantPool());
        String signature = nameAndType.getSignature(this.clazz.getConstantPool());
        Field field = StackReferencesAnalyser.findField(className.getBytes(), fieldName, signature);
        boolean isRef = StackReferencesAnalyser.fieldIsRef(field);
        if (field == null) throw new Exception("Could not find field");
        if (field.getType() instanceof BasicType) {
            isRef = false;
        } else {
            if (!(field.getType() instanceof ReferenceType)) throw new Exception("Unknown field type");
            isRef = true;
        }
        int size = field.getType().getSize();
        if (size == 0) {
            throw new Exception("Zero size field");
        }
        if (code == -76) {
            objPointer = exitStack.popRef();
            refType = (RefType)objPointer.content;
            this.storeInfoInLocal(exitStack, refType, RefType.RefState.NONNULL);
        }
        while (size > 0) {
            if (isRef) {
                if (code == -75 || code == -77) {
                    exitStack.popRef();
                } else if (code == -76 || code == -78) {
                    exitStack.pushRef();
                }
            } else if (code == -75 || code == -77) {
                exitStack.popNonRef();
            } else if (code == -76 || code == -78) {
                exitStack.pushNonRef();
            }
            --size;
        }
        if (code != -75) return field;
        objPointer = exitStack.popRef();
        refType = (RefType)objPointer.content;
        this.storeInfoInLocal(exitStack, refType, RefType.RefState.NONNULL);
        return field;
    }

    public static boolean fieldIsRef(Field field) throws Exception {
        if (field != null) {
            if (field.getType() instanceof BasicType) {
                return false;
            }
            if (field.getType() instanceof ReferenceType) {
                return true;
            }
            throw new Exception("Unknown field type");
        }
        throw new Exception("Could not find field");
    }

    public static Field findField(String className, String fieldName, String fieldSignature) throws ClassNotFoundException {
        JavaClass superClass;
        JavaClass clazz = Repository.lookupClass((String)className);
        Field[] fields = clazz.getFields();
        if (fields != null) {
            int i = 0;
            while (i < fields.length) {
                Field current = fields[i];
                if (current.getName().equals(fieldName) && current.getSignature().equals(fieldSignature)) {
                    return current;
                }
                ++i;
            }
        }
        if ((superClass = clazz.getSuperClass()) != null) {
            return StackReferencesAnalyser.findField(superClass.getClassName(), fieldName, fieldSignature);
        }
        return null;
    }

    private void handleLDC(AbstractStack exitStack, RawByteCodes.RawBytecode currentRawBytecode, byte code) throws ClassNotFoundException {
        int cpIndex = currentRawBytecode instanceof RawByteCodes.Raw_ldc ? ((RawByteCodes.Raw_ldc)currentRawBytecode).cpIndex : (currentRawBytecode instanceof RawByteCodes.Raw_ldc2_w ? ((RawByteCodes.Raw_ldc2_w)currentRawBytecode).cpIndex : ((RawByteCodes.Raw_ldc_w)currentRawBytecode).cpIndex);
        LDCConstant constant = ClassfileUtils.getLDCConstant(this.clazz.getClassName(), cpIndex);
        switch (constant.getType()) {
            case 1: 
            case 6: {
                exitStack.pushRef();
                break;
            }
            case 2: 
            case 3: {
                exitStack.pushNonRef();
                break;
            }
            case 4: 
            case 5: {
                exitStack.pushNonRef();
                exitStack.pushNonRef();
            }
        }
    }

    public AbstractStack getStackLayout(int address) {
        return this.stackUsage.get(address);
    }

    private static class WorkItem {
        public int address;
        public byte[] byteCode;
        public AbstractStack entryStack;

        private WorkItem() {
        }
    }
}

