/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.stackanalyser;

import icecaptools.MethodEntryPoints;
import icecaptools.RawByteCodes;
import icecaptools.stackanalyser.AbstractStack;
import icecaptools.stackanalyser.ArrayRefType;
import icecaptools.stackanalyser.FlashArrayLocation;
import icecaptools.stackanalyser.StackReferencesAnalyser;
import icecaptools.stackanalyser.UnexpectedTypeException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;

public class StackArrayReferencesAnalyser
extends StackReferencesAnalyser {
    public ArrayList<FlashArrayLocation> flashArrays = new ArrayList();

    public StackArrayReferencesAnalyser(MethodEntryPoints javaMethod, JavaClass clazz) {
        super(javaMethod, clazz);
    }

    @Override
    protected void handleNewArray(AbstractStack exitStack, RawByteCodes.RawBytecode pusher) throws UnexpectedTypeException {
        exitStack.popNonRef();
        AbstractStack.StackCell cell = new AbstractStack.StackCell();
        cell.content = new ArrayRefType(pusher);
        exitStack.push(cell);
    }

    @Override
    protected void handleANewArray(AbstractStack exitStack, RawByteCodes.RawBytecode pusher) throws UnexpectedTypeException {
        exitStack.popNonRef();
        AbstractStack.StackCell cell = new AbstractStack.StackCell();
        cell.content = new ArrayRefType(pusher);
        exitStack.push(cell);
    }

    @Override
    protected Field handlePutGetField(AbstractStack exitStack, RawByteCodes.RawBytecode currentRawBytecode, byte code) throws Exception {
        AbstractStack.StackCell top = null;
        if (currentRawBytecode instanceof RawByteCodes.Raw_putfield) {
            top = exitStack.peek();
        }
        Field field = super.handlePutGetField(exitStack, currentRawBytecode, code);
        if (currentRawBytecode instanceof RawByteCodes.Raw_putfield && field.isVolatile() && top.content instanceof ArrayRefType) {
            Iterator<RawByteCodes.RawBytecode> pushers = ((ArrayRefType)top.content).getPushers();
            while (pushers.hasNext()) {
                this.flashArrays.add(new FlashArrayLocation(pushers.next(), this.method, this.clazz));
            }
        }
        return field;
    }

    public boolean isFlashArray(String className, String targetMethodName, String targetMethodSignature, int address) {
        for (FlashArrayLocation current : this.flashArrays) {
            String currentClassName = current.getClazz().getClassName();
            String currentMethodName = current.getJavaMethod().getName();
            String currentMethodSignature = current.getJavaMethod().getSignature();
            if (!className.equals(currentClassName) || !targetMethodName.equals(currentMethodName) || !targetMethodSignature.equals(currentMethodSignature) || current.getPusher().getAddress() != address) continue;
            return true;
        }
        return false;
    }
}

