/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.packer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.bcel.classfile.JavaClass;

public class Packer {
    private static final String MANIFEST_VERSION_VALUE = "1.0";

    public static String createJar(String outputFileName, JavaClass[] javaClasses, String mainClass) {
        if (javaClasses.length > 0) {
            try {
                Manifest manifest = new Manifest();
                Attributes attributes = manifest.getMainAttributes();
                attributes.put(Attributes.Name.MANIFEST_VERSION, MANIFEST_VERSION_VALUE);
                attributes.put(Attributes.Name.MAIN_CLASS, mainClass);
                File outputFile = new File(outputFileName);
                FileOutputStream fileOutputStream = new FileOutputStream(outputFile);
                JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)fileOutputStream, manifest);
                JarEntry jarEntry = null;
                int i = 0;
                while (i < javaClasses.length) {
                    jarEntry = new JarEntry(String.valueOf(javaClasses[i].getClassName().replace('.', '/')) + ".class");
                    jarOutputStream.putNextEntry(jarEntry);
                    javaClasses[i].dump((OutputStream)jarOutputStream);
                    ++i;
                }
                jarOutputStream.flush();
                jarOutputStream.close();
                return outputFile.getAbsolutePath();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("No classes to pack");
        }
        return null;
    }
}

