/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.launching.uart;

import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import icecaptools.launching.uart.InputParser;
import icecaptools.launching.uart.OutputParser;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.TooManyListenersException;

public class PortReader
implements SerialPortEventListener,
Runnable,
OutputParser {
    private SerialPort serialPort;
    private CommPortIdentifier portId;
    private InputStream inputStream;
    private BufferedOutputStream outputStream;
    private Thread readThread;
    private InputParser inputParser;
    private volatile boolean stopReader;
    private boolean outputTrace;
    private int workCount;
    private String progressMessage;

    public PortReader(String comport, InputParser inputParser) throws NoSuchPortException {
        this.portId = CommPortIdentifier.getPortIdentifier((String)comport);
        this.inputParser = inputParser;
        this.stopReader = false;
        this.outputTrace = false;
        this.workCount = 0;
    }

    public void startPort() throws PortInUseException, IOException, TooManyListenersException, UnsupportedCommOperationException {
        this.serialPort = (SerialPort)this.portId.open("PortReader", 2000);
        this.inputStream = this.serialPort.getInputStream();
        this.outputStream = new BufferedOutputStream(this.serialPort.getOutputStream(), 16384);
        this.serialPort.addEventListener((SerialPortEventListener)this);
        this.serialPort.notifyOnDataAvailable(true);
        this.setPortSpeed(9600);
        this.readThread = new Thread(this);
        this.readThread.start();
    }

    public void stopPort() {
        this.stopReader = true;
    }

    public void serialEvent(SerialPortEvent event) {
        switch (event.getEventType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 1: {
                byte[] readBuffer = new byte[20];
                try {
                    while (this.inputStream.available() > 0) {
                        int numBytes = this.inputStream.read(readBuffer);
                        int i = 0;
                        while (i < numBytes) {
                            if (this.inputParser.parseByte(readBuffer[i]) == null) {
                                this.stopPort();
                            }
                            ++i;
                        }
                    }
                    break;
                }
                catch (IOException iOException) {
                    break;
                }
                catch (UnsupportedCommOperationException unsupportedCommOperationException) {}
            }
        }
    }

    @Override
    public void run() {
        while (!this.stopReader) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.serialPort.close();
    }

    @Override
    public void parseByte(byte b) throws IOException {
        this.outputStream.write(b);
        if (this.outputTrace) {
            this.addProgressMessage("out: " + b);
        }
    }

    @Override
    public void setPortSpeed(int speed) throws UnsupportedCommOperationException {
        this.addProgressMessage("Baudrate " + speed);
        this.serialPort.setSerialPortParams(speed, 8, 1, 0);
    }

    @Override
    public synchronized void increaseWorkCount() {
        ++this.workCount;
    }

    public synchronized int getWorkCount() {
        return this.workCount;
    }

    @Override
    public void enableOutputTrace() {
        this.outputTrace = true;
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    public void join() throws InterruptedException {
        this.readThread.join();
    }

    public boolean running() {
        return !this.stopReader;
    }

    @Override
    public synchronized void addProgressMessage(String message) {
        this.progressMessage = message;
    }

    public synchronized String getProgressMessage() {
        return this.progressMessage;
    }

    public synchronized void setInputParser(InputParser inputParser) {
        this.inputParser = inputParser;
    }

    @Override
    public void parseBytes(byte[] data, int top) throws IOException {
        this.outputStream.write(data, 0, top);
    }

    public void parseBytes(byte[] data) throws IOException {
        this.parseBytes(data, data.length);
    }
}

