/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.launching.ev3;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Properties;

class RemoteProcess
extends Process {
    private InputStream errorStreamFromProcess;
    private InputStream outputStreamFromProcess;
    private OutputStream inputStreamToProcess;
    private Channel channel;
    private Session session;
    private SessionMonitor sessionMonitor;

    public RemoteProcess(String iPAddress, PrintStream consoleOutputStream, String executable) {
        JSch jsch = new JSch();
        try {
            this.session = jsch.getSession("root", iPAddress, 22);
            this.session.setPassword("");
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            this.session.setConfig(config);
            this.session.connect();
            String command = executable;
            this.channel = this.session.openChannel("exec");
            ((ChannelExec)this.channel).setCommand(command);
            this.errorStreamFromProcess = ((ChannelExec)this.channel).getErrStream();
            this.outputStreamFromProcess = this.channel.getInputStream();
            this.inputStreamToProcess = this.channel.getOutputStream();
            this.channel.connect();
            this.sessionMonitor = new SessionMonitor();
            this.sessionMonitor.start();
        }
        catch (JSchException e) {
            consoleOutputStream.print(e.getMessage());
        }
        catch (IOException e) {
            consoleOutputStream.print(e.getMessage());
        }
    }

    @Override
    public OutputStream getOutputStream() {
        return this.inputStreamToProcess;
    }

    @Override
    public InputStream getInputStream() {
        return this.outputStreamFromProcess;
    }

    @Override
    public InputStream getErrorStream() {
        return this.errorStreamFromProcess;
    }

    @Override
    public int waitFor() throws InterruptedException {
        this.sessionMonitor.join();
        return this.channel.getExitStatus();
    }

    @Override
    public int exitValue() {
        if (this.channel.isClosed()) {
            return this.channel.getExitStatus();
        }
        throw new IllegalThreadStateException();
    }

    @Override
    public void destroy() {
        this.sessionMonitor.destroySession();
    }

    private class SessionMonitor
    extends Thread {
        private boolean stop = false;

        SessionMonitor() {
        }

        @Override
        public void run() {
            while (!this.stop) {
                if (RemoteProcess.this.channel.isClosed()) {
                    this.stop = true;
                    continue;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            RemoteProcess.this.channel.disconnect();
            RemoteProcess.this.session.disconnect();
        }

        public void destroySession() {
            this.stop = true;
        }
    }
}

