/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.launching.ev3;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import icecaptools.PluginResourceManager;
import icecaptools.StreamResource;
import icecaptools.debugging.DebugChannel;
import icecaptools.debugging.TCPChannel;
import icecaptools.launching.AbstractHVMPOSIXLaunchConfigurationDelegate;
import icecaptools.launching.TCPChannelLauncher;
import icecaptools.launching.ev3.RemoteProcess;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.net.telnet.TelnetClient;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;

public class HVMEV3LaunchConfigurationDelegate
extends TCPChannelLauncher {
    private static final String compilerExecutable = "arm-none-linux-gnueabi-gcc";
    protected String deviceName = this.getDeviceName();
    private static final String rfile_name = "run_program.rbf";

    protected String getDeviceName() {
        return "EV3";
    }

    @Override
    protected Process startProcessOnTarget(ILaunch launch, ILaunchConfiguration configuration, StringBuffer path, String sourceFolder, PrintStream consoleOutputStream, IProgressMonitor monitor) throws CoreException {
        Object status;
        RemoteProcess rProcess;
        block12: {
            String IPAddress;
            block11: {
                block10: {
                    block9: {
                        block8: {
                            IPAddress = configuration.getAttribute("DEVICE_IPADDRESS", "0.0.0.0");
                            monitor.subTask("ping " + this.deviceName);
                            if (HVMEV3LaunchConfigurationDelegate.pingDevice(IPAddress)) break block8;
                            AbstractHVMPOSIXLaunchConfigurationDelegate.notify("Could not connect to " + this.deviceName + " at " + IPAddress);
                            return null;
                        }
                        monitor.subTask("start ssh on " + this.deviceName);
                        if (this.ensureSSH(IPAddress)) break block9;
                        AbstractHVMPOSIXLaunchConfigurationDelegate.notify("Could not establish ssh connection to " + this.deviceName + " at " + IPAddress);
                        return null;
                    }
                    monitor.subTask("upload program wrapper to " + this.deviceName);
                    if (this.ensureProgramWrapper(IPAddress, consoleOutputStream)) break block10;
                    AbstractHVMPOSIXLaunchConfigurationDelegate.notify("Could not copy program wrapper to " + this.deviceName + " at " + IPAddress);
                    return null;
                }
                monitor.subTask("upload program to " + this.deviceName);
                if (this.ensureProgram(IPAddress, consoleOutputStream, path)) break block11;
                AbstractHVMPOSIXLaunchConfigurationDelegate.notify("Could not copy program to " + this.deviceName + " at " + IPAddress);
                return null;
            }
            monitor.subTask("Start program on " + this.deviceName);
            rProcess = this.startProgram(IPAddress, consoleOutputStream);
            if (rProcess != null) break block12;
            AbstractHVMPOSIXLaunchConfigurationDelegate.notify("Could not start program on " + this.deviceName + " at " + IPAddress);
            return null;
        }
        try {
            return rProcess;
        }
        catch (IOException iOException) {
            status = new IStatus(){
                private final String message;
                {
                    this.message = "Could not ping " + HVMEV3LaunchConfigurationDelegate.this.deviceName + " - IOException";
                }

                public IStatus[] getChildren() {
                    return null;
                }

                public int getCode() {
                    return 4;
                }

                public Throwable getException() {
                    return new Exception(this.message);
                }

                public String getMessage() {
                    return this.message;
                }

                public String getPlugin() {
                    return DebugPlugin.getUniqueIdentifier();
                }

                public int getSeverity() {
                    return 4;
                }

                public boolean isMultiStatus() {
                    return false;
                }

                public boolean isOK() {
                    return false;
                }

                public boolean matches(int severityMask) {
                    return false;
                }
            };
            throw new CoreException(status);
        }
        catch (InterruptedException interruptedException) {
            status = new IStatus(){
                private final String message;
                {
                    this.message = "Could not ping " + HVMEV3LaunchConfigurationDelegate.this.deviceName + " - Interrupted";
                }

                public IStatus[] getChildren() {
                    return null;
                }

                public int getCode() {
                    return 4;
                }

                public Throwable getException() {
                    return new Exception(this.message);
                }

                public String getMessage() {
                    return this.message;
                }

                public String getPlugin() {
                    return DebugPlugin.getUniqueIdentifier();
                }

                public int getSeverity() {
                    return 4;
                }

                public boolean isMultiStatus() {
                    return false;
                }

                public boolean isOK() {
                    return false;
                }

                public boolean matches(int severityMask) {
                    return false;
                }
            };
            throw new CoreException(status);
        }
    }

    private RemoteProcess startProgram(String iPAddress, PrintStream consoleOutputStream) {
        RemoteProcess rPocess = new RemoteProcess(iPAddress, consoleOutputStream, String.valueOf(this.getRemoteProgramLocation()) + "program");
        return rPocess;
    }

    private boolean ensureProgram(String iPAddress, PrintStream consoleOutputStream, StringBuffer path) throws FileNotFoundException {
        File executable = new File(path.toString());
        FileInputStream dataStream = new FileInputStream(executable);
        return this.copyDataTo(iPAddress, dataStream, consoleOutputStream, "program");
    }

    protected boolean ensureProgramWrapper(String iPAddress, PrintStream consoleOutputStream) {
        PluginResourceManager rManager = new PluginResourceManager();
        StreamResource sresource = rManager.getResource(consoleOutputStream, rfile_name);
        InputStream dataStream = sresource.getStream();
        return this.copyDataTo(iPAddress, dataStream, consoleOutputStream, rfile_name);
    }

    private boolean copyDataTo(String iPAddress, InputStream dataStream, PrintStream consoleOutputStream, String rfile_name) {
        OutputStream out;
        Channel channel;
        Session session;
        block9: {
            long filesize;
            ArrayList<Byte> bytes;
            InputStream in;
            block8: {
                String command;
                block7: {
                    JSch jsch = new JSch();
                    session = jsch.getSession("root", iPAddress, 22);
                    session.setPassword("");
                    Properties config = new Properties();
                    config.put("StrictHostKeyChecking", "no");
                    session.setConfig(config);
                    session.connect(5000);
                    String rpath = String.valueOf(this.getRemoteProgramLocation()) + rfile_name;
                    command = "scp -t " + rpath;
                    channel = session.openChannel("exec");
                    ((ChannelExec)channel).setCommand(command);
                    out = channel.getOutputStream();
                    in = channel.getInputStream();
                    channel.connect();
                    if (HVMEV3LaunchConfigurationDelegate.checkAck(in) == 0) break block7;
                    channel.disconnect();
                    session.disconnect();
                    return false;
                }
                bytes = this.readResource(dataStream);
                filesize = bytes.size();
                command = "C0744 " + filesize + " " + rfile_name + "\n";
                out.write(command.getBytes());
                out.flush();
                if (HVMEV3LaunchConfigurationDelegate.checkAck(in) == 0) break block8;
                channel.disconnect();
                session.disconnect();
                return false;
            }
            byte[] raw = new byte[(int)filesize];
            int i = 0;
            while ((long)i < filesize) {
                raw[i] = bytes.get(i);
                ++i;
            }
            out.write(raw);
            out.write(0);
            out.flush();
            if (HVMEV3LaunchConfigurationDelegate.checkAck(in) == 0) break block9;
            channel.disconnect();
            session.disconnect();
            return false;
        }
        try {
            out.close();
            channel.disconnect();
            session.disconnect();
            return true;
        }
        catch (JSchException jSchException) {
        }
        catch (IOException iOException) {}
        return false;
    }

    protected String getRemoteProgramLocation() {
        return "/mnt/ramdisk/prjs/BrkProg_SAVE/";
    }

    private ArrayList<Byte> readResource(InputStream dataStream) throws IOException {
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        int next = dataStream.read();
        while (next != -1) {
            bytes.add((byte)next);
            next = dataStream.read();
        }
        return bytes;
    }

    static int checkAck(InputStream in) throws IOException {
        int b = in.read();
        if (b == 0) {
            return b;
        }
        if (b == -1) {
            return b;
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuffer sb = new StringBuffer();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
        }
        return b;
    }

    private boolean ensureSSH(String iPAddress) {
        return this.ensureSSH(iPAddress, true);
    }

    private boolean ensureSSH(String iPAddress, boolean retry) {
        JSch jsch = new JSch();
        try {
            Session session = jsch.getSession("root", iPAddress, 22);
            session.setPassword("");
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            session.setConfig(config);
            session.connect(5000);
            session.disconnect();
            return true;
        }
        catch (JSchException jSchException) {
            if (retry) {
                this.startSSHOnTarget(iPAddress);
                return this.ensureSSH(iPAddress, false);
            }
            return false;
        }
    }

    protected void startSSHOnTarget(String iPAddress) {
        TelnetClient telnet = new TelnetClient();
        try {
            telnet.connect(iPAddress, 23);
            TelnetReader telnetReader = new TelnetReader(telnet, "login: ");
            telnetReader.start();
            telnetReader.awaitExpected();
            telnetReader.stopReading();
            telnetReader.join();
            if (telnetReader.didReadExpected()) {
                OutputStream outstream = telnet.getOutputStream();
                outstream.write(new byte[]{114, 111, 111, 116, 10});
                outstream.flush();
                telnetReader = new TelnetReader(telnet, "root@EV3:~# ");
                telnetReader.start();
                telnetReader.awaitExpected();
                telnetReader.stopReading();
                telnetReader.join();
                if (telnetReader.didReadExpected()) {
                    outstream.write(new byte[]{100, 114, 111, 112, 98, 101, 97, 114, 10});
                    outstream.flush();
                    telnetReader = new TelnetReader(telnet, "root@EV3:~# ");
                    telnetReader.start();
                    telnetReader.awaitExpected();
                    telnetReader.stopReading();
                    telnetReader.join();
                }
                telnet.disconnect();
            }
        }
        catch (SocketException socketException) {
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {}
    }

    private static boolean pingDevice(String host) throws InterruptedException, IOException {
        boolean isWindows = System.getProperty("os.name").toLowerCase().contains("win");
        ProcessBuilder processBuilder = new ProcessBuilder("ping", isWindows ? "-n" : "-c", "1", host);
        Process proc = processBuilder.start();
        int returnVal = proc.waitFor();
        return returnVal == 0;
    }

    @Override
    protected StringBuffer getCompilerCommand(ILaunchConfiguration configuration) throws CoreException {
        StringBuffer compilerCommand = new StringBuffer();
        compilerCommand.append("arm-none-linux-gnueabi-gcc -Wall -pedantic " + this.getOptimizationLevel(configuration) + " -DPC32 -DPRINTFSUPPORT ");
        return compilerCommand;
    }

    @Override
    protected String getCompilerExecutable() {
        return compilerExecutable;
    }

    @Override
    protected void addAdditionalFiles(StringBuffer command, ILaunchConfiguration configuration) {
        command.append("natives_i86.c natives_ev3.c native_scj.c arm_interrupt.s -lrt ");
    }

    @Override
    protected String getStripper() {
        return "arm-none-linux-gnueabi-strip";
    }

    @Override
    protected String getTargetIPAddress(ILaunchConfiguration configuration) throws CoreException {
        String IPAddress = configuration.getAttribute("DEVICE_IPADDRESS", "0.0.0.0");
        return IPAddress;
    }

    @Override
    protected String getHeapSize(int size) {
        return String.valueOf(size * 1024);
    }

    @Override
    protected DebugChannel getChannel(Process p, int requestResponseChannel, int eventChannel, String targetIPAddress) {
        return new TCPChannel(requestResponseChannel, eventChannel, targetIPAddress);
    }

    private static class TelnetReader
    extends Thread {
        private String expectedOutput;
        private InputStream instream;
        private boolean stop;
        private int top;

        public TelnetReader(TelnetClient telnet, String expectedOutput) {
            this.instream = telnet.getInputStream();
            this.stop = false;
            this.top = 0;
            this.expectedOutput = expectedOutput;
        }

        public void awaitExpected() {
            int i = 0;
            while (i < 10) {
                if (this.didReadExpected()) break;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
                ++i;
            }
        }

        public void stopReading() {
            this.stop = true;
        }

        boolean didReadExpected() {
            return this.top == this.expectedOutput.length();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (true) {
                    if (this.stop) {
                        return;
                    }
                    if (this.instream.available() > 0) {
                        byte[] buf = new byte[128];
                        int count = this.instream.read(buf);
                        if (count == -1) {
                            return;
                        }
                        if (count > 0) {
                            int i = 0;
                            while (i < count) {
                                if (this.handleByte(buf[i])) {
                                    return;
                                }
                                ++i;
                            }
                        }
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (IOException iOException) {}
        }

        private boolean handleByte(byte b) {
            char n = (char)b;
            this.top = n == this.expectedOutput.charAt(this.top) ? ++this.top : 0;
            return this.top == this.expectedOutput.length();
        }
    }
}

