/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.launching.arduino;

import icecaptools.IcecapEclipseProgressMonitor;
import icecaptools.launching.AbstractHVMPOSIXLaunchConfigurationDelegate;
import icecaptools.launching.ShellCommand;
import icecaptools.launching.arduino.ArduinoProcess;
import icecaptools.launching.arduino.PasswordDialog;
import java.io.File;
import java.io.PrintStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ArduinoProcessLinuxHost
extends ArduinoProcess {
    private static String rootPasswd = null;
    public static final String downloadPort = "/dev/ttyACM0";

    public ArduinoProcessLinuxHost(String sourceFolder) {
        super(sourceFolder);
        this.processOutputPort = "/dev/ttyS80";
    }

    @Override
    protected ArduinoProcess startProcessOnTarget(ILaunch launch, ILaunchConfiguration configuration, StringBuffer path, PrintStream consoleOutputStream, IProgressMonitor monitor, Shell shell) throws CoreException {
        String[] commands = new String[]{"su", "-c", "avrdude -F -V -c arduino -p ATMEGA328P -P /dev/ttyACM0 -b 115200 -U flash:w:main.hex"};
        this.ensureRootPasswd(shell);
        if (rootPasswd == null) {
            monitor.setCanceled(true);
        } else {
            ArduinoProcess.OutputStreamParser commandOutputParser = new ArduinoProcess.OutputStreamParser(consoleOutputStream);
            ArduinoProcess.InputStreamGenerator commandInputGenerator = new ArduinoProcess.InputStreamGenerator(commandOutputParser, String.valueOf(rootPasswd) + "\n");
            int result = ShellCommand.executeCommand(commands, commandOutputParser, commandInputGenerator, true, this.sourceFolder.toString(), null, 20, new IcecapEclipseProgressMonitor(monitor));
            if (result != 0) {
                StringBuffer message = new StringBuffer();
                message.append("Could not download to Arduino\n");
                File f = new File(downloadPort);
                if (!f.exists()) {
                    message.append("Is Arduino plugged into USB?");
                } else {
                    message.append("Is root password correct?");
                    rootPasswd = null;
                }
                AbstractHVMPOSIXLaunchConfigurationDelegate.notify(message.toString());
                return null;
            }
            result = this.ensurePortAccessible(downloadPort, rootPasswd, this.sourceFolder, monitor, consoleOutputStream);
            if (result == 0) {
                result = this.connectProcessOutput(consoleOutputStream);
                if (result == 0) {
                    return this;
                }
                AbstractHVMPOSIXLaunchConfigurationDelegate.notify("Could not connect to process output");
                return null;
            }
        }
        return null;
    }

    private void ensureRootPasswd(final Shell shell) {
        if (rootPasswd == null) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    PasswordDialog id = new PasswordDialog(shell, "Enter root password", "Root password required to download to Arduino", "", new PasswordValidator());
                    id.open();
                    rootPasswd = id.getValue();
                }
            });
        }
    }

    private int ensurePortAccessible(String portName, String rootPasswd, String sourceFolder, IProgressMonitor monitor, PrintStream consoleOutputStream) {
        ArduinoProcess.InputStreamGenerator commandInputGenerator;
        ArduinoProcess.OutputStreamParser commandOutputParser;
        String[] commands;
        File f = new File(this.processOutputPort);
        if (!f.exists()) {
            commands = new String[]{"su", "-c", "ln -s " + portName + " " + this.processOutputPort};
            commandOutputParser = new ArduinoProcess.OutputStreamParser(consoleOutputStream);
            commandInputGenerator = new ArduinoProcess.InputStreamGenerator(commandOutputParser, String.valueOf(rootPasswd) + "\n");
            int result = ShellCommand.executeCommand(commands, commandOutputParser, commandInputGenerator, true, sourceFolder, null, 20, new IcecapEclipseProgressMonitor(monitor));
            if (result != 0) {
                return result;
            }
        }
        commands = new String[]{"su", "-c", "chmod 777 " + portName};
        commandOutputParser = new ArduinoProcess.OutputStreamParser(consoleOutputStream);
        commandInputGenerator = new ArduinoProcess.InputStreamGenerator(commandOutputParser, String.valueOf(rootPasswd) + "\n");
        return ShellCommand.executeCommand(commands, commandOutputParser, commandInputGenerator, true, sourceFolder, null, 20, new IcecapEclipseProgressMonitor(monitor));
    }

    private static class PasswordValidator
    implements IInputValidator {
        private PasswordValidator() {
        }

        public String isValid(String newText) {
            if (newText != null && newText.trim().length() > 0) {
                return null;
            }
            return "Please enter password";
        }
    }
}

