/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.launching.arduino;

import icecaptools.compiler.utils.OsCheck;
import icecaptools.launching.TargetSpecificLauncherTab;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ArduinoLauncherTab
extends TargetSpecificLauncherTab {
    public static final String COMPORT = "COMPORT";
    private Text comPortText;

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        Group comGroup = new Group(this.root, 4);
        FormLayout layout = new FormLayout();
        comGroup.setLayout((Layout)layout);
        comGroup.setText("COM port");
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 5);
        formData.top = new FormAttachment((Control)this.optimizationLevelGroup, 5);
        formData.right = new FormAttachment(100, -5);
        comGroup.setLayoutData((Object)formData);
        Label comLabel = new Label((Composite)comGroup, 16384);
        comLabel.setText(" COM port:");
        formData = new FormData();
        formData.left = new FormAttachment(0, 5);
        formData.top = new FormAttachment(0, 9);
        comLabel.setLayoutData((Object)formData);
        this.comPortText = new Text((Composite)comGroup, 2052);
        formData = new FormData();
        formData.left = new FormAttachment((Control)comLabel, 5);
        formData.top = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        this.comPortText.setLayoutData((Object)formData);
        this.comPortText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ArduinoLauncherTab.this.lcd.updateButtons();
            }
        });
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        configuration.setAttribute(COMPORT, ArduinoLauncherTab.getDefaultComPort());
    }

    public static String getDefaultComPort() {
        OsCheck.OSType ostype = OsCheck.getOperatingSystemType();
        switch (ostype) {
            case Linux: {
                return "/dev/ttyACM0";
            }
            case Windows: {
                return "COM11";
            }
            case MacOS: 
            case Other: {
                return "";
            }
        }
        return "";
    }

    @Override
    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        try {
            String targetComPort = configuration.getAttribute(COMPORT, ArduinoLauncherTab.getDefaultComPort());
            if (targetComPort != null) {
                this.comPortText.setText(targetComPort);
            }
        }
        catch (CoreException coreException) {}
    }

    @Override
    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean comPortValid = false;
        if (this.comPortText.getText() != null && this.comPortText.getText().trim().length() > 0) {
            comPortValid = true;
        }
        return super.isValid(launchConfig) && comPortValid;
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        String targetComPort = this.comPortText.getText();
        if (targetComPort != null) {
            configuration.setAttribute(COMPORT, targetComPort);
        } else {
            configuration.setAttribute(COMPORT, ArduinoLauncherTab.getDefaultComPort());
        }
    }

    @Override
    protected String getHeapSizeUnit() {
        return "bytes";
    }

    @Override
    protected int getHeapSizeMaximum() {
        return 1536;
    }

    @Override
    protected int getDefaultHeapSize() {
        return 1024;
    }
}

