/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.launching;

import icecaptools.IcecapProgressMonitor;
import icecaptools.launching.StreamGobler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class ShellCommand {
    public static final int PROCESS_START_FAILED = -2;
    public static final int PROCESS_HANGED = -1;
    public static final int ILLEGAL_WORKINGDIRECTORY = -3;

    public static int executeCommand(String command, OutputStream consoleOutputStream, boolean doExecute, String workingDirectoryPath, String[] envp, int timeout, IcecapProgressMonitor monitor) {
        return ShellCommand.executeIt(null, command, consoleOutputStream, null, doExecute, workingDirectoryPath, envp, timeout, monitor);
    }

    public static int executeCommand(String[] commands, OutputStream consoleOutputStream, InputStream consoleInputStream, boolean doExecute, String workingDirectoryPath, String[] envp, int timeout, IcecapProgressMonitor monitor) {
        return ShellCommand.executeIt(commands, null, consoleOutputStream, consoleInputStream, doExecute, workingDirectoryPath, envp, timeout, monitor);
    }

    private static int executeIt(String[] commands, String command, OutputStream consoleOutputStream, InputStream consoleInputStream, boolean doExecute, String workingDirectoryPath, String[] envp, int timeout, IcecapProgressMonitor monitor) {
        Runtime runTime = Runtime.getRuntime();
        PrintWriter writer = new PrintWriter(consoleOutputStream);
        if (command != null) {
            writer.println("Working directory [" + workingDirectoryPath + "]");
            writer.println(command);
        }
        writer.flush();
        if (envp != null) {
            envp = ShellCommand.addToProcessEnvironment(envp);
        }
        if (timeout == 0) {
            timeout = 20;
        }
        if (doExecute) {
            block11: {
                ProcessTerminator waiter;
                block12: {
                    StreamGobler outputStreamGobler;
                    File workingDirectory = new File(workingDirectoryPath);
                    if (!workingDirectory.exists()) break block11;
                    monitor.subTask("Compiling");
                    Process compilerProcess = command != null ? runTime.exec(command, envp, workingDirectory) : runTime.exec(commands, envp, workingDirectory);
                    waiter = new ProcessTerminator(compilerProcess, timeout, monitor);
                    waiter.startWaiting();
                    StreamGobler inputStreamGobler = new StreamGobler(compilerProcess.getInputStream(), consoleOutputStream);
                    StreamGobler errorStreamGobler = new StreamGobler(compilerProcess.getErrorStream(), consoleOutputStream);
                    if (consoleInputStream != null) {
                        outputStreamGobler = new StreamGobler(consoleInputStream, compilerProcess.getOutputStream());
                        outputStreamGobler.start();
                    } else {
                        outputStreamGobler = null;
                    }
                    inputStreamGobler.start();
                    errorStreamGobler.start();
                    compilerProcess.waitFor();
                    waiter.stopWaiting();
                    inputStreamGobler.join();
                    errorStreamGobler.join();
                    if (outputStreamGobler != null) {
                        outputStreamGobler.join();
                    }
                    consoleOutputStream.flush();
                    if (!waiter.killedProcess()) break block12;
                    return -1;
                }
                try {
                    return waiter.exitValue;
                }
                catch (IOException e) {
                    writer.println("Could not execute command: [" + e.getMessage() + "]");
                    ShellCommand.reportEnvironment(envp, System.getenv(), writer);
                    writer.flush();
                    return -2;
                }
                catch (InterruptedException interruptedException) {
                    return -2;
                }
            }
            return -3;
        }
        return 0;
    }

    private static void reportEnvironment(String[] envp, Map<String, String> map, PrintWriter writer) {
        writer.println("Environment: ");
        if (envp != null) {
            String[] stringArray = envp;
            int n = envp.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                writer.println(str);
                ++n2;
            }
        } else {
            writer.println("envp is null, using default environment");
            if (map != null) {
                for (String nextKey : map.keySet()) {
                    writer.println(String.valueOf(nextKey) + " = " + map.get(nextKey));
                }
            } else {
                writer.println("default environment is null");
            }
        }
    }

    public static String[] addToProcessEnvironment(String[] envp) {
        try {
            HashMap<String, String> parentEnvironment = new HashMap<String, String>();
            Map<String, String> systemEnv = System.getenv();
            for (String nextKey : systemEnv.keySet()) {
                String nextValue = systemEnv.get(nextKey);
                parentEnvironment.put(nextKey.toUpperCase(), nextValue);
            }
            int i = 0;
            while (i < envp.length) {
                String current = envp[i];
                StringTokenizer tokenizer = new StringTokenizer(current, "=");
                if (tokenizer.hasMoreElements()) {
                    String name = tokenizer.nextToken().toUpperCase();
                    if (tokenizer.hasMoreElements()) {
                        String value = tokenizer.nextToken();
                        if (parentEnvironment.containsKey(name)) {
                            String parentValue = (String)parentEnvironment.get(name);
                            parentValue = String.valueOf(value) + File.pathSeparatorChar + parentValue;
                            parentEnvironment.put(name, parentValue);
                        }
                    }
                }
                ++i;
            }
            Set keys = parentEnvironment.keySet();
            String[] childEnvp = new String[keys.size()];
            int i2 = 0;
            for (String nextKey : parentEnvironment.keySet()) {
                StringBuffer nextEntry = new StringBuffer();
                nextEntry.append(nextKey);
                nextEntry.append("=");
                nextEntry.append((String)parentEnvironment.get(nextKey));
                childEnvp[i2] = nextEntry.toString();
                ++i2;
            }
            return childEnvp;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static class ProcessTerminator
    extends Thread {
        private Process process;
        private int numberOfSecondsToWait;
        private boolean continueToRun;
        private boolean killedProcess;
        private IcecapProgressMonitor monitor;
        public int exitValue;

        public ProcessTerminator(Process process, int numberOfSecondsToWait, IcecapProgressMonitor monitor) {
            this.process = process;
            this.numberOfSecondsToWait = numberOfSecondsToWait;
            this.continueToRun = true;
            this.killedProcess = false;
            this.monitor = monitor;
        }

        public boolean killedProcess() {
            return this.killedProcess;
        }

        public void stopWaiting() {
            this.exitValue = this.process.exitValue();
            this.continueToRun = false;
        }

        public void startWaiting() {
            this.start();
        }

        @Override
        public void run() {
            while (this.numberOfSecondsToWait > 0 && this.continueToRun) {
                try {
                    Thread.sleep(1000L);
                    --this.numberOfSecondsToWait;
                    if (this.monitor.isCanceled()) {
                        this.numberOfSecondsToWait = 0;
                        continue;
                    }
                    this.monitor.worked(1);
                }
                catch (InterruptedException interruptedException) {}
            }
            try {
                this.exitValue = this.process.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                this.killedProcess = true;
                this.process.destroy();
            }
        }
    }
}

