/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.conversion;

import icecaptools.HVMProperties;
import icecaptools.IcecapIterator;
import icecaptools.IcecapTool;
import icecaptools.PropertyManager;
import icecaptools.ResourceManager;
import icecaptools.compiler.CodeDetector;
import icecaptools.compiler.IcecapCodeFormatter;
import icecaptools.compiler.IcecapSourceCodeLinker;
import icecaptools.compiler.NativeMethodDetector;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.IJavaProject;

public class ConversionConfiguration
implements IcecapTool {
    private String inputFolder;
    private String inputPackage;
    protected String inputClass;
    private String entryPointClassName;
    private String entryPointMethodName = null;
    private String entryPointMethodSignature = null;
    private boolean entryPointModyfierIsStatic = true;
    private IcecapCodeFormatter codeFormatter;
    private ResourceManager rManager = null;
    private String inputSourceFileName;
    private PropertyManager propertyManager = null;
    private IcecapSourceCodeLinker sourceCodeLinker;
    private IJavaProject projectResource;
    private boolean doReportConversion = false;
    private CodeDetector codeDetector;
    private NativeMethodDetector nativeMethodDetector;
    public static final String DEFAULT_PACKAGE_NAME = "default";

    @Override
    public IcecapCodeFormatter getCodeFormatter() {
        return this.codeFormatter;
    }

    @Override
    public IcecapSourceCodeLinker getSourceCodeLinker() {
        return this.sourceCodeLinker;
    }

    public void setCodeFormatter(IcecapCodeFormatter codeFormatter) {
        this.codeFormatter = codeFormatter;
    }

    public String getInputFolder() {
        return this.inputFolder;
    }

    public void setClassPath(String inputFolder) {
        this.inputFolder = inputFolder;
    }

    public void appendToClassPath(String element) {
        this.inputFolder = String.valueOf(this.inputFolder) + File.pathSeparator + element;
    }

    public String getInputPackage() {
        return this.inputPackage;
    }

    public void setInputPackage(String inputPackage) {
        this.inputPackage = inputPackage;
    }

    public String getInputClass() {
        return this.inputClass;
    }

    public void setInputClass(String className) {
        StringTokenizer tokenizer = new StringTokenizer(className, ".");
        String previous = className;
        String current = className;
        while (tokenizer.hasMoreElements()) {
            previous = current;
            current = tokenizer.nextToken();
        }
        this.inputClass = previous;
    }

    public String getEntryPointMethodName() {
        return this.entryPointMethodName;
    }

    public void setEntryPointMethodName(String entryPointMethodName) {
        this.entryPointMethodName = entryPointMethodName;
    }

    public String getEntryPointMethodSignature() {
        return this.entryPointMethodSignature;
    }

    public void setEntryPointMethodSignature(String entryPointMethodSignature) {
        this.entryPointMethodSignature = entryPointMethodSignature;
    }

    public boolean isEntryPointModyfierIsStatic() {
        return this.entryPointModyfierIsStatic;
    }

    public void setEntryPointModyfierIsStatic(boolean entryPointModyfierIsStatic) {
        this.entryPointModyfierIsStatic = entryPointModyfierIsStatic;
    }

    public void setInputSourceFileName(String inputSourceFileName) throws Exception {
        this.inputSourceFileName = inputSourceFileName;
        this.getProperties();
    }

    public String getInputSourceFileName() {
        return this.inputSourceFileName;
    }

    @Override
    public HVMProperties getProperties() throws Exception {
        if (this.propertyManager == null) {
            this.propertyManager = new PropertyManager();
            this.propertyManager.reloadLoadedProperties(this.inputSourceFileName);
        }
        return this.propertyManager;
    }

    public void setSourceCodeLinker(IcecapSourceCodeLinker sourceCodeLinker) {
        this.sourceCodeLinker = sourceCodeLinker;
    }

    public void setEntryPointClassName(String className) {
        this.entryPointClassName = className;
    }

    public String getEntryPointClassName() {
        return this.entryPointClassName;
    }

    public void setProjectResource(IJavaProject projectRessource) {
        this.projectResource = projectRessource;
    }

    public IJavaProject getProjectResource() {
        return this.projectResource;
    }

    public ResourceManager getResourceManager() {
        return this.rManager;
    }

    public void setResourceManager(ResourceManager rManager) {
        this.rManager = rManager;
    }

    public boolean reportConversion() {
        return this.doReportConversion;
    }

    public void setReportConversion(boolean b) {
        this.doReportConversion = b;
    }

    public IcecapIterator<String> getForcedIncludes() {
        if (this.inputSourceFileName != null) {
            StringTokenizer tokenizer = new StringTokenizer(this.inputSourceFileName, String.valueOf(File.separatorChar));
            StringBuffer includedClasses = new StringBuffer();
            includedClasses.append(File.separatorChar);
            while (tokenizer.hasMoreTokens()) {
                String nextSegment = tokenizer.nextToken();
                if (!tokenizer.hasMoreTokens()) continue;
                includedClasses.append(nextSegment);
                includedClasses.append(File.separatorChar);
            }
            includedClasses.append("forcedincludes.txt");
            File file = new File(includedClasses.toString());
            if (file.exists() && file.canRead()) {
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(file));
                    return new ClassNameIterator(reader);
                }
                catch (FileNotFoundException fileNotFoundException) {}
            }
        }
        return new EmptyIteraor();
    }

    @Override
    public CodeDetector getCodeDetector() {
        return this.codeDetector;
    }

    public void setCodeDetector(CodeDetector architectureDependentCodeDetector) {
        this.codeDetector = architectureDependentCodeDetector;
    }

    @Override
    public NativeMethodDetector getNativeMethodDetector() {
        return this.nativeMethodDetector;
    }

    public void setNativeMethodDetector(NativeMethodDetector nativeMethodDetector) {
        this.nativeMethodDetector = nativeMethodDetector;
    }

    public String getPropertiesFileName() {
        return this.propertyManager.getPropertiesFileName();
    }

    private static class ClassNameIterator
    implements IcecapIterator<String> {
        private BufferedReader reader;
        private String nextLine;

        public ClassNameIterator(BufferedReader reader) {
            this.reader = reader;
            try {
                this.nextLine = reader.readLine();
            }
            catch (IOException iOException) {
                this.nextLine = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextLine != null;
        }

        @Override
        public String next() {
            String result = this.nextLine;
            try {
                this.nextLine = this.reader.readLine();
            }
            catch (IOException iOException) {
                this.nextLine = null;
            }
            return result;
        }
    }

    private static class EmptyIteraor
    implements IcecapIterator<String> {
        private EmptyIteraor() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public String next() {
            return null;
        }
    }
}

