/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.compiler.utils;

import java.util.HashMap;

public class StaticInitializationAnnotationInfo {
    public HashMap<String, ClassInfo> classInfo = new HashMap();

    public void classIsDefinatelyInitialized(String className) {
        if (this.classInfo.containsKey(className)) {
            ClassInfo info = this.classInfo.get(className);
            info.initialized = true;
        } else {
            ClassInfo info = new ClassInfo(className);
            info.initialized = true;
            this.classInfo.put(className, info);
        }
    }

    public boolean isClassInitialized(String className) {
        if (this.classInfo.containsKey(className)) {
            ClassInfo info = this.classInfo.get(className);
            return info.initialized;
        }
        return false;
    }

    public boolean merge(StaticInitializationAnnotationInfo other) {
        boolean mergeRequired = false;
        for (ClassInfo thisInfo : this.classInfo.values()) {
            ClassInfo otherInfo = other.getClassInfo(thisInfo.className);
            if (otherInfo != null) {
                if (thisInfo.initialized == otherInfo.initialized) continue;
                mergeRequired = true;
                thisInfo.initialized = false;
                continue;
            }
            if (thisInfo.initialized) {
                mergeRequired = true;
            }
            thisInfo.initialized = false;
        }
        for (ClassInfo otherInfo : other.classInfo.values()) {
            if (this.classInfo.containsKey(otherInfo.className)) continue;
            this.classInfo.put(otherInfo.className, new ClassInfo(otherInfo.className));
            mergeRequired = true;
        }
        return mergeRequired;
    }

    private ClassInfo getClassInfo(String className) {
        return this.classInfo.get(className);
    }

    public StaticInitializationAnnotationInfo copy() {
        StaticInitializationAnnotationInfo other = new StaticInitializationAnnotationInfo();
        for (ClassInfo thisInfo : this.classInfo.values()) {
            ClassInfo otherInfo = new ClassInfo(thisInfo.className);
            otherInfo.initialized = thisInfo.initialized;
            other.classInfo.put(otherInfo.className, otherInfo);
        }
        return other;
    }

    private static class ClassInfo {
        boolean initialized;
        String className;

        ClassInfo(String className) {
            this.className = className;
            this.initialized = false;
        }
    }
}

