/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.compiler.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class CompilerUtils {
    public static void reportConversion(int methodCount) {
        UsageReporter ruJob = new UsageReporter("Report HVM Usage", methodCount);
        ruJob.setSystem(true);
        ruJob.schedule();
    }

    private static class UsageReporter
    extends Job {
        private int methodCount;

        public UsageReporter(String name, int methodCount) {
            super(name);
            this.methodCount = methodCount;
        }

        protected IStatus run(IProgressMonitor monitor) {
            String urlToRead = "http://www.icelab.dk/hvmforum/HVMForum?cmd=reportUsage&mcount=" + this.methodCount;
            try {
                String line;
                URL url = new URL(urlToRead);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setReadTimeout(5000);
                BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuffer response = new StringBuffer();
                while ((line = rd.readLine()) != null) {
                    response.append(String.valueOf(line) + "\n");
                }
                rd.close();
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {
            }
            catch (Throwable throwable) {}
            return Status.OK_STATUS;
        }
    }
}

