/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.compiler.aot;

import icecaptools.AnnotationsAttribute;
import icecaptools.IcecapVolatile;
import icecaptools.compiler.NoDuplicatesMemorySegment;
import icecaptools.compiler.aot.AOTCompiler;
import icecaptools.compiler.aot.LocalVariableManager;
import icecaptools.compiler.aot.PreloadingVariableManager;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;

public class TypeAwareVariableManager
extends PreloadingVariableManager {
    private Set<String> volatiles = new HashSet<String>();
    private String[] lvNames;

    public TypeAwareVariableManager(int maxLocals, StringBuffer output, NoDuplicatesMemorySegment localVariables) {
        super(maxLocals, output, localVariables);
    }

    @Override
    public void init(StringBuffer output, NoDuplicatesMemorySegment localVariables, int level, Method javaMethod) {
        LocalVariableTable localVariableTable = javaMethod.getLocalVariableTable();
        this.handleVolatileLocals(javaMethod);
        if (localVariableTable != null) {
            LocalVariable[] vars;
            LocalVariable[] localVariableArray = vars = localVariableTable.getLocalVariableTable();
            int n = vars.length;
            int n2 = 0;
            while (n2 < n) {
                LocalVariable localVariable = localVariableArray[n2];
                this.insert(localVariable, localVariables);
                String sig = Utility.signatureToString((String)localVariable.getSignature());
                if ("double".equals(sig) || "long".equals(sig)) {
                    LocalVariable twoIndex = new LocalVariable(localVariable.getStartPC(), localVariable.getLength(), localVariable.getNameIndex(), localVariable.getSignatureIndex(), localVariable.getIndex() + 1, localVariable.getConstantPool());
                    this.insert(twoIndex, localVariables);
                }
                ++n2;
            }
        }
        this.populateLocals(output, localVariables);
        this.initNameTable(javaMethod);
        this.level = level;
    }

    @Override
    protected String getPreferredName(int index) {
        return this.lvNames[index];
    }

    private void initNameTable(Method javaMethod) {
        LocalVariableTable lvTable;
        this.lvNames = new String[this.locals.length];
        int i = 0;
        while (i < this.lvNames.length) {
            this.lvNames[i] = super.getPreferredName(i);
            ++i;
        }
        if (javaMethod != null && (lvTable = javaMethod.getLocalVariableTable()) != null) {
            LocalVariable[] locals;
            HashSet<String> names = new HashSet<String>();
            LocalVariable[] localVariableArray = locals = lvTable.getLocalVariableTable();
            int n = locals.length;
            int n2 = 0;
            while (n2 < n) {
                LocalVariable localVariable = localVariableArray[n2];
                int index = localVariable.getIndex();
                String preferredName = localVariable.getName();
                if (names.contains(preferredName = preferredName.replace("$", "_"))) {
                    preferredName = String.valueOf(preferredName) + "_" + index;
                }
                this.lvNames[index] = preferredName;
                names.add(preferredName);
                ++n2;
            }
        }
    }

    private void handleVolatileLocals(Method javaMethod) {
        Attribute[] attributes;
        Attribute[] attributeArray = attributes = javaMethod.getAttributes();
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            AnnotationsAttribute icecapAttribute;
            IcecapVolatile volatiles;
            Attribute attribute = attributeArray[n2];
            if (attribute instanceof AnnotationsAttribute && (volatiles = (IcecapVolatile)(icecapAttribute = (AnnotationsAttribute)attribute).getAnnotation(IcecapVolatile.class)) != null) {
                String volatileList = volatiles.value();
                StringTokenizer tokenizer = new StringTokenizer(volatileList, " ,:;.");
                while (tokenizer.hasMoreTokens()) {
                    this.volatiles.add(tokenizer.nextToken());
                }
            }
            ++n2;
        }
    }

    private void populateLocals(StringBuffer output, NoDuplicatesMemorySegment localVariables) {
        int index = 0;
        while (index < this.locals.length) {
            if (this.locals[index] == null) {
                this.locals[index] = new LocalVariableManager.LocalVariable();
                this.locals[index].size = 3;
            }
            ++index;
        }
    }

    private void insert(LocalVariable localVariable, NoDuplicatesMemorySegment localVariables) {
        int size = AOTCompiler.getVariableSize(localVariable);
        int index = localVariable.getIndex();
        if (this.locals[index] == null) {
            this.locals[index] = new LocalVariableManager.LocalVariable();
            this.locals[index].size = size;
        } else if (this.locals[index].size < size) {
            this.locals[index].size = size;
        }
        if (this.volatiles.contains(localVariable.getName())) {
            this.locals[index].modifier = "volatile";
        }
    }

    @Override
    public void merge(LocalVariableManager other, int pc, StringBuffer output, NoDuplicatesMemorySegment localVariables) throws Exception {
    }

    @Override
    public void load(int size, int index, int pc, StringBuffer output, NoDuplicatesMemorySegment localVariables) {
    }

    @Override
    public void flush(StringBuffer output, boolean doit) {
    }

    @Override
    public boolean equals(Object obj) {
        return true;
    }

    @Override
    protected void copy(LocalVariableManager right) {
        this.locals = right.locals;
        this.level = ((TypeAwareVariableManager)right).level;
        this.lvNames = ((TypeAwareVariableManager)right).lvNames;
    }

    @Override
    public String getLocal(int index, int pc) throws Exception {
        return super.getLocal(index, pc);
    }

    @Override
    public void setLocal(int size, int index, int pc, NoDuplicatesMemorySegment localVariables) throws Exception {
    }
}

