/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.compiler.aot;

import icecaptools.compiler.NoDuplicatesMemorySegment;
import icecaptools.compiler.aot.AOTCompiler;
import icecaptools.compiler.aot.LocalVariableManager;

public class CachingLocalVariableManager
extends LocalVariableManager {
    private static final String LV_PREFIX = "lv_";

    public CachingLocalVariableManager(int maxLocals) {
        super(maxLocals);
    }

    @Override
    public void merge(LocalVariableManager other, int pc, StringBuffer output, NoDuplicatesMemorySegment localVariables) throws Exception {
        int i = 0;
        while (i < this.locals.length) {
            LocalVariableManager.LocalVariable left = this.locals[i];
            LocalVariableManager.LocalVariable right = other.locals[i];
            if (left == null && right != null) {
                this.load(right.size, i, pc, output, localVariables);
            } else if (left != null && right == null) {
                String lvType = AOTCompiler.getTypeCast(left.size);
                String lvName = this.localVariableCacheName(i);
                output.append("   *(" + lvType + "*)(fp + " + i + ") = " + lvName + ";\n");
                this.locals[i] = null;
            }
            ++i;
        }
    }

    private String localVariableCacheName(int i) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getPreferredName(i));
        this.locals[i].used = true;
        return buffer.toString();
    }

    @Override
    public void clear() {
        int i = 0;
        while (i < this.locals.length) {
            if (this.locals[i] != null) {
                this.locals[i].used = false;
            }
            ++i;
        }
    }

    protected String getPreferredName(int index) {
        return LV_PREFIX + index;
    }

    @Override
    public void flush(StringBuffer output, boolean doit) {
        int i = 0;
        while (i < this.locals.length) {
            LocalVariableManager.LocalVariable current = this.locals[i];
            if (current != null) {
                String lvType = AOTCompiler.getTypeCast(current.size);
                String lvName = this.localVariableCacheName(i);
                output.append("   *(" + lvType + "*)(fp + " + i + ") = " + lvName + ";\n");
            }
            if (doit) {
                this.locals[i] = null;
            }
            ++i;
        }
    }

    @Override
    public void load(int size, int index, int pc, StringBuffer output, NoDuplicatesMemorySegment localVariables) {
        if (this.locals[index] == null) {
            this.locals[index] = new LocalVariableManager.LocalVariable();
            this.locals[index].size = size;
            this.loadIt(size, index, output, localVariables, ";\n");
        }
    }

    @Override
    public String generateLocalInitialization(NoDuplicatesMemorySegment localVariables, int from, int to, String seperator, boolean forceLoad) {
        StringBuffer initBuffer = new StringBuffer();
        int index = from;
        while (index < to) {
            if (this.locals[index].used || forceLoad) {
                this.loadIt(this.locals[index].size, index, initBuffer, localVariables, seperator);
            }
            ++index;
        }
        return initBuffer.toString();
    }

    protected void loadIt(int size, int index, StringBuffer output, NoDuplicatesMemorySegment localVariables, String seperator) {
        String lvName = this.localVariableCacheName(index);
        String lvType = AOTCompiler.getTypeCast(size);
        String modifier = this.locals[index].modifier;
        String init = "";
        if (size != 4) {
            output.append("   " + lvName + " = (" + lvType + ")(*(fp + " + index + "));\n");
        } else {
            output.append("   " + lvName + " = *(" + lvType + "*)(fp + " + index + ");\n");
        }
        if (lvName.startsWith(LV_PREFIX) && seperator.contains("\n")) {
            init = " = 0";
        }
        localVariables.print("   " + modifier + " " + lvType + " " + lvName + init + seperator);
    }

    @Override
    public String getLocal(int index, int pc) throws Exception {
        if (this.locals[index] != null) {
            String lvName = this.localVariableCacheName(index);
            return lvName;
        }
        throw new Exception("Accessing unloaded local variable");
    }

    @Override
    public void setLocal(int size, int index, int pc, NoDuplicatesMemorySegment localVariables) throws Exception {
        this.setIt(size, index, localVariables);
    }

    protected void setIt(int size, int index, NoDuplicatesMemorySegment localVariables) {
        if (this.locals[index] == null) {
            this.locals[index] = new LocalVariableManager.LocalVariable();
            this.locals[index].size = size;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CachingLocalVariableManager) {
            CachingLocalVariableManager other = (CachingLocalVariableManager)obj;
            int i = 0;
            while (i < this.locals.length) {
                LocalVariableManager.LocalVariable left = this.locals[i];
                LocalVariableManager.LocalVariable right = other.locals[i];
                if (left == null && right != null) {
                    return false;
                }
                if (left != null && right == null) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }
}

