/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.compiler;

import icecaptools.ClassfileUtils;
import icecaptools.FieldOffsetCalculator;
import icecaptools.JavaArrayClass;
import icecaptools.compiler.FieldInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.bcel.classfile.JavaClass;
import util.ReferenceOffsets;

public class ReferencesManager {
    private FieldOffsetCalculator foCalc;
    private HashSet<JavaClass> referenceClasses;

    public ReferencesManager(FieldOffsetCalculator foCalc) {
        this.foCalc = foCalc;
        this.referenceClasses = new HashSet();
    }

    public StringBuffer generateReferenceFieldOffsets(String GCSUPPORTTAG) throws Exception {
        StringBuffer buffer = new StringBuffer();
        HashMap<JavaClass, ArrayList<FieldInfo>> classFieldsMap = this.foCalc.getObjectFields();
        Iterator<JavaClass> classes = classFieldsMap.keySet().iterator();
        buffer.append("#if defined(" + GCSUPPORTTAG + ")\n");
        while (classes.hasNext()) {
            JavaClass next = classes.next();
            if (next instanceof JavaArrayClass) continue;
            ReferenceOffsets offsets = new ReferenceOffsets();
            ArrayList<FieldInfo> fields = classFieldsMap.get(next);
            for (FieldInfo fieldInfo : fields) {
                if (!fieldInfo.isReference) continue;
                offsets.insert((short)(fieldInfo.getOffset() >> 3));
            }
            if (offsets.size() <= 0) continue;
            this.setHasReferences(next);
            buffer.append("RANGE const static unsigned short ");
            buffer.append(ClassfileUtils.getClassNameIdentifier(next.getClassName()));
            buffer.append("_references[");
            buffer.append(1 + offsets.shortOffsetsSize() + (offsets.byteOffsetsSize() + 1) / 2);
            buffer.append("] PROGMEM = {\n");
            int x = offsets.shortOffsetsSize() << 8;
            buffer.append("    0x");
            buffer.append(Integer.toHexString(x += offsets.byteOffsetsSize()));
            offsets.startScanShortOffsets();
            int i = 0;
            while (i < offsets.shortOffsetsSize()) {
                buffer.append(",\n");
                buffer.append("    0x");
                buffer.append(Integer.toHexString(offsets.getNextShortOffset()));
                ++i;
            }
            offsets.startScanByteOffsets();
            i = 0;
            while (i < offsets.byteOffsetsSize()) {
                x = offsets.getNextByteOffset();
                if (++i < offsets.byteOffsetsSize()) {
                    x |= offsets.getNextByteOffset() << 8;
                    ++i;
                }
                buffer.append(",\n");
                buffer.append("    0x");
                buffer.append(Integer.toHexString(x));
            }
            buffer.append("\n");
            buffer.append("};\n");
        }
        buffer.append("#endif\n");
        return buffer;
    }

    private void setHasReferences(JavaClass next) {
        this.referenceClasses.add(next);
    }

    public boolean hasReferences(JavaClass currentClass) {
        String className = currentClass.getClassName();
        if ("java.lang.Class".equals(className)) {
            return false;
        }
        return this.referenceClasses.contains(currentClass);
    }
}

