/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Type;

public class NativeFileManager {
    private StringBuffer sourceFileContent = new StringBuffer();
    private StringBuffer headerFileContent = new StringBuffer();
    private StringBuffer nativeFileHeader = new StringBuffer();
    private StringBuffer nativeFileHostSource = new StringBuffer();
    private StringBuffer nativeFileTargetSource = new StringBuffer();
    private ArrayList<String> nativeFunctions;
    private boolean functionsSorted;
    private ArrayList<String> compiledFunctions;
    public static final String UserNativeFunctionExtensionPointId = "icecaptools.UserNativeFunction";
    public static final String UserNativeFunctionExtensionPointElement = "class";

    public NativeFileManager(boolean nUMBEROFCLASSES_varUsed, int numberOfClasses) {
        this.nativeFileHeader.append("#ifndef NATIVES_H_\n");
        this.nativeFileHeader.append("#define NATIVES_H_\n");
        this.nativeFileHeader.append("#include \"ostypes.h\"\n\n");
        this.nativeFileHeader.append("typedef int16 (*fptr)(int32 *sp);\n\n");
        this.nativeFileHeader.append("fptr readNativeFunc(void);\n\n");
        this.nativeFileHeader.append("void dumpNativeFunc(int16(*nativeFunc)(int32 *sp), const char* functionName);\n");
        this.nativeFileHeader.append("int16 unknownNativeFunc(int32 *sp);\n");
        this.nativeFileHeader.append("#define UNKNOWNNATIVEFUNC 42\n");
        this.nativeFileTargetSource.append("#include \"natives.h\"\n\n");
        this.nativeFileTargetSource.append("extern unsigned char readByte();\n");
        this.nativeFileTargetSource.append("extern void printStr(const char* str);\n");
        if (nUMBEROFCLASSES_varUsed) {
            this.nativeFileTargetSource.append("\nRANGE uint16 NUMBEROFCLASSES_var = " + numberOfClasses + ";\n\n");
        }
        this.nativeFileTargetSource.append("fptr readNativeFunc(void) {\n");
        this.nativeFileTargetSource.append("    unsigned char b = readByte();\n");
        this.nativeFileTargetSource.append("    switch (b) {\n");
        this.nativeFileHostSource.append("#include \"natives.h\"\n\n");
        this.nativeFileHostSource.append("#include <stdio.h>\n\n");
        this.nativeFileHostSource.append("#include <stdlib.h>\n\n");
        this.nativeFileHostSource.append("extern void dumpByte(unsigned char b);\n");
        this.nativeFileHostSource.append("void dumpNativeFunc(int16(*nativeFunc)(int32 *sp), const char* functionName) {\n");
        this.nativeFunctions = new ArrayList();
        this.compiledFunctions = new ArrayList();
        this.functionsSorted = false;
    }

    public void addCompiledMethod(int methodNumber, String uniqueMethodId, Method javaMethod, boolean skipMethodHack) {
        this.compiledFunctions.add(uniqueMethodId);
    }

    public void addNativeMethod(int methodNumber, String uniqueMethodId, Method javaMethod, boolean skipMethod) {
        if (javaMethod.isNative() || skipMethod) {
            this.sourceFileContent.append("/* " + javaMethod.getName() + "\n");
            this.sourceFileContent.append(" * param : " + NativeFileManager.getParameters(javaMethod) + "\n");
            this.sourceFileContent.append(" * return: " + javaMethod.getReturnType().toString() + "\n");
            this.sourceFileContent.append(" */\n");
            if (skipMethod) {
                this.sourceFileContent.append("#ifndef EXCLUDESTUB_" + uniqueMethodId.toUpperCase() + "\n");
                this.sourceFileContent.append("int16 " + uniqueMethodId + "(int32 *sp)\n");
                this.sourceFileContent.append("{\n");
                this.sourceFileContent.append("   unimplemented_native_function(" + uniqueMethodId.toUpperCase() + ");\n");
                this.sourceFileContent.append("   return -1;\n");
                this.sourceFileContent.append("}\n");
                this.sourceFileContent.append("#else\n");
            }
            this.sourceFileContent.append("extern int16 " + uniqueMethodId + "(int32 *sp);\n");
            if (skipMethod) {
                this.sourceFileContent.append("#endif\n\n");
            }
            this.nativeFunctions.add(uniqueMethodId);
            this.headerFileContent.append("#define ");
            this.headerFileContent.append(uniqueMethodId.toUpperCase());
            this.headerFileContent.append(" " + methodNumber);
            this.headerFileContent.append("\n");
        }
    }

    public static String getParameters(Method javaMethod) {
        StringBuffer buffer = new StringBuffer();
        Type[] arguments = javaMethod.getArgumentTypes();
        if (arguments != null) {
            int count = 0;
            while (count < arguments.length) {
                buffer.append(arguments[count].toString());
                if (count < arguments.length - 1) {
                    buffer.append(", ");
                }
                ++count;
            }
        }
        return buffer.toString();
    }

    public String getDeclerations(StringBuffer additionalHeaderFileContent) {
        additionalHeaderFileContent.append(this.headerFileContent);
        return this.sourceFileContent.toString();
    }

    public String getNativeHeader() {
        int numCount = 43;
        this.ensureArray();
        Iterator<String> functionsItr = this.nativeFunctions.iterator();
        while (functionsItr.hasNext()) {
            numCount = this.addMethodToHeader(numCount, functionsItr);
        }
        functionsItr = this.compiledFunctions.iterator();
        while (functionsItr.hasNext()) {
            numCount = this.addMethodToHeader(numCount, functionsItr);
        }
        this.nativeFileHeader.append("#endif /* NATIVES_H_ */\n");
        return this.nativeFileHeader.toString();
    }

    private int addMethodToHeader(int numCount, Iterator<String> functionsItr) {
        String uniqueMethodId = functionsItr.next();
        this.nativeFileHeader.append("#define ");
        this.nativeFileHeader.append(uniqueMethodId.toUpperCase());
        this.nativeFileHeader.append("_NUM " + numCount + "\n");
        this.nativeFileHeader.append("int16 " + uniqueMethodId + "(int32 *sp);\n\n");
        return ++numCount;
    }

    private void ensureArray() {
        if (!this.functionsSorted) {
            Object[] array = this.nativeFunctions.toArray();
            Arrays.sort(array);
            this.nativeFunctions = new ArrayList();
            int i = 0;
            while (i < array.length) {
                this.nativeFunctions.add((String)array[i]);
                ++i;
            }
            this.functionsSorted = true;
        }
    }

    public String getNativeTargetSource() {
        this.ensureArray();
        Iterator<String> functionsItr = this.nativeFunctions.iterator();
        while (functionsItr.hasNext()) {
            this.handleMethodInTargetFile(functionsItr.next());
        }
        functionsItr = this.compiledFunctions.iterator();
        while (functionsItr.hasNext()) {
            this.handleMethodInTargetFile(functionsItr.next());
        }
        this.nativeFileTargetSource.append("    }\n");
        this.nativeFileTargetSource.append("    return unknownNativeFunc;\n");
        this.nativeFileTargetSource.append("}\n");
        return this.nativeFileTargetSource.toString();
    }

    public String getNativeHostSource() {
        StringBuffer nativeStubs = new StringBuffer();
        boolean oneTime = true;
        this.ensureArray();
        Iterator<String> functionsItr = this.nativeFunctions.iterator();
        while (functionsItr.hasNext()) {
            oneTime = this.handleMethodInHostFile(nativeStubs, oneTime, functionsItr, false);
        }
        functionsItr = this.compiledFunctions.iterator();
        while (functionsItr.hasNext()) {
            oneTime = this.handleMethodInHostFile(nativeStubs, oneTime, functionsItr, false);
        }
        this.nativeFileHostSource.append("    } else {\n");
        this.nativeFileHostSource.append("        dumpByte(UNKNOWNNATIVEFUNC);\n");
        this.nativeFileHostSource.append("    }\n");
        this.nativeFileHostSource.append("}\n\n");
        this.nativeFileHostSource.append(nativeStubs.toString());
        return this.nativeFileHostSource.toString();
    }

    private void handleMethodInTargetFile(String uniqueMethodId) {
        this.nativeFileTargetSource.append("    case " + uniqueMethodId.toUpperCase() + "_NUM:\n");
        this.nativeFileTargetSource.append("        return " + uniqueMethodId + ";\n");
    }

    private boolean handleMethodInHostFile(StringBuffer nativeStubs, boolean oneTime, Iterator<String> functionsItr, boolean addStub) {
        String uniqueMethodId = functionsItr.next();
        if (oneTime) {
            this.nativeFileHostSource.append("    if (nativeFunc == " + uniqueMethodId + ") {\n");
            oneTime = false;
        } else {
            this.nativeFileHostSource.append("    } else if (nativeFunc == " + uniqueMethodId + ") {\n");
        }
        this.nativeFileHostSource.append("        dumpByte(" + uniqueMethodId.toUpperCase() + "_NUM);\n");
        if (addStub) {
            nativeStubs.append("int16 " + uniqueMethodId + "(int32 *sp) {\n");
            nativeStubs.append("   return -1;\n");
            nativeStubs.append("}\n\n");
        }
        return oneTime;
    }
}

