/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.compiler;

import icecaptools.IcecapIterator;
import icecaptools.MethodOrFieldDesc;
import icecaptools.compiler.ICompilationRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class CompilationRegistry
implements ICompilationRegistry {
    private HashMap<String, ArrayList<MethodOrFieldDesc>> compiledClasses = new HashMap();
    private HashMap<String, ArrayList<MethodOrFieldDesc>> excludedClasses = new HashMap();
    private boolean clearOutputFolder = false;

    public void initializeFromString(String encoded) {
        this.compiledClasses = new HashMap();
        this.excludedClasses = new HashMap();
        StringTokenizer tokenizer = new StringTokenizer(encoded, "!");
        CompilationRegistry.initializeFromString(this.compiledClasses, tokenizer);
        CompilationRegistry.initializeFromString(this.excludedClasses, tokenizer);
        this.initializeFromString(tokenizer);
    }

    private void initializeFromString(StringTokenizer tokenizer) {
        if (tokenizer.hasMoreTokens()) {
            String next = tokenizer.nextToken();
            this.clearOutputFolder = "true".equals(next);
        }
    }

    private static void initializeFromString(HashMap<String, ArrayList<MethodOrFieldDesc>> map, StringTokenizer tokenizer) {
        int numberOfClasses = tokenizer.hasMoreTokens() ? Integer.parseInt(tokenizer.nextToken()) : 0;
        while (numberOfClasses > 0) {
            String className = tokenizer.nextToken();
            int numberOfMethods = Integer.parseInt(tokenizer.nextToken());
            ArrayList<MethodOrFieldDesc> methods = new ArrayList<MethodOrFieldDesc>();
            while (numberOfMethods > 0) {
                String methodName = tokenizer.nextToken();
                String signature = tokenizer.nextToken();
                methods.add(new MethodOrFieldDesc(className, methodName, signature));
                --numberOfMethods;
            }
            map.put(className, methods);
            --numberOfClasses;
        }
    }

    public void toggleMethodCompilation(MethodOrFieldDesc mdesc) {
        CompilationRegistry.toggleMethodProperty(mdesc, this.compiledClasses);
    }

    private static void toggleMethodProperty(MethodOrFieldDesc mdesc, HashMap<String, ArrayList<MethodOrFieldDesc>> map) {
        ArrayList<MethodOrFieldDesc> methods = map.get(mdesc.getClassName());
        if (methods == null) {
            methods = new ArrayList();
            map.put(mdesc.getClassName(), methods);
        }
        if (methods.contains(mdesc)) {
            methods.remove(mdesc);
        } else {
            methods.add(mdesc);
        }
    }

    public void toggleMethodExclusion(MethodOrFieldDesc mdesc) {
        CompilationRegistry.toggleMethodProperty(mdesc, this.excludedClasses);
    }

    public boolean isClassCompiled(String className) {
        ArrayList<MethodOrFieldDesc> compiledMethods = this.compiledClasses.get(className);
        return compiledMethods != null && compiledMethods.size() > 0;
    }

    @Override
    public boolean isMethodCompiled(MethodOrFieldDesc mdesc) {
        return CompilationRegistry.isMethodSelected(mdesc, this.compiledClasses);
    }

    public boolean isMethodExcluded(MethodOrFieldDesc mdesc) {
        return CompilationRegistry.isMethodSelected(mdesc, this.excludedClasses);
    }

    @Override
    public boolean isMethodExcluded(String clazz, String targetMethodName, String targetMethodSignature) {
        return this.isMethodExcluded(new MethodOrFieldDesc(clazz, targetMethodName, targetMethodSignature));
    }

    private static boolean isMethodSelected(MethodOrFieldDesc mdesc, HashMap<String, ArrayList<MethodOrFieldDesc>> map) {
        ArrayList<MethodOrFieldDesc> methods = map.get(mdesc.getClassName());
        return methods != null && methods.contains(mdesc);
    }

    public String encodeToString() {
        return String.valueOf(CompilationRegistry.encodeToString(this.compiledClasses)) + "!" + CompilationRegistry.encodeToString(this.excludedClasses) + "!" + this.clearOutputFolder;
    }

    private static String encodeToString(HashMap<String, ArrayList<MethodOrFieldDesc>> map) {
        StringBuffer buffer = new StringBuffer();
        int count = 0;
        for (Map.Entry<String, ArrayList<MethodOrFieldDesc>> next : map.entrySet()) {
            String key = next.getKey();
            ArrayList<MethodOrFieldDesc> value = next.getValue();
            if (value.size() <= 0) continue;
            ++count;
            buffer.append(String.valueOf(key) + "!");
            buffer.append(String.valueOf(value.size()) + "!");
            for (MethodOrFieldDesc nextMethod : value) {
                buffer.append(String.valueOf(nextMethod.getName()) + "!");
                buffer.append(String.valueOf(nextMethod.getSignature()) + "!");
            }
        }
        if (count > 0) {
            return String.valueOf(count) + "!" + buffer.substring(0, buffer.length() - 1);
        }
        return String.valueOf(count) + "!";
    }

    public IcecapIterator<MethodOrFieldDesc> getExcludedMethods() {
        return new ExcludedMethodsIterator();
    }

    @Override
    public boolean alwaysClearOutputFolder() {
        return this.clearOutputFolder;
    }

    public void toggleFolderClearing() {
        this.clearOutputFolder = !this.clearOutputFolder;
    }

    private class ExcludedMethodsIterator
    implements IcecapIterator<MethodOrFieldDesc> {
        private Iterator<Map.Entry<String, ArrayList<MethodOrFieldDesc>>> classes;
        private Iterator<MethodOrFieldDesc> methods;

        ExcludedMethodsIterator() {
            this.classes = CompilationRegistry.this.excludedClasses.entrySet().iterator();
            this.methods = null;
        }

        @Override
        public boolean hasNext() {
            if (this.methods == null) {
                if (this.classes.hasNext()) {
                    Map.Entry<String, ArrayList<MethodOrFieldDesc>> next = this.classes.next();
                    ArrayList<MethodOrFieldDesc> value = next.getValue();
                    this.methods = value.iterator();
                    return this.hasNext();
                }
                return false;
            }
            if (this.methods.hasNext()) {
                return true;
            }
            this.methods = null;
            return this.hasNext();
        }

        @Override
        public MethodOrFieldDesc next() {
            return this.methods.next();
        }
    }
}

