/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.compiler;

import icecaptools.AnalysisObserver;
import icecaptools.NativeFieldInfo;
import icecaptools.compiler.FieldInfo;
import icecaptools.compiler.MemorySegment;
import java.util.ArrayList;

public class ClassFieldsManager {
    public static final String classDataVariable = "_classData";
    public static final String staticReferenceOffsetsVariable = "staticReferenceOffsets";
    public static final String NUMBEROFCLASSES_varVariable = "NUMBEROFCLASSES_var";
    private ArrayList<FieldInfo> referenceFields = new ArrayList();
    private int classDataLength = 0;
    private boolean staticReferenceOffsetsVariableUsed = false;
    public boolean NUMBEROFCLASSES_varUsed = false;

    ClassFieldsManager() {
    }

    public void addClassFields(String currentClassName, ArrayList<FieldInfo> fieldSet, AnalysisObserver observer) throws ClassNotFoundException {
        if (fieldSet.size() > 0) {
            for (FieldInfo currentField : fieldSet) {
                NativeFieldInfo nfi;
                if (staticReferenceOffsetsVariable.equals(currentField.getName())) {
                    this.staticReferenceOffsetsVariableUsed = true;
                }
                if (NUMBEROFCLASSES_varVariable.equals(currentField.getName())) {
                    this.NUMBEROFCLASSES_varUsed = true;
                }
                if ((nfi = observer.isNativeField(currentClassName, currentField)) != null) continue;
                int fieldSize = currentField.getSize() & 0xFC;
                int currentEnd = currentField.getOffset() + fieldSize;
                if (currentEnd > this.classDataLength) {
                    this.classDataLength = currentEnd;
                }
                if (!currentField.isReference) continue;
                this.referenceFields.add(currentField);
            }
        }
    }

    public boolean finalizeClassfieldDeclarations(MemorySegment buffer) {
        while (this.classDataLength % 8 > 0) {
            ++this.classDataLength;
        }
        int numberOfBytes = this.classDataLength >> 3;
        if (numberOfBytes > 0) {
            buffer.appendData("static unsigned char _classData[" + numberOfBytes + "] = {", 0);
            while (numberOfBytes > 0) {
                buffer.appendData(" 0", 1);
                if (--numberOfBytes <= 0) continue;
                buffer.appendData(",", 0);
            }
            buffer.print("};\n\n");
        }
        if (this.staticReferenceOffsetsVariableUsed) {
            buffer.appendData("RANGE static const uint32 _staticReferenceOffsets[" + (this.referenceFields.size() + 1) + "] PROGMEM = { ", 0);
            buffer.appendData(String.valueOf(this.referenceFields.size()), 0);
            for (FieldInfo next : this.referenceFields) {
                StringBuffer offsetof = new StringBuffer();
                offsetof.append("offsetof(struct ").append(next.getStructName()).append(", ");
                offsetof.append(next.getStructMemberName()).append(")");
                buffer.appendData(", ", 0);
                buffer.appendData(offsetof.toString(), 0);
            }
            buffer.appendData("};\n", 0);
        }
        return this.staticReferenceOffsetsVariableUsed;
    }

    public boolean hasClassFields() {
        return this.classDataLength > 0;
    }

    public int getClassDataSize() {
        return this.classDataLength >> 3;
    }
}

