/*
 * Decompiled with CFR 0.152.
 */
package icecaptools.compiler;

import icecaptools.AnalysisObserver;

public class ByteCodeReporter {
    public static String reportUsedByteCodes(AnalysisObserver observer) {
        StringBuffer defines = new StringBuffer();
        int i = 0;
        while (i < 255) {
            String name = ByteCodeReporter.getName(i);
            if (name != null && observer.isBytecodeUsed(i)) {
                defines.append("#define ");
                defines.append(ByteCodeReporter.getName(i).toUpperCase());
                defines.append("_used ".toUpperCase());
                defines.append("\n");
            }
            ++i;
        }
        return defines.toString();
    }

    private static String getName(int i) {
        String name = null;
        switch (i) {
            case 0: {
                name = "nop_opcode";
                break;
            }
            case 1: {
                name = "aconst_null_opcode";
                break;
            }
            case 2: {
                name = "iconst_m1_opcode";
                break;
            }
            case 3: {
                name = "iconst_0_opcode";
                break;
            }
            case 4: {
                name = "iconst_1_opcode";
                break;
            }
            case 5: {
                name = "iconst_2_opcode";
                break;
            }
            case 6: {
                name = "iconst_3_opcode";
                break;
            }
            case 7: {
                name = "iconst_4_opcode";
                break;
            }
            case 8: {
                name = "iconst_5_opcode";
                break;
            }
            case 9: {
                name = "lconst_0_opcode";
                break;
            }
            case 10: {
                name = "lconst_1_opcode";
                break;
            }
            case 11: {
                name = "fconst_0_opcode";
                break;
            }
            case 12: {
                name = "fconst_1_opcode";
                break;
            }
            case 13: {
                name = "fconst_2_opcode";
                break;
            }
            case 14: {
                name = "dconst_0_opcode";
                break;
            }
            case 15: {
                name = "dconst_1_opcode";
                break;
            }
            case 16: {
                name = "bipush_opcode";
                break;
            }
            case 17: {
                name = "sipush_opcode";
                break;
            }
            case 18: {
                name = "ldc_opcode";
                break;
            }
            case 19: {
                name = "ldc_w_opcode";
                break;
            }
            case 20: {
                name = "ldc2_w_opcode";
                break;
            }
            case 21: {
                name = "iload_opcode";
                break;
            }
            case 22: {
                name = "lload_opcode";
                break;
            }
            case 23: {
                name = "fload_opcode";
                break;
            }
            case 24: {
                name = "dload_opcode";
                break;
            }
            case 25: {
                name = "aload_opcode";
                break;
            }
            case 26: {
                name = "iload_0_opcode";
                break;
            }
            case 27: {
                name = "iload_1_opcode";
                break;
            }
            case 28: {
                name = "iload_2_opcode";
                break;
            }
            case 29: {
                name = "iload_3_opcode";
                break;
            }
            case 30: {
                name = "lload_0_opcode";
                break;
            }
            case 31: {
                name = "lload_1_opcode";
                break;
            }
            case 32: {
                name = "lload_2_opcode";
                break;
            }
            case 33: {
                name = "lload_3_opcode";
                break;
            }
            case 34: {
                name = "fload_0_opcode";
                break;
            }
            case 35: {
                name = "fload_1_opcode";
                break;
            }
            case 36: {
                name = "fload_2_opcode";
                break;
            }
            case 37: {
                name = "fload_3_opcode";
                break;
            }
            case 38: {
                name = "dload_0_opcode";
                break;
            }
            case 39: {
                name = "dload_1_opcode";
                break;
            }
            case 40: {
                name = "dload_2_opcode";
                break;
            }
            case 41: {
                name = "dload_3_opcode";
                break;
            }
            case 42: {
                name = "aload_0_opcode";
                break;
            }
            case 43: {
                name = "aload_1_opcode";
                break;
            }
            case 44: {
                name = "aload_2_opcode";
                break;
            }
            case 45: {
                name = "aload_3_opcode";
                break;
            }
            case 46: {
                name = "iaload_opcode";
                break;
            }
            case 47: {
                name = "laload_opcode";
                break;
            }
            case 48: {
                name = "faload_opcode";
                break;
            }
            case 49: {
                name = "daload_opcode";
                break;
            }
            case 50: {
                name = "aaload_opcode";
                break;
            }
            case 51: {
                name = "baload_opcode";
                break;
            }
            case 52: {
                name = "caload_opcode";
                break;
            }
            case 53: {
                name = "saload_opcode";
                break;
            }
            case 54: {
                name = "istore_opcode";
                break;
            }
            case 55: {
                name = "lstore_opcode";
                break;
            }
            case 56: {
                name = "fstore_opcode";
                break;
            }
            case 57: {
                name = "dstore_opcode";
                break;
            }
            case 58: {
                name = "astore_opcode";
                break;
            }
            case 59: {
                name = "istore_0_opcode";
                break;
            }
            case 60: {
                name = "istore_1_opcode";
                break;
            }
            case 61: {
                name = "istore_2_opcode";
                break;
            }
            case 62: {
                name = "istore_3_opcode";
                break;
            }
            case 63: {
                name = "lstore_0_opcode";
                break;
            }
            case 64: {
                name = "lstore_1_opcode";
                break;
            }
            case 65: {
                name = "lstore_2_opcode";
                break;
            }
            case 66: {
                name = "lstore_3_opcode";
                break;
            }
            case 67: {
                name = "fstore_0_opcode";
                break;
            }
            case 68: {
                name = "fstore_1_opcode";
                break;
            }
            case 69: {
                name = "fstore_2_opcode";
                break;
            }
            case 70: {
                name = "fstore_3_opcode";
                break;
            }
            case 71: {
                name = "dstore_0_opcode";
                break;
            }
            case 72: {
                name = "dstore_1_opcode";
                break;
            }
            case 73: {
                name = "dstore_2_opcode";
                break;
            }
            case 74: {
                name = "dstore_3_opcode";
                break;
            }
            case 75: {
                name = "astore_0_opcode";
                break;
            }
            case 76: {
                name = "astore_1_opcode";
                break;
            }
            case 77: {
                name = "astore_2_opcode";
                break;
            }
            case 78: {
                name = "astore_3_opcode";
                break;
            }
            case 79: {
                name = "iastore_opcode";
                break;
            }
            case 80: {
                name = "lastore_opcode";
                break;
            }
            case 81: {
                name = "fastore_opcode";
                break;
            }
            case 82: {
                name = "dastore_opcode";
                break;
            }
            case 83: {
                name = "aastore_opcode";
                break;
            }
            case 84: {
                name = "bastore_opcode";
                break;
            }
            case 85: {
                name = "castore_opcode";
                break;
            }
            case 86: {
                name = "sastore_opcode";
                break;
            }
            case 87: {
                name = "pop_opcode";
                break;
            }
            case 88: {
                name = "pop2_opcode";
                break;
            }
            case 89: {
                name = "dup_opcode";
                break;
            }
            case 90: {
                name = "dup_x1_opcode";
                break;
            }
            case 91: {
                name = "dup_x2_opcode";
                break;
            }
            case 92: {
                name = "dup2_opcode";
                break;
            }
            case 93: {
                name = "dup2_x1_opcode";
                break;
            }
            case 94: {
                name = "dup2_x2_opcode";
                break;
            }
            case 95: {
                name = "swap_opcode";
                break;
            }
            case 96: {
                name = "iadd_opcode";
                break;
            }
            case 97: {
                name = "ladd_opcode";
                break;
            }
            case 98: {
                name = "fadd_opcode";
                break;
            }
            case 99: {
                name = "dadd_opcode";
                break;
            }
            case 100: {
                name = "isub_opcode";
                break;
            }
            case 101: {
                name = "lsub_opcode";
                break;
            }
            case 102: {
                name = "fsub_opcode";
                break;
            }
            case 103: {
                name = "dsub_opcode";
                break;
            }
            case 104: {
                name = "imul_opcode";
                break;
            }
            case 105: {
                name = "lmul_opcode";
                break;
            }
            case 106: {
                name = "fmul_opcode";
                break;
            }
            case 107: {
                name = "dmul_opcode";
                break;
            }
            case 108: {
                name = "idiv_opcode";
                break;
            }
            case 109: {
                name = "ldiv_opcode";
                break;
            }
            case 110: {
                name = "fdiv_opcode";
                break;
            }
            case 111: {
                name = "ddiv_opcode";
                break;
            }
            case 112: {
                name = "irem_opcode";
                break;
            }
            case 113: {
                name = "lrem_opcode";
                break;
            }
            case 114: {
                name = "frem_opcode";
                break;
            }
            case 115: {
                name = "drem_opcode";
                break;
            }
            case 116: {
                name = "ineg_opcode";
                break;
            }
            case 117: {
                name = "lneg_opcode";
                break;
            }
            case 118: {
                name = "fneg_opcode";
                break;
            }
            case 119: {
                name = "dneg_opcode";
                break;
            }
            case 120: {
                name = "ishl_opcode";
                break;
            }
            case 121: {
                name = "lshl_opcode";
                break;
            }
            case 122: {
                name = "ishr_opcode";
                break;
            }
            case 123: {
                name = "lshr_opcode";
                break;
            }
            case 124: {
                name = "iushr_opcode";
                break;
            }
            case 125: {
                name = "lushr_opcode";
                break;
            }
            case 126: {
                name = "iand_opcode";
                break;
            }
            case 127: {
                name = "land_opcode";
                break;
            }
            case 128: {
                name = "ior_opcode";
                break;
            }
            case 129: {
                name = "lor_opcode";
                break;
            }
            case 130: {
                name = "ixor_opcode";
                break;
            }
            case 131: {
                name = "lxor_opcode";
                break;
            }
            case 132: {
                name = "iinc_opcode";
                break;
            }
            case 133: {
                name = "i2l_opcode";
                break;
            }
            case 134: {
                name = "i2f_opcode";
                break;
            }
            case 135: {
                name = "i2d_opcode";
                break;
            }
            case 136: {
                name = "l2i_opcode";
                break;
            }
            case 137: {
                name = "l2f_opcode";
                break;
            }
            case 138: {
                name = "l2d_opcode";
                break;
            }
            case 139: {
                name = "f2i_opcode";
                break;
            }
            case 140: {
                name = "f2l_opcode";
                break;
            }
            case 141: {
                name = "f2d_opcode";
                break;
            }
            case 142: {
                name = "d2i_opcode";
                break;
            }
            case 143: {
                name = "d2l_opcode";
                break;
            }
            case 144: {
                name = "d2f_opcode";
                break;
            }
            case 145: {
                name = "i2b_opcode";
                break;
            }
            case 146: {
                name = "i2c_opcode";
                break;
            }
            case 147: {
                name = "i2s_opcode";
                break;
            }
            case 148: {
                name = "lcmp_opcode";
                break;
            }
            case 149: {
                name = "fcmpl_opcode";
                break;
            }
            case 150: {
                name = "fcmpg_opcode";
                break;
            }
            case 151: {
                name = "dcmpl_opcode";
                break;
            }
            case 152: {
                name = "dcmpg_opcode";
                break;
            }
            case 153: {
                name = "ifeq_opcode";
                break;
            }
            case 154: {
                name = "ifne_opcode";
                break;
            }
            case 155: {
                name = "iflt_opcode";
                break;
            }
            case 156: {
                name = "ifge_opcode";
                break;
            }
            case 157: {
                name = "ifgt_opcode";
                break;
            }
            case 158: {
                name = "ifle_opcode";
                break;
            }
            case 159: {
                name = "if_icmpeq_opcode";
                break;
            }
            case 160: {
                name = "if_icmpne_opcode";
                break;
            }
            case 161: {
                name = "if_icmplt_opcode";
                break;
            }
            case 162: {
                name = "if_icmpge_opcode";
                break;
            }
            case 163: {
                name = "if_icmpgt_opcode";
                break;
            }
            case 164: {
                name = "if_icmple_opcode";
                break;
            }
            case 165: {
                name = "if_acmpeq_opcode";
                break;
            }
            case 166: {
                name = "if_acmpne_opcode";
                break;
            }
            case 167: {
                name = "goto_opcode";
                break;
            }
            case 168: {
                name = "jsr_opcode";
                break;
            }
            case 169: {
                name = "ret_opcode";
                break;
            }
            case 170: {
                name = "tableswitch_opcode";
                break;
            }
            case 171: {
                name = "lookupswitch_opcode";
                break;
            }
            case 172: {
                name = "ireturn_opcode";
                break;
            }
            case 173: {
                name = "lreturn_opcode";
                break;
            }
            case 174: {
                name = "freturn_opcode";
                break;
            }
            case 175: {
                name = "dreturn_opcode";
                break;
            }
            case 176: {
                name = "areturn_opcode";
                break;
            }
            case 177: {
                name = "return_opcode";
                break;
            }
            case 178: {
                name = "getstatic_opcode";
                break;
            }
            case 179: {
                name = "putstatic_opcode";
                break;
            }
            case 180: {
                name = "getfield_opcode";
                break;
            }
            case 181: {
                name = "putfield_opcode";
                break;
            }
            case 182: {
                name = "invokevirtual_opcode";
                break;
            }
            case 183: {
                name = "invokespecial_opcode";
                break;
            }
            case 184: {
                name = "invokestatic_opcode";
                break;
            }
            case 185: {
                name = "invokeinterface_opcode";
                break;
            }
            case 187: {
                name = "new_opcode";
                break;
            }
            case 188: {
                name = "newarray_opcode";
                break;
            }
            case 189: {
                name = "anewarray_opcode";
                break;
            }
            case 190: {
                name = "arraylength_opcode";
                break;
            }
            case 191: {
                name = "athrow_opcode";
                break;
            }
            case 192: {
                name = "checkcast_opcode";
                break;
            }
            case 193: {
                name = "instanceof_opcode";
                break;
            }
            case 194: {
                name = "monitorenter_opcode";
                break;
            }
            case 195: {
                name = "monitorexit_opcode";
                break;
            }
            case 196: {
                name = "wide_opcode";
                break;
            }
            case 197: {
                name = "multianewarray_opcode";
                break;
            }
            case 198: {
                name = "ifnull_opcode";
                break;
            }
            case 199: {
                name = "ifnonnull_opcode";
                break;
            }
            case 200: {
                name = "goto_w_opcode";
                break;
            }
            case 201: {
                name = "jsr_w_opcode";
                break;
            }
            case 202: {
                name = "invoke_clone_onarray";
                break;
            }
            case 203: {
                name = "gethwfield_opcode";
                break;
            }
            case 204: {
                name = "puthwfield_opcode";
                break;
            }
            case 205: {
                name = "newflasharray_opcode";
            }
        }
        return name;
    }
}

