/*
 * Decompiled with CFR 0.152.
 */
package icecaptools;

import icecaptools.AnalysisObserver;
import icecaptools.AnnotationsAttribute;
import icecaptools.CFuncInfo;
import icecaptools.CanceledByUserException;
import icecaptools.ClassfileUtils;
import icecaptools.IcecapCFunc;
import icecaptools.IcecapCVar;
import icecaptools.IcecapIterator;
import icecaptools.IcecapProgressMonitor;
import icecaptools.MethodOrFieldDesc;
import icecaptools.NativeFieldInfo;
import icecaptools.ToIcecapIterator;
import icecaptools.compiler.FieldInfo;
import icecaptools.compiler.utils.MethodMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.RuntimeInvisibleAnnotations;

public class UsedElementsObserver
implements AnalysisObserver {
    private MethodMap<MethodOrFieldDesc> usedMethods = new MethodMap();
    private HashSet<String> usedInterfaces;
    private HashSet<String> usedClasses = new HashSet();
    private HashSet<MethodOrFieldDesc> usedMethodDescriptors;
    private HashSet<MethodOrFieldDesc> usedClassFields;
    private IcecapProgressMonitor progressMonitor;
    private HashSet<String> lockingTypes;
    private ArrayList<String> classInitializationSequence;
    private HashMap<String, NativeFieldInfo> nativeFields;
    private HashMap<String, CFuncInfo> cFunctions;
    private boolean[] usedByteCodes;
    private ArrayList<MethodOrFieldDesc> sortedMethodDescriptors = null;
    private int maxVTableSize;

    public UsedElementsObserver() {
        this.usedInterfaces = new HashSet();
        this.usedMethodDescriptors = new HashSet();
        this.usedClassFields = new HashSet();
        this.lockingTypes = new HashSet();
        this.usedByteCodes = new boolean[255];
        this.nativeFields = new HashMap();
        this.classInitializationSequence = new ArrayList();
        this.cFunctions = new HashMap();
    }

    @Override
    public void classUsed(String newType) {
        if (!this.usedClasses.contains(newType)) {
            this.usedClasses.add(newType);
        }
    }

    @Override
    public void methodCodeUsed(String className, String targetMethodName, String targetMethodSignature, boolean report) throws CanceledByUserException {
        if (!this.usedMethods.contains(className, targetMethodName, targetMethodSignature)) {
            MethodOrFieldDesc methodDesc = new MethodOrFieldDesc(className, targetMethodName, targetMethodSignature);
            this.usedMethodDescriptors.add(methodDesc);
            this.usedMethods.put(className, targetMethodName, targetMethodSignature, methodDesc);
            this.sortedMethodDescriptors = null;
            if (report) {
                this.progressMonitor.worked(String.valueOf(className) + ": " + targetMethodName);
            }
            if (this.progressMonitor.isCanceled()) {
                throw new CanceledByUserException();
            }
        }
    }

    @Override
    public Iterator<String> getUsedClasses() {
        return this.usedClasses.iterator();
    }

    @Override
    public boolean isMethodUsed(String className, String methodName, String methodSignature) {
        return this.usedMethods.contains(className, methodName, methodSignature);
    }

    @Override
    public IcecapIterator<MethodOrFieldDesc> getUsedMethods() {
        if (this.sortedMethodDescriptors == null) {
            this.sortedMethodDescriptors = new ArrayList<MethodOrFieldDesc>(this.usedMethodDescriptors);
            Collections.sort(this.sortedMethodDescriptors);
        }
        return new ToIcecapIterator<MethodOrFieldDesc>(this.sortedMethodDescriptors.iterator());
    }

    @Override
    public void interfaceUsed(String className) {
        this.usedInterfaces.add(className);
    }

    @Override
    public boolean isInterfaceUsed(String className) {
        return this.usedInterfaces.contains(className);
    }

    @Override
    public void setProgressMonitor(IcecapProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    @Override
    public void classFieldUsed(String className, String fieldName) {
        if (!this.isClassFieldUsed(className, fieldName)) {
            this.usedClassFields.add(new MethodOrFieldDesc(className, fieldName, ""));
        }
    }

    @Override
    public boolean isClassFieldUsed(String className, String fieldName) {
        for (MethodOrFieldDesc m : this.usedClassFields) {
            if (!m.getName().equals(fieldName) || !m.getSignature().equals("") || !m.getClassName().equals(className)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isClassUsed(String className) {
        return this.usedClasses.contains(className);
    }

    @Override
    public void registerLockingTypes(ArrayList<String> types) {
        for (String type : types) {
            if (this.lockingTypes.contains(type)) continue;
            this.lockingTypes.add(type);
        }
    }

    @Override
    public boolean isLockingType(String className) {
        while (!"java.lang.Object".equals(className)) {
            if (this.lockingTypes.contains(className)) {
                return true;
            }
            className = ClassfileUtils.getSuperClassName(className);
        }
        return false;
    }

    @Override
    public void registerLockingType(String type) {
        this.lockingTypes.add(type);
    }

    @Override
    public void byteCodeUsed(byte opCode) {
        int index = opCode & 0xFF;
        this.usedByteCodes[index] = true;
    }

    @Override
    public boolean isBytecodeUsed(int i) {
        return this.usedByteCodes[i];
    }

    protected String getNativeFieldKey(String containingClass, FieldInfo field) {
        StringBuffer key = new StringBuffer();
        key.append(containingClass);
        key.append(field.getName());
        return key.toString();
    }

    @Override
    public void registerNativeField(String containingClass, FieldInfo field, IcecapCVar cvar) {
        String key = this.getNativeFieldKey(containingClass, field);
        this.nativeFields.put(key.toString(), new NativeFieldInfo(field, cvar));
    }

    @Override
    public void registerCFunc(String className, String methodName, String methodSignature, IcecapCFunc cfunc) {
        String key = String.valueOf(className) + methodName + methodSignature;
        if (!this.cFunctions.containsKey(key)) {
            this.cFunctions.put(key, new CFuncInfo(new MethodOrFieldDesc(className, methodName, methodSignature), cfunc));
        }
    }

    @Override
    public CFuncInfo isCFunc(String className, String methodName, String methodSignature) {
        String key = String.valueOf(className) + methodName + methodSignature;
        return this.cFunctions.get(key);
    }

    @Override
    public IcecapIterator<CFuncInfo> getCFunctions() throws Exception {
        Iterator<String> usedClasses = this.getUsedClasses();
        while (usedClasses.hasNext()) {
            String currentClassName = usedClasses.next();
            JavaClass clss = Repository.lookupClass((String)currentClassName);
            Method[] methods = clss.getMethods();
            if (methods == null) continue;
            Method[] methodArray = methods;
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                Attribute[] attributes;
                Method method = methodArray[n2];
                Attribute[] attributeArray = attributes = method.getAttributes();
                int n3 = attributes.length;
                int n4 = 0;
                while (n4 < n3) {
                    AnnotationsAttribute icecapAttribute;
                    Attribute current = attributeArray[n4];
                    IcecapCFunc cfunc = null;
                    if (current instanceof AnnotationsAttribute) {
                        icecapAttribute = (AnnotationsAttribute)current;
                        cfunc = (IcecapCFunc)icecapAttribute.getAnnotation(IcecapCFunc.class);
                    } else if (current instanceof RuntimeInvisibleAnnotations) {
                        icecapAttribute = AnnotationsAttribute.getAttribute((RuntimeInvisibleAnnotations)((RuntimeInvisibleAnnotations)current));
                        cfunc = (IcecapCFunc)icecapAttribute.getAnnotation(IcecapCFunc.class);
                    }
                    if (cfunc != null) {
                        this.registerCFunc(currentClassName, method.getName(), method.getSignature(), cfunc);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return new CFunctionIterator(this.cFunctions);
    }

    @Override
    public NativeFieldInfo isNativeField(String containingClass, FieldInfo field) {
        String key = this.getNativeFieldKey(containingClass, field);
        return this.nativeFields.get(key);
    }

    @Override
    public void classInitializerUsed(String className) {
        if (!this.classInitializationSequence.contains(className)) {
            this.classInitializationSequence.add(className);
        }
    }

    @Override
    public Iterator<String> getUsedClassInitializers() {
        return this.classInitializationSequence.iterator();
    }

    @Override
    public IcecapIterator<MethodOrFieldDesc> getUsedMethods(String nextClass) {
        return this.usedMethods.getMethods(nextClass);
    }

    @Override
    public void reportVtableSize(int s) {
        if (this.maxVTableSize < s) {
            this.maxVTableSize = s;
        }
    }

    @Override
    public int getMaxVtableSize() {
        return this.maxVTableSize;
    }

    public int numberOfUsedClasses() {
        return this.usedClasses.size();
    }

    public int numberOfUsedMethods() {
        return this.usedMethodDescriptors.size();
    }

    private static class CFunctionIterator
    implements IcecapIterator<CFuncInfo> {
        private Iterator<Map.Entry<String, CFuncInfo>> cFunctions;

        public CFunctionIterator(HashMap<String, CFuncInfo> cFunctions) {
            this.cFunctions = cFunctions.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.cFunctions.hasNext();
        }

        @Override
        public CFuncInfo next() {
            Map.Entry<String, CFuncInfo> next = this.cFunctions.next();
            return next.getValue();
        }
    }
}

