/*
 * Decompiled with CFR 0.152.
 */
package icecaptools;

import icecaptools.ByteCodeStream;
import icecaptools.ByteCollector;
import icecaptools.IcecapIterator;
import java.util.ArrayList;
import java.util.StringTokenizer;

public abstract class RawByteCodes {
    public static final int REF_getField = 1;
    public static final int REF_getStatic = 2;
    public static final int REF_putField = 3;
    public static final int REF_putStatic = 4;
    public static final int REF_invokeVirtual = 5;
    public static final int REF_invokeStatic = 6;
    public static final int REF_invokeSpecial = 7;
    public static final int REF_newInvokeSpecial = 8;
    public static final int REF_invokeInterface = 9;
    public static final byte nop_opcode = 0;
    public static final byte aconst_null_opcode = 1;
    public static final byte iconst_m1_opcode = 2;
    public static final byte iconst_0_opcode = 3;
    public static final byte iconst_1_opcode = 4;
    public static final byte iconst_2_opcode = 5;
    public static final byte iconst_3_opcode = 6;
    public static final byte iconst_4_opcode = 7;
    public static final byte iconst_5_opcode = 8;
    public static final byte lconst_0_opcode = 9;
    public static final byte lconst_1_opcode = 10;
    public static final byte fconst_0_opcode = 11;
    public static final byte fconst_1_opcode = 12;
    public static final byte fconst_2_opcode = 13;
    public static final byte dconst_0_opcode = 14;
    public static final byte dconst_1_opcode = 15;
    public static final byte bipush_opcode = 16;
    public static final byte sipush_opcode = 17;
    public static final byte ldc_opcode = 18;
    public static final byte ldc_w_opcode = 19;
    public static final byte ldc2_w_opcode = 20;
    public static final byte iload_opcode = 21;
    public static final byte lload_opcode = 22;
    public static final byte fload_opcode = 23;
    public static final byte dload_opcode = 24;
    public static final byte aload_opcode = 25;
    public static final byte iload_0_opcode = 26;
    public static final byte iload_1_opcode = 27;
    public static final byte iload_2_opcode = 28;
    public static final byte iload_3_opcode = 29;
    public static final byte lload_0_opcode = 30;
    public static final byte lload_1_opcode = 31;
    public static final byte lload_2_opcode = 32;
    public static final byte lload_3_opcode = 33;
    public static final byte fload_0_opcode = 34;
    public static final byte fload_1_opcode = 35;
    public static final byte fload_2_opcode = 36;
    public static final byte fload_3_opcode = 37;
    public static final byte dload_0_opcode = 38;
    public static final byte dload_1_opcode = 39;
    public static final byte dload_2_opcode = 40;
    public static final byte dload_3_opcode = 41;
    public static final byte aload_0_opcode = 42;
    public static final byte aload_1_opcode = 43;
    public static final byte aload_2_opcode = 44;
    public static final byte aload_3_opcode = 45;
    public static final byte iaload_opcode = 46;
    public static final byte laload_opcode = 47;
    public static final byte faload_opcode = 48;
    public static final byte daload_opcode = 49;
    public static final byte aaload_opcode = 50;
    public static final byte baload_opcode = 51;
    public static final byte caload_opcode = 52;
    public static final byte saload_opcode = 53;
    public static final byte istore_opcode = 54;
    public static final byte lstore_opcode = 55;
    public static final byte fstore_opcode = 56;
    public static final byte dstore_opcode = 57;
    public static final byte astore_opcode = 58;
    public static final byte istore_0_opcode = 59;
    public static final byte istore_1_opcode = 60;
    public static final byte istore_2_opcode = 61;
    public static final byte istore_3_opcode = 62;
    public static final byte lstore_0_opcode = 63;
    public static final byte lstore_1_opcode = 64;
    public static final byte lstore_2_opcode = 65;
    public static final byte lstore_3_opcode = 66;
    public static final byte fstore_0_opcode = 67;
    public static final byte fstore_1_opcode = 68;
    public static final byte fstore_2_opcode = 69;
    public static final byte fstore_3_opcode = 70;
    public static final byte dstore_0_opcode = 71;
    public static final byte dstore_1_opcode = 72;
    public static final byte dstore_2_opcode = 73;
    public static final byte dstore_3_opcode = 74;
    public static final byte astore_0_opcode = 75;
    public static final byte astore_1_opcode = 76;
    public static final byte astore_2_opcode = 77;
    public static final byte astore_3_opcode = 78;
    public static final byte iastore_opcode = 79;
    public static final byte lastore_opcode = 80;
    public static final byte fastore_opcode = 81;
    public static final byte dastore_opcode = 82;
    public static final byte aastore_opcode = 83;
    public static final byte bastore_opcode = 84;
    public static final byte castore_opcode = 85;
    public static final byte sastore_opcode = 86;
    public static final byte pop_opcode = 87;
    public static final byte pop2_opcode = 88;
    public static final byte dup_opcode = 89;
    public static final byte dup_x1_opcode = 90;
    public static final byte dup_x2_opcode = 91;
    public static final byte dup2_opcode = 92;
    public static final byte dup2_x1_opcode = 93;
    public static final byte dup2_x2_opcode = 94;
    public static final byte swap_opcode = 95;
    public static final byte iadd_opcode = 96;
    public static final byte ladd_opcode = 97;
    public static final byte fadd_opcode = 98;
    public static final byte dadd_opcode = 99;
    public static final byte isub_opcode = 100;
    public static final byte lsub_opcode = 101;
    public static final byte fsub_opcode = 102;
    public static final byte dsub_opcode = 103;
    public static final byte imul_opcode = 104;
    public static final byte lmul_opcode = 105;
    public static final byte fmul_opcode = 106;
    public static final byte dmul_opcode = 107;
    public static final byte idiv_opcode = 108;
    public static final byte ldiv_opcode = 109;
    public static final byte fdiv_opcode = 110;
    public static final byte ddiv_opcode = 111;
    public static final byte irem_opcode = 112;
    public static final byte lrem_opcode = 113;
    public static final byte frem_opcode = 114;
    public static final byte drem_opcode = 115;
    public static final byte ineg_opcode = 116;
    public static final byte lneg_opcode = 117;
    public static final byte fneg_opcode = 118;
    public static final byte dneg_opcode = 119;
    public static final byte ishl_opcode = 120;
    public static final byte lshl_opcode = 121;
    public static final byte ishr_opcode = 122;
    public static final byte lshr_opcode = 123;
    public static final byte iushr_opcode = 124;
    public static final byte lushr_opcode = 125;
    public static final byte iand_opcode = 126;
    public static final byte land_opcode = 127;
    public static final byte ior_opcode = -128;
    public static final byte lor_opcode = -127;
    public static final byte ixor_opcode = -126;
    public static final byte lxor_opcode = -125;
    public static final byte iinc_opcode = -124;
    public static final byte i2l_opcode = -123;
    public static final byte i2f_opcode = -122;
    public static final byte i2d_opcode = -121;
    public static final byte l2i_opcode = -120;
    public static final byte l2f_opcode = -119;
    public static final byte l2d_opcode = -118;
    public static final byte f2i_opcode = -117;
    public static final byte f2l_opcode = -116;
    public static final byte f2d_opcode = -115;
    public static final byte d2i_opcode = -114;
    public static final byte d2l_opcode = -113;
    public static final byte d2f_opcode = -112;
    public static final byte i2b_opcode = -111;
    public static final byte i2c_opcode = -110;
    public static final byte i2s_opcode = -109;
    public static final byte lcmp_opcode = -108;
    public static final byte fcmpl_opcode = -107;
    public static final byte fcmpg_opcode = -106;
    public static final byte dcmpl_opcode = -105;
    public static final byte dcmpg_opcode = -104;
    public static final byte ifeq_opcode = -103;
    public static final byte ifne_opcode = -102;
    public static final byte iflt_opcode = -101;
    public static final byte ifge_opcode = -100;
    public static final byte ifgt_opcode = -99;
    public static final byte ifle_opcode = -98;
    public static final byte if_icmpeq_opcode = -97;
    public static final byte if_icmpne_opcode = -96;
    public static final byte if_icmplt_opcode = -95;
    public static final byte if_icmpge_opcode = -94;
    public static final byte if_icmpgt_opcode = -93;
    public static final byte if_icmple_opcode = -92;
    public static final byte if_acmpeq_opcode = -91;
    public static final byte if_acmpne_opcode = -90;
    public static final byte goto_opcode = -89;
    public static final byte jsr_opcode = -88;
    public static final byte ret_opcode = -87;
    public static final byte tableswitch_opcode = -86;
    public static final byte lookupswitch_opcode = -85;
    public static final byte ireturn_opcode = -84;
    public static final byte lreturn_opcode = -83;
    public static final byte freturn_opcode = -82;
    public static final byte dreturn_opcode = -81;
    public static final byte areturn_opcode = -80;
    public static final byte return_opcode = -79;
    public static final byte getstatic_opcode = -78;
    public static final byte putstatic_opcode = -77;
    public static final byte getfield_opcode = -76;
    public static final byte putfield_opcode = -75;
    public static final byte invokevirtual_opcode = -74;
    public static final byte invokespecial_opcode = -73;
    public static final byte invokestatic_opcode = -72;
    public static final byte invokeinterface_opcode = -71;
    public static final byte invokedynamic_opcode = -70;
    public static final byte new_opcode = -69;
    public static final byte newarray_opcode = -68;
    public static final byte anewarray_opcode = -67;
    public static final byte arraylength_opcode = -66;
    public static final byte athrow_opcode = -65;
    public static final byte checkcast_opcode = -64;
    public static final byte instanceof_opcode = -63;
    public static final byte monitorenter_opcode = -62;
    public static final byte monitorexit_opcode = -61;
    public static final byte wide_opcode = -60;
    public static final byte multianewarray_opcode = -59;
    public static final byte ifnull_opcode = -58;
    public static final byte ifnonnull_opcode = -57;
    public static final byte goto_w_opcode = -56;
    public static final byte jsr_w_opcode = -55;
    public static final byte invoke_clone_onarray = -54;
    public static final byte gethwfield_opcode = -53;
    public static final byte puthwfield_opcode = -52;
    public static final byte newflasharray_opcode = -51;

    public static class RawByteCpIndexOperation
    extends RawBytecode {
        public int cpIndex;

        @Override
        protected void continueReading(ByteCodeStream input) {
            this.cpIndex = input.get();
        }
    }

    public static class RawByteLocalVariableOperation
    extends RawBytecode {
        public int localVariableIndex;

        @Override
        protected void continueReading(ByteCodeStream input) {
            this.localVariableIndex = input.get();
        }
    }

    public static class RawByteOperation
    extends RawBytecode {
        int byte1;

        @Override
        protected void continueReading(ByteCodeStream input) {
            this.byte1 = input.get();
        }
    }

    public static class RawBytecode
    implements ByteCollector {
        private int opcode;
        private int size;
        private int address;
        private ArrayList<Byte> bytes = new ArrayList();

        protected void continueReading(ByteCodeStream input) {
        }

        public void read(int opcode, ByteCodeStream input) {
            this.opcode = opcode;
            this.bytes.add(new Byte((byte)opcode));
            this.address = (int)(input.pos() - 1L);
            int start = (int)input.pos();
            input.setByteCollector(this);
            this.continueReading(input);
            int stop = (int)input.pos();
            this.size = stop - start + 1;
        }

        public int getOpcode() {
            return this.opcode;
        }

        public int getSize() {
            return this.size;
        }

        public int getAddress() {
            return this.address;
        }

        public static int bitLeftShift(long value, int shift) {
            return (int)(value << shift);
        }

        public static int bitwiseOr(long value1, long value2) {
            return (int)(value1 | value2);
        }

        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("");
        }

        @Override
        public void collect(byte c) {
            this.bytes.add(new Byte(c));
        }

        public byte[] getRawBytes() {
            byte[] bytes = new byte[this.bytes.size()];
            int i = 0;
            while (i < bytes.length) {
                bytes[i] = this.bytes.get(i);
                ++i;
            }
            return bytes;
        }
    }

    public static class RawConstantByteLocalVariableOperation
    extends RawByteLocalVariableOperation {
        int constant;

        @Override
        protected void continueReading(ByteCodeStream input) {
            super.continueReading(input);
            this.constant = input.get();
        }
    }

    public static class RawCountCpIndexOperation
    extends RawCpIndexOperation {
        public int count;

        @Override
        protected void continueReading(ByteCodeStream input) {
            super.continueReading(input);
            this.count = input.get();
            input.get();
        }
    }

    public static class RawCpIndexOperation
    extends RawByteCpIndexOperation {
        @Override
        protected void continueReading(ByteCodeStream input) {
            super.continueReading(input);
            this.cpIndex = RawCpIndexOperation.bitwiseOr(RawCpIndexOperation.bitLeftShift(this.cpIndex & 0xFF, 8), input.get() & 0xFF);
        }
    }

    public static class RawReturnOperation
    extends RawBytecode {
    }

    public static class RawShortBranchOperation
    extends RawBytecode {
        public long branchoffset;

        @Override
        protected void continueReading(ByteCodeStream input) {
            int byte1 = input.get();
            int byte2 = input.get();
            short offset = (short)RawShortBranchOperation.bitwiseOr(RawShortBranchOperation.bitLeftShift(byte1 & 0xFF, 8), byte2 & 0xFF);
            this.branchoffset = offset;
        }
    }

    public static class RawShortLocalVariableOperation
    extends RawByteLocalVariableOperation {
        @Override
        protected void continueReading(ByteCodeStream input) {
            super.continueReading(input);
            this.localVariableIndex = RawShortLocalVariableOperation.bitwiseOr(RawShortLocalVariableOperation.bitLeftShift(this.localVariableIndex & 0xFF, 8), input.get() & 0xFF);
        }
    }

    public static class RawShortOperation
    extends RawByteOperation {
        short shortVal;

        @Override
        protected void continueReading(ByteCodeStream input) {
            super.continueReading(input);
            this.shortVal = (short)RawShortOperation.bitwiseOr(RawShortOperation.bitLeftShift(this.byte1 & 0xFF, 8), input.get() & 0xFF);
        }
    }

    public static class RawSwitch
    extends RawBytecode {
        public long defaultVal;

        protected long getLong(ByteCodeStream input) {
            int byte1 = input.get();
            int byte2 = input.get();
            int byte3 = input.get();
            int byte4 = input.get();
            long result = byte4 & 0xFF;
            result = RawSwitch.bitwiseOr(RawSwitch.bitLeftShift(byte3 & 0xFF, 8), result);
            result = RawSwitch.bitwiseOr(RawSwitch.bitLeftShift(byte2 & 0xFF, 16), result & 0xFFFFL);
            result = RawSwitch.bitwiseOr(RawSwitch.bitLeftShift(byte1 & 0xFF, 24), result & 0xFFFFFFL);
            return result;
        }

        @Override
        protected void continueReading(ByteCodeStream input) {
            while (input.pos() % 4L != 0L) {
                input.get();
            }
            this.defaultVal = this.getLong(input);
        }
    }

    public static class RawTypeOperation
    extends RawBytecode {
        public int type;

        @Override
        protected void continueReading(ByteCodeStream input) {
            this.type = input.get();
        }
    }

    public static class RawWideBranchOperation
    extends RawShortBranchOperation {
        @Override
        protected void continueReading(ByteCodeStream input) {
            super.continueReading(input);
            int byte1 = input.get();
            int byte2 = input.get();
            short low = (short)RawWideBranchOperation.bitwiseOr(RawWideBranchOperation.bitLeftShift(byte1 & 0xFF, 8), byte2 & 0xFF);
            this.branchoffset = RawWideBranchOperation.bitwiseOr(RawWideBranchOperation.bitLeftShift(this.branchoffset, 16), low & 0xFFFF);
        }
    }

    public static class Raw_aaload
    extends RawBytecode {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.NullPointerException;java.lang.ArrayIndexOutOfBoundsException");
        }
    }

    public static class Raw_aastore
    extends RawBytecode {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.NullPointerException;java.lang.ArrayIndexOutOfBoundsException;java.lang.ArrayStoreException");
        }
    }

    public static class Raw_aconst_null
    extends RawBytecode {
    }

    public static class Raw_aload
    extends RawByteLocalVariableOperation {
    }

    public static class Raw_aload_0
    extends RawBytecode {
    }

    public static class Raw_aload_1
    extends RawBytecode {
    }

    public static class Raw_aload_2
    extends RawBytecode {
    }

    public static class Raw_aload_3
    extends RawBytecode {
    }

    public static class Raw_anewarray
    extends RawCpIndexOperation {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.NegativeArraySizeException;java.lang.OutOfMemoryError");
        }
    }

    public static class Raw_areturn
    extends RawReturnOperation {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.IllegalMonitorStateException");
        }
    }

    public static class Raw_arraylength
    extends RawBytecode {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.NullPointerException");
        }
    }

    public static class Raw_astore
    extends RawByteLocalVariableOperation {
    }

    public static class Raw_astore_0
    extends RawBytecode {
    }

    public static class Raw_astore_1
    extends RawBytecode {
    }

    public static class Raw_astore_2
    extends RawBytecode {
    }

    public static class Raw_astore_3
    extends RawBytecode {
    }

    public static class Raw_athrow
    extends RawBytecode {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.NullPointerException");
        }
    }

    public static class Raw_baload
    extends RawBytecode {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.NullPointerException;java.lang.ArrayIndexOutOfBoundsException");
        }
    }

    public static class Raw_bastore
    extends RawBytecode {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.NullPointerException;java.lang.ArrayIndexOutOfBoundsException");
        }
    }

    public static class Raw_bipush
    extends RawByteOperation {
    }

    public static class Raw_caload
    extends RawBytecode {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.NullPointerException;java.lang.ArrayIndexOutOfBoundsException");
        }
    }

    public static class Raw_castore
    extends RawBytecode {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.NullPointerException;java.lang.ArrayIndexOutOfBoundsException");
        }
    }

    public static class Raw_checkcast
    extends RawCpIndexOperation {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.ClassCastException");
        }
    }

    public static class Raw_d2f
    extends RawBytecode {
    }

    public static class Raw_d2i
    extends RawBytecode {
    }

    public static class Raw_d2l
    extends RawBytecode {
    }

    public static class Raw_dadd
    extends RawBytecode {
    }

    public static class Raw_daload
    extends RawBytecode {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.NullPointerException");
        }
    }

    public static class Raw_dastore
    extends RawBytecode {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.NullPointerException;java.lang.ArrayIndexOutOfBoundsException");
        }
    }

    public static class Raw_dcmpg
    extends RawBytecode {
    }

    public static class Raw_dcmpl
    extends RawBytecode {
    }

    public static class Raw_dconst
    extends RawBytecode {
        public long constValue;
    }

    public static class Raw_dconst_0
    extends Raw_dconst {
        @Override
        protected void continueReading(ByteCodeStream input) {
            this.constValue = 0L;
        }
    }

    public static class Raw_dconst_1
    extends Raw_dconst {
        @Override
        protected void continueReading(ByteCodeStream input) {
            this.constValue = 1L;
        }
    }

    public static class Raw_ddiv
    extends RawBytecode {
    }

    public static class Raw_dload
    extends RawByteLocalVariableOperation {
    }

    public static class Raw_dload_0
    extends RawBytecode {
    }

    public static class Raw_dload_1
    extends RawBytecode {
    }

    public static class Raw_dload_2
    extends RawBytecode {
    }

    public static class Raw_dload_3
    extends RawBytecode {
    }

    public static class Raw_dmul
    extends RawBytecode {
    }

    public static class Raw_dneg
    extends RawBytecode {
    }

    public static class Raw_drem
    extends RawBytecode {
    }

    public static class Raw_dreturn
    extends RawReturnOperation {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.IllegalMonitorStateException");
        }
    }

    public static class Raw_dstore
    extends RawByteLocalVariableOperation {
    }

    public static class Raw_dstore_0
    extends RawBytecode {
    }

    public static class Raw_dstore_1
    extends RawBytecode {
    }

    public static class Raw_dstore_2
    extends RawBytecode {
    }

    public static class Raw_dstore_3
    extends RawBytecode {
    }

    public static class Raw_dsub
    extends RawBytecode {
    }

    public static class Raw_dup
    extends RawBytecode {
    }

    public static class Raw_dup2
    extends RawBytecode {
    }

    public static class Raw_dup2_x1
    extends RawBytecode {
    }

    public static class Raw_dup2_x2
    extends RawBytecode {
    }

    public static class Raw_dup_x1
    extends RawBytecode {
    }

    public static class Raw_dup_x2
    extends RawBytecode {
    }

    public static class Raw_f2d
    extends RawBytecode {
    }

    public static class Raw_f2i
    extends RawBytecode {
    }

    public static class Raw_f2l
    extends RawBytecode {
    }

    public static class Raw_fadd
    extends RawBytecode {
    }

    public static class Raw_faload
    extends RawBytecode {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.NullPointerException;java.lang.ArrayIndexOutOfBoundsException");
        }
    }

    public static class Raw_fastore
    extends RawBytecode {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.NullPointerException;java.lang.ArrayIndexOutOfBoundsException");
        }
    }

    public static class Raw_fcmpg
    extends RawBytecode {
    }

    public static class Raw_fcmpl
    extends RawBytecode {
    }

    public static class Raw_fconst
    extends RawBytecode {
        public long constValue;
    }

    public static class Raw_fconst_0
    extends Raw_fconst {
        @Override
        protected void continueReading(ByteCodeStream input) {
            this.constValue = 0L;
        }
    }

    public static class Raw_fconst_1
    extends Raw_fconst {
        @Override
        protected void continueReading(ByteCodeStream input) {
            this.constValue = 1L;
        }
    }

    public static class Raw_fconst_2
    extends Raw_fconst {
        @Override
        protected void continueReading(ByteCodeStream input) {
            this.constValue = 2L;
        }
    }

    public static class Raw_fdiv
    extends RawBytecode {
    }

    public static class Raw_fload
    extends RawByteLocalVariableOperation {
    }

    public static class Raw_fload_0
    extends RawBytecode {
    }

    public static class Raw_fload_1
    extends RawBytecode {
    }

    public static class Raw_fload_2
    extends RawBytecode {
    }

    public static class Raw_fload_3
    extends RawBytecode {
    }

    public static class Raw_fmul
    extends RawBytecode {
    }

    public static class Raw_fneg
    extends RawBytecode {
    }

    public static class Raw_frem
    extends RawBytecode {
    }

    public static class Raw_freturn
    extends RawReturnOperation {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.IllegalMonitorStateException");
        }
    }

    public static class Raw_fstore
    extends RawByteLocalVariableOperation {
    }

    public static class Raw_fstore_0
    extends RawBytecode {
    }

    public static class Raw_fstore_1
    extends RawBytecode {
    }

    public static class Raw_fstore_2
    extends RawBytecode {
    }

    public static class Raw_fstore_3
    extends RawBytecode {
    }

    public static class Raw_fsub
    extends RawBytecode {
    }

    public static class Raw_getfield
    extends RawCpIndexOperation {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.NullPointerException");
        }
    }

    public static class Raw_getstatic
    extends RawCpIndexOperation {
    }

    public static class Raw_goto
    extends RawShortBranchOperation {
    }

    public static class Raw_goto_w
    extends RawWideBranchOperation {
    }

    public static class Raw_i2b
    extends RawBytecode {
    }

    public static class Raw_i2c
    extends RawBytecode {
    }

    public static class Raw_i2d
    extends RawBytecode {
    }

    public static class Raw_i2f
    extends RawBytecode {
    }

    public static class Raw_i2l
    extends RawBytecode {
    }

    public static class Raw_i2s
    extends RawBytecode {
    }

    public static class Raw_iadd
    extends RawBytecode {
    }

    public static class Raw_iaload
    extends RawBytecode {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.NullPointerException;java.lang.ArrayIndexOutOfBoundsException");
        }
    }

    public static class Raw_iand
    extends RawBytecode {
    }

    public static class Raw_iastore
    extends RawBytecode {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.NullPointerException;java.lang.ArrayIndexOutOfBoundsException");
        }
    }

    public static class Raw_iconst
    extends RawBytecode {
        public long constValue;
    }

    public static class Raw_iconst_0
    extends Raw_iconst {
        @Override
        protected void continueReading(ByteCodeStream input) {
            this.constValue = 0L;
        }
    }

    public static class Raw_iconst_1
    extends Raw_iconst {
        @Override
        protected void continueReading(ByteCodeStream input) {
            this.constValue = 1L;
        }
    }

    public static class Raw_iconst_2
    extends Raw_iconst {
        @Override
        protected void continueReading(ByteCodeStream input) {
            this.constValue = 2L;
        }
    }

    public static class Raw_iconst_3
    extends Raw_iconst {
        @Override
        protected void continueReading(ByteCodeStream input) {
            this.constValue = 3L;
        }
    }

    public static class Raw_iconst_4
    extends Raw_iconst {
        @Override
        protected void continueReading(ByteCodeStream input) {
            this.constValue = 4L;
        }
    }

    public static class Raw_iconst_5
    extends Raw_iconst {
        @Override
        protected void continueReading(ByteCodeStream input) {
            this.constValue = 5L;
        }
    }

    public static class Raw_iconst_m1
    extends Raw_iconst {
        @Override
        protected void continueReading(ByteCodeStream input) {
            this.constValue = -1L;
        }
    }

    public static class Raw_idiv
    extends RawBytecode {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.ArithmeticException");
        }
    }

    public static class Raw_if_acmpeq
    extends RawShortBranchOperation {
    }

    public static class Raw_if_acmpne
    extends RawShortBranchOperation {
    }

    public static class Raw_if_icmpeq
    extends RawShortBranchOperation {
    }

    public static class Raw_if_icmpge
    extends RawShortBranchOperation {
    }

    public static class Raw_if_icmpgt
    extends RawShortBranchOperation {
    }

    public static class Raw_if_icmple
    extends RawShortBranchOperation {
    }

    public static class Raw_if_icmplt
    extends RawShortBranchOperation {
    }

    public static class Raw_if_icmpne
    extends RawShortBranchOperation {
    }

    public static class Raw_ifeq
    extends RawShortBranchOperation {
    }

    public static class Raw_ifge
    extends RawShortBranchOperation {
    }

    public static class Raw_ifgt
    extends RawShortBranchOperation {
    }

    public static class Raw_ifle
    extends RawShortBranchOperation {
    }

    public static class Raw_iflt
    extends RawShortBranchOperation {
    }

    public static class Raw_ifne
    extends RawShortBranchOperation {
    }

    public static class Raw_ifnonnull
    extends RawShortBranchOperation {
    }

    public static class Raw_ifnull
    extends RawShortBranchOperation {
    }

    public static class Raw_iinc
    extends RawConstantByteLocalVariableOperation {
    }

    public static class Raw_iload
    extends RawByteLocalVariableOperation {
    }

    public static class Raw_iload_0
    extends RawBytecode {
    }

    public static class Raw_iload_1
    extends RawBytecode {
    }

    public static class Raw_iload_2
    extends RawBytecode {
    }

    public static class Raw_iload_3
    extends RawBytecode {
    }

    public static class Raw_imul
    extends RawBytecode {
    }

    public static class Raw_ineg
    extends RawBytecode {
    }

    public static class Raw_instanceof
    extends RawCpIndexOperation {
    }

    public static class Raw_invokedynamic
    extends RawCpIndexOperation {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.NullPointerException");
        }
    }

    public static class Raw_invokeinterface
    extends RawCountCpIndexOperation {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.NullPointerException");
        }
    }

    public static class Raw_invokespecial
    extends RawCpIndexOperation {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.NullPointerException");
        }
    }

    public static class Raw_invokestatic
    extends RawCpIndexOperation {
    }

    public static class Raw_invokevirtual
    extends RawCpIndexOperation {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.NullPointerException");
        }
    }

    public static class Raw_ior
    extends RawBytecode {
    }

    public static class Raw_irem
    extends RawBytecode {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.ArithmeticException");
        }
    }

    public static class Raw_ireturn
    extends RawReturnOperation {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.IllegalMonitorStateException");
        }
    }

    public static class Raw_ishl
    extends RawBytecode {
    }

    public static class Raw_ishr
    extends RawBytecode {
    }

    public static class Raw_istore
    extends RawByteLocalVariableOperation {
    }

    public static class Raw_istore_0
    extends RawBytecode {
    }

    public static class Raw_istore_1
    extends RawBytecode {
    }

    public static class Raw_istore_2
    extends RawBytecode {
    }

    public static class Raw_istore_3
    extends RawBytecode {
    }

    public static class Raw_isub
    extends RawBytecode {
    }

    public static class Raw_iushr
    extends RawBytecode {
    }

    public static class Raw_ixor
    extends RawBytecode {
    }

    public static class Raw_jsr
    extends RawShortBranchOperation {
    }

    public static class Raw_jsr_w
    extends RawWideBranchOperation {
    }

    public static class Raw_l2d
    extends RawBytecode {
    }

    public static class Raw_l2f
    extends RawBytecode {
    }

    public static class Raw_l2i
    extends RawBytecode {
    }

    public static class Raw_ladd
    extends RawBytecode {
    }

    public static class Raw_laload
    extends RawBytecode {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.NullPointerException;java.lang.ArrayIndexOutOfBoundsException");
        }
    }

    public static class Raw_land
    extends RawBytecode {
    }

    public static class Raw_lastore
    extends RawBytecode {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.NullPointerException;java.lang.ArrayIndexOutOfBoundsException");
        }
    }

    public static class Raw_lcmp
    extends RawBytecode {
    }

    public static class Raw_lconst
    extends RawBytecode {
        public long constVal;
    }

    public static class Raw_lconst_0
    extends Raw_lconst {
        @Override
        protected void continueReading(ByteCodeStream input) {
            this.constVal = 0L;
        }
    }

    public static class Raw_lconst_1
    extends Raw_lconst {
        @Override
        protected void continueReading(ByteCodeStream input) {
            this.constVal = 1L;
        }
    }

    public static class Raw_ldc
    extends RawByteCpIndexOperation {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.OutOfMemoryError");
        }
    }

    public static class Raw_ldc2_w
    extends RawCpIndexOperation {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.OutOfMemoryError");
        }
    }

    public static class Raw_ldc_w
    extends RawCpIndexOperation {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.OutOfMemoryError");
        }
    }

    public static class Raw_ldiv
    extends RawBytecode {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.ArithmeticException");
        }
    }

    public static class Raw_lload
    extends RawByteLocalVariableOperation {
    }

    public static class Raw_lload_0
    extends RawBytecode {
    }

    public static class Raw_lload_1
    extends RawBytecode {
    }

    public static class Raw_lload_2
    extends RawBytecode {
    }

    public static class Raw_lload_3
    extends RawBytecode {
    }

    public static class Raw_lmul
    extends RawBytecode {
    }

    public static class Raw_lneg
    extends RawBytecode {
    }

    public static class Raw_lookupswitch
    extends RawSwitch {
        public long npairs;
        public Pair[] pairs;

        @Override
        protected void continueReading(ByteCodeStream input) {
            super.continueReading(input);
            this.npairs = this.getLong(input);
            this.pairs = new Pair[(int)this.npairs];
            int count = 0;
            while ((long)count < this.npairs) {
                this.pairs[count] = new Pair((int)this.getLong(input), (int)this.getLong(input));
                ++count;
            }
        }

        public class Pair {
            public int match;
            public int offset;

            public Pair(int match, int offset) {
                this.match = match;
                this.offset = offset;
            }
        }
    }

    public static class Raw_lor
    extends RawBytecode {
    }

    public static class Raw_lrem
    extends RawBytecode {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.ArithmeticException");
        }
    }

    public static class Raw_lreturn
    extends RawReturnOperation {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.IllegalMonitorStateException");
        }
    }

    public static class Raw_lshl
    extends RawBytecode {
    }

    public static class Raw_lshr
    extends RawBytecode {
    }

    public static class Raw_lstore
    extends RawByteLocalVariableOperation {
    }

    public static class Raw_lstore_0
    extends RawBytecode {
    }

    public static class Raw_lstore_1
    extends RawBytecode {
    }

    public static class Raw_lstore_2
    extends RawBytecode {
    }

    public static class Raw_lstore_3
    extends RawBytecode {
    }

    public static class Raw_lsub
    extends RawBytecode {
    }

    public static class Raw_lushr
    extends RawBytecode {
    }

    public static class Raw_lxor
    extends RawBytecode {
    }

    public static class Raw_methodEntryByteCode
    extends RawBytecode {
    }

    public static class Raw_monitorenter
    extends RawBytecode {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.NullPointerException");
        }
    }

    public static class Raw_monitorexit
    extends RawBytecode {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.NullPointerException;java.lang.IllegalMonitorStateException");
        }
    }

    public static class Raw_multianewarray
    extends RawCpIndexOperation {
        public int count;

        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.NegativeArraySizeException;java.lang.OutOfMemoryError");
        }

        @Override
        protected void continueReading(ByteCodeStream input) {
            super.continueReading(input);
            this.count = input.get();
        }
    }

    public static class Raw_new
    extends RawCpIndexOperation {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.OutOfMemoryError");
        }
    }

    public static class Raw_newArray
    extends RawTypeOperation {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.NegativeArraySizeException;java.lang.OutOfMemoryError");
        }
    }

    public static class Raw_nop
    extends RawBytecode {
    }

    public static class Raw_pop
    extends RawBytecode {
    }

    public static class Raw_pop2
    extends RawBytecode {
    }

    public static class Raw_putfield
    extends RawCpIndexOperation {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.NullPointerException");
        }
    }

    public static class Raw_putstatic
    extends RawCpIndexOperation {
    }

    public static class Raw_ret
    extends RawByteLocalVariableOperation {
    }

    public static class Raw_return
    extends RawReturnOperation {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.IllegalMonitorStateException");
        }
    }

    public static class Raw_saload
    extends RawBytecode {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.NullPointerException;java.lang.ArrayIndexOutOfBoundsException");
        }
    }

    public static class Raw_sastore
    extends RawBytecode {
        @Override
        public IcecapIterator<String> exceptionsThrown() {
            return new StringIterator("java.lang.NullPointerException;java.lang.ArrayIndexOutOfBoundsException");
        }
    }

    public static class Raw_sipush
    extends RawShortOperation {
    }

    public static class Raw_swap
    extends RawBytecode {
    }

    public static class Raw_tableswitch
    extends RawSwitch {
        long low;
        long high;
        public long[] offsets;

        public long getLow() {
            return this.low;
        }

        public long getHigh() {
            return this.high;
        }

        @Override
        protected void continueReading(ByteCodeStream input) {
            super.continueReading(input);
            this.low = this.getLong(input);
            this.high = this.getLong(input);
            this.offsets = new long[(int)(this.high - this.low + 1L)];
            int count = 0;
            while ((long)count < this.high - this.low + 1L) {
                this.offsets[count] = this.getLong(input);
                ++count;
            }
        }
    }

    public static class Raw_wide
    extends RawBytecode {
        int index;
        public byte actualOpcode;
        int constVal;

        @Override
        protected void continueReading(ByteCodeStream input) {
            this.actualOpcode = (byte)input.get();
            byte byte1 = (byte)input.get();
            byte byte2 = (byte)input.get();
            this.index = Raw_wide.bitwiseOr(Raw_wide.bitLeftShift(byte1 & 0xFF, 8), byte2 & 0xFF);
            if (this.actualOpcode == -124) {
                byte1 = (byte)input.get();
                byte2 = (byte)input.get();
                this.constVal = Raw_wide.bitwiseOr(Raw_wide.bitLeftShift(byte1 & 0xFF, 8), byte2 & 0xFF);
            }
        }
    }

    private static class StringIterator
    implements IcecapIterator<String> {
        private StringTokenizer tokenizer;

        public StringIterator(String init) {
            this.tokenizer = new StringTokenizer(init, ";");
        }

        @Override
        public boolean hasNext() {
            return this.tokenizer.hasMoreElements();
        }

        @Override
        public String next() {
            return this.tokenizer.nextToken();
        }
    }
}

