/*
 * Decompiled with CFR 0.152.
 */
package icecaptools;

import icecaptools.BNode;
import icecaptools.IcecapIterator;
import icecaptools.RawByteCodes;
import icecaptools.compiler.Compiler;
import icecaptools.compiler.aot.AOTCompiler;
import icecaptools.conversion.TargetAddressMap;
import java.util.ArrayList;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class MethodEntryPoints {
    private ArrayList<BNode> bnodes;
    private Method method;
    private boolean mayThrowException;
    private TargetAddressMap tmap;
    private JavaClass clazz;
    private boolean callWithArgs;
    private boolean neverCallWithArgs;

    public MethodEntryPoints(ArrayList<BNode> bnodes, Method method, TargetAddressMap tmap, JavaClass clazz) {
        this.bnodes = bnodes;
        this.method = method;
        this.clazz = clazz;
        this.tmap = tmap;
        this.mayThrowException = false;
        this.callWithArgs = false;
        this.neverCallWithArgs = false;
    }

    public Method getMethod() {
        return this.method;
    }

    public JavaClass getClazz() {
        return this.clazz;
    }

    public BNode getMainEntryPoint() {
        return this.bnodes.get(0);
    }

    public IcecapIterator<BNode> getHandlerEntryPoints() {
        return new HandlerIterator();
    }

    public ArrayList<BNode> getBNodes() {
        return this.bnodes;
    }

    public void setMayThrowException() {
        this.mayThrowException = true;
    }

    public boolean getMayThrowException() {
        return this.mayThrowException;
    }

    public TargetAddressMap getJumpTargets() {
        return this.tmap;
    }

    public BNode getBNodeFromHVMAddress(int pc) {
        for (BNode bNode : this.bnodes) {
            if (bNode.getAddress() != pc) continue;
            return bNode;
        }
        return null;
    }

    public BNode getBNodeFromOriginalAddress(int address) {
        for (BNode bNode : this.bnodes) {
            if (bNode.getOriginalAddress() != address) continue;
            return bNode;
        }
        return null;
    }

    public boolean isEqualTo(String targetClassName, String targetMethodName, String targetMethodSignature) {
        return this.clazz.getClassName().equals(targetClassName) && this.method.getName().equals(targetMethodName) && this.method.getSignature().equals(targetMethodSignature);
    }

    public void setCallWithArgs(boolean b) {
        this.callWithArgs = b;
    }

    public boolean canCallWithArgs() {
        if (this.neverCallWithArgs) {
            return false;
        }
        return this.callWithArgs;
    }

    public boolean useCombinedReturnType() throws Exception {
        if (this.canCallWithArgs() && (Compiler.getNumReturnValues(this.method) & 3) > 0) {
            switch (AOTCompiler.getReturntypeSize(this.method)) {
                case 1: 
                case 2: {
                    return true;
                }
            }
        }
        return false;
    }

    public int getReturnTypeSize() throws Exception {
        if (this.useCombinedReturnType()) {
            return AOTCompiler.getReturntypeSize(this.method) + 1;
        }
        return 2;
    }

    public void neverCallWithArgs() {
        this.neverCallWithArgs = true;
    }

    public RawByteCodes.RawBytecode getRawByteCode(int address) {
        BNode bnode = this.getBNodeFromOriginalAddress(address);
        return bnode.getRawByteCode();
    }

    private class HandlerIterator
    implements IcecapIterator<BNode> {
        private CodeException[] execptionTable;
        int top;

        public HandlerIterator() {
            this.execptionTable = MethodEntryPoints.this.method.getCode().getExceptionTable();
            this.top = 0;
        }

        @Override
        public boolean hasNext() {
            return this.execptionTable != null && this.top < this.execptionTable.length;
        }

        @Override
        public BNode next() {
            CodeException ce = this.execptionTable[this.top++];
            int handlerPC = ce.getHandlerPC();
            for (BNode nextBNode : MethodEntryPoints.this.bnodes) {
                if (nextBNode.getAddress() != handlerPC) continue;
                return nextBNode;
            }
            return null;
        }
    }
}

