/*
 * Decompiled with CFR 0.152.
 */
package icecaptools;

import icecaptools.BNode;
import icecaptools.MethodEntryPoints;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class LocalVariableUsageAnalyser {
    private MethodEntryPoints entryPoints;

    public LocalVariableUsageAnalyser(MethodEntryPoints entryPoints) {
        this.entryPoints = entryPoints;
    }

    public void analyse() {
        ArrayList<BNode> nodes = this.entryPoints.getBNodes();
        for (BNode bNode : nodes) {
            byte opcode = bNode.getOpCode();
            switch (opcode) {
                case 54: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 75: 
                case 76: 
                case 77: 
                case 78: {
                    int index = this.isIstoreOpcode(opcode) ? this.getLocalVariableIndex(bNode, (byte)54, (byte)59) : this.getLocalVariableIndex(bNode, (byte)58, (byte)75);
                    ArrayList<Integer> accessedLocals = new ArrayList<Integer>();
                    HashSet<BNode> visitedNodes = new HashSet<BNode>();
                    this.analyseIt(bNode, visitedNodes, accessedLocals);
                    if (accessedLocals.contains(index)) break;
                    bNode.setRedundant(true);
                }
            }
        }
    }

    private boolean isIstoreOpcode(byte opcode) {
        switch (opcode) {
            case 54: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                return true;
            }
        }
        return false;
    }

    private void analyseIt(BNode bNode, Set<BNode> visitedNodes, ArrayList<Integer> accessedLocals) {
        switch (bNode.getOpCode()) {
            case 24: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                this.addIndex(accessedLocals, bNode, (byte)24, (byte)38);
                break;
            }
            case 23: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                this.addIndex(accessedLocals, bNode, (byte)23, (byte)34);
                break;
            }
            case 22: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                this.addIndex(accessedLocals, bNode, (byte)22, (byte)30);
                break;
            }
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                this.addIndex(accessedLocals, bNode, (byte)21, (byte)26);
                break;
            }
            case 25: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                this.addIndex(accessedLocals, bNode, (byte)25, (byte)42);
                break;
            }
            case -124: {
                this.addIndex(accessedLocals, bNode, (byte)-124, (byte)-124);
            }
        }
        visitedNodes.add(bNode);
        Iterator<BNode> children = bNode.getChildren();
        while (children.hasNext()) {
            BNode next = children.next();
            if (visitedNodes.contains(next)) continue;
            this.analyseIt(next, visitedNodes, accessedLocals);
        }
    }

    private void addIndex(ArrayList<Integer> accessedLocals, BNode bNode, byte dynamic_opcode, byte static_opcode) {
        int index = this.getLocalVariableIndex(bNode, dynamic_opcode, static_opcode);
        accessedLocals.add(index);
    }

    protected int getLocalVariableIndex(BNode bNode, byte dynamic_opcode, byte static_opcode) {
        int index = bNode.getOpCode() == dynamic_opcode ? bNode.getRawBytes()[1] : bNode.getOpCode() - static_opcode;
        return index;
    }
}

