/*
 * Decompiled with CFR 0.152.
 */
package icecaptools;

import icecaptools.JavaArrayClass;
import icecaptools.LambdaClass;
import java.util.HashMap;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.util.ClassPath;
import org.apache.bcel.util.Repository;
import org.apache.bcel.util.SyntheticRepository;

public class IcecapRepository
implements Repository {
    private static final long serialVersionUID = 1L;
    private Repository delegate;
    private HashMap<String, JavaClass> cache;

    public IcecapRepository(SyntheticRepository delegate) {
        this.delegate = delegate;
        this.cache = new HashMap();
    }

    public void storeClass(JavaClass clazz) {
        this.delegate.storeClass(clazz);
    }

    public void removeClass(JavaClass clazz) {
        this.delegate.removeClass(clazz);
    }

    public JavaClass findClass(String className) {
        return this.delegate.findClass(className);
    }

    public JavaClass loadClass(String className) throws ClassNotFoundException {
        JavaClass loadedClass;
        if (this.cache.containsKey(className)) {
            loadedClass = this.cache.get(className);
        } else if (!JavaArrayClass.isArrayClass(className)) {
            if (!LambdaClass.isLambdaClass(className)) {
                loadedClass = this.delegate.loadClass(className);
            } else {
                String iFace = LambdaClass.getInterfaceName(className);
                JavaClass elementType = this.loadClass(iFace);
                LambdaClass clazz = new LambdaClass(className, elementType);
                loadedClass = clazz;
            }
            this.cache.put(className, loadedClass);
        } else {
            String elementClassName = className;
            int dimension = 0;
            while (JavaArrayClass.isArrayClass(elementClassName)) {
                elementClassName = JavaArrayClass.getElementType(elementClassName);
                ++dimension;
            }
            if (JavaArrayClass.isReferenceClass(elementClassName)) {
                elementClassName = JavaArrayClass.getReferredType(elementClassName);
                JavaClass elementType = this.loadClass(elementClassName);
                JavaArrayClass clazz = new JavaArrayClass(className, elementType, dimension);
                this.cache.put(className, clazz);
                loadedClass = clazz;
            } else {
                elementClassName = "java/lang/Object";
                JavaClass elementType = this.delegate.loadClass(elementClassName);
                JavaArrayClass clazz = new JavaArrayClass(className, elementType, dimension);
                clazz.setIsBasicType();
                this.cache.put(className, clazz);
                loadedClass = clazz;
            }
            this.cache.put(className, loadedClass);
        }
        return loadedClass;
    }

    public JavaClass loadClass(Class clazz) throws ClassNotFoundException {
        return this.delegate.loadClass(clazz);
    }

    public void clear() {
        this.delegate.clear();
    }

    public ClassPath getClassPath() {
        return this.delegate.getClassPath();
    }
}

