/*
 * Decompiled with CFR 0.152.
 */
package icecaptools;

import icecaptools.BNode;

public abstract class FieldAccessBNode
extends BNode {
    private String className;
    private boolean isGet;
    private String fieldName;
    private String signature;
    private int fieldSize;

    public FieldAccessBNode(int address, String className, String fieldName, String signature, boolean isGet, String locationClass, String locationMethod, String locationMethodSignature) {
        super(address, locationClass, locationMethod, locationMethodSignature);
        this.className = className;
        this.fieldName = fieldName;
        this.signature = signature;
        this.isGet = isGet;
        this.fieldSize = 0;
    }

    @Override
    public boolean requiresExtension() {
        return true;
    }

    @Override
    public void relocateForward(int address, int extension) {
    }

    @Override
    public void relocateBackward(int address, int extension) {
    }

    @Override
    public int extend() throws Exception {
        byte[] newRawBytes = new byte[this.rawBytes.length + 3];
        newRawBytes[0] = this.rawBytes[0];
        int i = 1;
        while (i < this.rawBytes.length) {
            newRawBytes[i + 1] = this.rawBytes[i];
            ++i;
        }
        this.rawBytes = newRawBytes;
        return 3;
    }

    @Override
    protected String print() {
        return "fieldaccess";
    }

    public String getSignature() {
        return this.signature;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean isGet() {
        return this.isGet;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setSize(int size) {
        this.fieldSize = size;
    }

    public int getSize() {
        return this.fieldSize;
    }
}

