/*
 * Decompiled with CFR 0.152.
 */
package icecaptools;

import icecaptools.AnalysisObserver;
import icecaptools.BNode;
import icecaptools.BasicBNode;
import icecaptools.BranchBNode;
import icecaptools.CFuncInfo;
import icecaptools.CanceledByUserException;
import icecaptools.CheckcastBNode;
import icecaptools.ClassfileUtils;
import icecaptools.DependencyLeakException;
import icecaptools.DynamicMethodCallBNode;
import icecaptools.DynamicMethodCallVirtualMethodBNode;
import icecaptools.GotoBNode;
import icecaptools.IcecapCFunc;
import icecaptools.IcecapCVar;
import icecaptools.IcecapIterator;
import icecaptools.IcecapProgressMonitor;
import icecaptools.InterfaceMethodCallBNode;
import icecaptools.JavaArrayClass;
import icecaptools.LDCBNode;
import icecaptools.MethodAndClass;
import icecaptools.MethodCallBNode;
import icecaptools.MethodEntryPoints;
import icecaptools.MethodOrFieldDesc;
import icecaptools.NativeFieldInfo;
import icecaptools.NewArrayBNode;
import icecaptools.NewBNode;
import icecaptools.NewList;
import icecaptools.ObjectFieldAccessBNode;
import icecaptools.ReturnBNode;
import icecaptools.SpecialMethodCallBNode;
import icecaptools.StaticFieldAccessBNode;
import icecaptools.StaticMethodCallBNode;
import icecaptools.SwitchBNode;
import icecaptools.VirtualMethodCallBNode;
import icecaptools.compiler.FieldInfo;
import icecaptools.compiler.LDCConstant;
import icecaptools.compiler.utils.CheckSubClassRelationShip;
import icecaptools.compiler.utils.MethodMap;
import icecaptools.compiler.utils.SubClassChecker;
import icecaptools.conversion.ConversionConfiguration;
import icecaptools.conversion.Converter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class DependencyWalker {
    private static final String[] jmlMethodNames = new String[]{"checkPre", "checkPost", "evalOldExprInHC", "checkInv", "checkHC"};
    private SubClassChecker subClassChecker = new SubClassChecker();
    private ImplementorChecker implementorChecker = new ImplementorChecker();
    private Converter converter;
    private AnalysisObserver observer;
    private int stackDepth;
    private DependencyLeakException dleak;
    private PrintStream out;
    private ConversionConfiguration config;
    private HashSet<String> leafMethods;
    private MethodMap<MethodAndClass> methodCache;

    public DependencyWalker(Converter converter, AnalysisObserver observer, PrintStream out, ConversionConfiguration config) {
        this.converter = converter;
        this.observer = new DependencyWalkerObserver(observer);
        this.dleak = new DependencyLeakException();
        this.out = out;
        this.config = config;
        this.leafMethods = new HashSet();
        this.methodCache = new MethodMap();
    }

    private void analyseBNode(BNode bnode, NewList newList, NewList mr, Stack<WorkItem> workItemStack) throws Throwable {
        block26: {
            NewList bnodeNewList = bnode.getNewList();
            if (newList.lessThanOrEquals(bnodeNewList)) {
                return;
            }
            if (bnodeNewList == null) {
                bnodeNewList = new NewList(newList);
                bnode.setNewList(bnodeNewList);
            } else {
                bnodeNewList.merge(newList);
            }
            if (bnode.throwsExceptions() && !bnode.exceptionsHandled()) {
                Iterator<String> exceptions = bnode.getExceptionsThrown();
                while (exceptions.hasNext()) {
                    String nextException = exceptions.next();
                    this.classInstantiated(newList, mr, nextException);
                    this.observer.methodCodeUsed(nextException, "<init>", "()V", true);
                    JavaClass clazz = this.lookupClass(nextException);
                    MethodEntryPoints entryPoints = this.converter.convertByteCode(bnode, clazz, "<init>", "()V", false);
                    if (entryPoints == null) continue;
                    NewList calledMethodResult = this.analyseMethod(entryPoints, newList);
                    this.mergeResult(newList, mr, calledMethodResult);
                    this.observer.classUsed(nextException);
                }
                bnode.setExceptionsHandled();
            }
            try {
                if (bnode instanceof BasicBNode) {
                    this.analyseBasicBNode((BasicBNode)bnode, newList, mr, workItemStack);
                    break block26;
                }
                if (bnode instanceof BranchBNode) {
                    this.analyseBranchBNode((BranchBNode)bnode, newList, mr, workItemStack);
                    break block26;
                }
                if (bnode instanceof GotoBNode) {
                    this.analyseGotoBNode((GotoBNode)bnode, newList, mr, workItemStack);
                    break block26;
                }
                if (bnode instanceof NewArrayBNode) {
                    this.analyseNewArrayBNode((NewArrayBNode)bnode, newList, mr, workItemStack);
                    break block26;
                }
                if (bnode instanceof CheckcastBNode) {
                    this.analyseCheckcastBNode((CheckcastBNode)bnode, newList, mr, workItemStack);
                    break block26;
                }
                if (bnode instanceof NewBNode) {
                    this.analyseNewBNode((NewBNode)bnode, newList, mr, workItemStack);
                    break block26;
                }
                if (bnode instanceof ReturnBNode) {
                    this.analyseReturnBNode(bnode, newList, mr, workItemStack);
                    break block26;
                }
                if (bnode instanceof VirtualMethodCallBNode) {
                    this.analyseVirtualMethodCallBNode((MethodCallBNode)bnode, newList, mr, workItemStack, this.subClassChecker);
                    break block26;
                }
                if (bnode instanceof SpecialMethodCallBNode) {
                    this.analyseSpecialMethodCallBNode((MethodCallBNode)bnode, newList, false, mr, workItemStack);
                    break block26;
                }
                if (bnode instanceof StaticMethodCallBNode) {
                    this.analyseSpecialMethodCallBNode((MethodCallBNode)bnode, newList, true, mr, workItemStack);
                    break block26;
                }
                if (bnode instanceof ObjectFieldAccessBNode) {
                    this.analyseObjectFieldAccessBNode((ObjectFieldAccessBNode)bnode, newList, mr, workItemStack);
                    break block26;
                }
                if (bnode instanceof StaticFieldAccessBNode) {
                    this.analyseStaticFieldAccessBNode((StaticFieldAccessBNode)bnode, newList, mr, workItemStack);
                    break block26;
                }
                if (bnode instanceof SwitchBNode) {
                    this.analyseSwitchBNodeBNode((SwitchBNode)bnode, newList, mr, workItemStack);
                    break block26;
                }
                if (bnode instanceof InterfaceMethodCallBNode) {
                    this.analyseInterfaceMethodCallBNode((MethodCallBNode)bnode, newList, mr, workItemStack, this.implementorChecker);
                    break block26;
                }
                if (bnode instanceof LDCBNode) {
                    this.analyseLDCBNode((LDCBNode)bnode, newList, mr, workItemStack);
                    break block26;
                }
                if (bnode instanceof DynamicMethodCallBNode) {
                    this.analyseDynamicMethodCallBNode((DynamicMethodCallBNode)bnode, newList, mr, workItemStack);
                    break block26;
                }
                throw new Exception("Unknown BNode instance");
            }
            catch (StackOverflowError stackOverflowError) {
                this.stackDepth = 0;
                throw this.dleak;
            }
            catch (DependencyLeakException dleak) {
                ++this.stackDepth;
                if (this.stackDepth < 50) {
                    throw dleak;
                }
                if (this.stackDepth == 50) {
                    this.out.println("icecaptools.DependencyWalker: DependencyLeakException");
                    throw dleak;
                }
                StringBuffer buffer = new StringBuffer();
                MethodAndClass methodAndClass = ClassfileUtils.findMethod(bnode.locationClass, bnode.locationMethod, bnode.locationMethodSignature);
                buffer.append("\tat ");
                buffer.append(methodAndClass.getClazz().getClassName());
                buffer.append(".");
                buffer.append(methodAndClass.getMethod().getName());
                buffer.append("(");
                buffer.append(methodAndClass.getClazz().getSourceFileName());
                buffer.append(":");
                buffer.append(ClassfileUtils.getLineNumber(methodAndClass.getMethod(), bnode.getOriginalAddress()));
                buffer.append(")");
                this.out.println(buffer.toString());
                throw dleak;
            }
        }
    }

    public JavaClass lookupClass(String className) throws ClassNotFoundException {
        JavaClass clss = Repository.lookupClass((String)className);
        return clss;
    }

    private void analyseDynamicMethodCallBNode(DynamicMethodCallBNode bnode, NewList newList, NewList mr, Stack<WorkItem> workItemStack) throws Throwable {
        DynamicMethodCallVirtualMethodBNode virtualMethodcallType;
        if (bnode instanceof DynamicMethodCallVirtualMethodBNode) {
            virtualMethodcallType = (DynamicMethodCallVirtualMethodBNode)bnode;
            JavaClass clazz = this.lookupClass(virtualMethodcallType.getClassNameHandle());
            this.observer.methodCodeUsed(virtualMethodcallType.getClassNameHandle(), virtualMethodcallType.getMethodNameHandle(), virtualMethodcallType.getMethodSigHandle(), true);
            this.observer.classUsed(virtualMethodcallType.getClassNameHandle());
            MethodEntryPoints entryPoints = this.converter.convertByteCode(bnode, clazz, virtualMethodcallType.getMethodNameHandle(), virtualMethodcallType.getMethodSigHandle(), false);
            if (entryPoints != null) {
                NewList calledMethodResult = this.analyseMethod(entryPoints, newList);
                this.mergeResult(newList, mr, calledMethodResult);
            }
        } else {
            throw new Exception("Unimplemented dynamic type");
        }
        String lambdaClassName = virtualMethodcallType.getLambdaClassName();
        this.classInstantiated(newList, mr, lambdaClassName);
        this.observer.classUsed(lambdaClassName);
        this.dispatchRest(bnode, newList, mr, workItemStack);
    }

    private void classInstantiated(NewList newList, NewList mr, String className) {
        newList.addElement(className);
        mr.addElement(className);
    }

    private void analyseObjectFieldAccessBNode(ObjectFieldAccessBNode bnode, NewList newList, NewList mr, Stack<WorkItem> workItemStack) throws Exception {
        JavaClass clazz = this.lookupClass(bnode.getClassName());
        this.observer.classUsed(clazz.getClassName());
        this.dispatchRest(bnode, newList, mr, workItemStack);
    }

    private void analyseNewArrayBNode(NewArrayBNode bnode, NewList newList, NewList mr, Stack<WorkItem> workItemStack) throws Exception {
        String referredType;
        String type = bnode.getType();
        if (JavaArrayClass.isArrayClass(type) && (referredType = JavaArrayClass.getReferredType(type)).length() > 0 && JavaArrayClass.isReferenceClass(referredType)) {
            String elementType = JavaArrayClass.getElementType(referredType);
            JavaClass elementClazz = this.lookupClass(elementType);
            if (elementClazz.isInterface()) {
                this.observer.interfaceUsed(elementType);
            } else {
                this.observer.classUsed(elementType);
            }
        }
        this.observer.classUsed(type);
        this.dispatchRest(bnode, newList, mr, workItemStack);
    }

    private void analyseLDCBNode(LDCBNode bnode, NewList newList, NewList mr, Stack<WorkItem> workItemStack) throws Throwable {
        LDCConstant constant = bnode.getLDCConstant();
        if (constant.getType() == 1) {
            this.ensureStringInitializer(bnode, newList, mr);
        } else if (constant.getType() == 6) {
            MethodEntryPoints entryPoints;
            this.classInstantiated(newList, mr, "java.lang.Class");
            this.observer.classUsed("java.lang.Class");
            JavaClass clazz = this.lookupClass(constant.getClassName());
            if (!(clazz instanceof JavaArrayClass) && ClassfileUtils.hasDefaultConstructor(clazz) && (entryPoints = this.converter.convertByteCode(bnode, clazz, "<init>", "()V", false)) != null) {
                NewList calledMethodResult = this.analyseMethod(entryPoints, newList);
                this.mergeResult(newList, mr, calledMethodResult);
            }
            this.classInstantiated(newList, mr, constant.getClassName());
            this.observer.classUsed(constant.getClassName());
        }
        this.dispatchRest(bnode, newList, mr, workItemStack);
    }

    protected void ensureStringInitializer(BNode bnode, NewList newList, NewList mr) throws ClassNotFoundException, Throwable {
        JavaClass clazz = this.lookupClass("java/lang/String");
        MethodEntryPoints entryPoints = this.converter.convertByteCode(bnode, clazz, "<init>", "([C)V", true);
        if (entryPoints != null) {
            NewList calledMethodResult = this.analyseMethod(entryPoints, newList);
            this.mergeResult(newList, mr, calledMethodResult);
        }
        this.classInstantiated(newList, mr, "java.lang.String");
        this.observer.classUsed("java.lang.String");
        this.observer.classUsed("[C");
    }

    public NewList analyseMethod(MethodEntryPoints entryPoints, NewList newList) throws Throwable {
        Stack<WorkItem> workItemStack = new Stack<WorkItem>();
        NewList mr = new NewList();
        workItemStack.push(new WorkItem(entryPoints.getMainEntryPoint(), new NewList(newList)));
        while (workItemStack.size() > 0) {
            WorkItem nextWorkItem = (WorkItem)workItemStack.pop();
            this.analyseBNode(nextWorkItem.bnode, nextWorkItem.newList, mr, workItemStack);
        }
        newList.merge(mr);
        IcecapIterator<BNode> handlerEntryPoints = entryPoints.getHandlerEntryPoints();
        while (handlerEntryPoints.hasNext()) {
            BNode nextEntrypoint = handlerEntryPoints.next();
            newList.merge(mr);
            workItemStack.push(new WorkItem(nextEntrypoint, new NewList(newList)));
            while (workItemStack.size() > 0) {
                WorkItem nextWorkItem = workItemStack.pop();
                this.analyseBNode(nextWorkItem.bnode, nextWorkItem.newList, mr, workItemStack);
            }
        }
        return mr;
    }

    private void dispatchRest(BNode bnode, NewList newList, NewList mr, Stack<WorkItem> workItemStack) throws Exception {
        Iterator<BNode> children = bnode.getChildren();
        while (children.hasNext()) {
            workItemStack.push(new WorkItem(children.next(), new NewList(newList)));
        }
    }

    private void analyseStaticFieldAccessBNode(StaticFieldAccessBNode bnode, NewList newList, NewList mr, Stack<WorkItem> workItemStack) throws Throwable {
        NewList calledMethodResult;
        MethodEntryPoints entryPoints;
        JavaClass clazz = this.lookupClass(bnode.getClassName());
        this.observer.classUsed(clazz.getClassName());
        this.observer.classFieldUsed(clazz.getClassName(), bnode.getFieldName());
        if (ClassfileUtils.hasClassInitializer(clazz) && (entryPoints = this.converter.convertByteCode(bnode, clazz, "<clinit>", "()V", true)) != null) {
            calledMethodResult = this.analyseMethod(entryPoints, newList);
            this.mergeResult(newList, mr, calledMethodResult);
        }
        if (bnode.isGet()) {
            if (clazz.getClassName().replace("/", ".").equals("java.lang.System")) {
                clazz = this.lookupClass("devices.System");
                if (clazz != null && ClassfileUtils.findMethodInClass(clazz, "initializeSystemClass", "()V") != null && (entryPoints = this.converter.convertByteCode(bnode, clazz, "initializeSystemClass", "()V", true)) != null) {
                    calledMethodResult = this.analyseMethod(entryPoints, newList);
                    this.mergeResult(newList, mr, calledMethodResult);
                }
            } else {
                this.observer.classInitializerUsed(clazz.getClassName());
            }
        }
        this.dispatchRest(bnode, newList, mr, workItemStack);
    }

    protected void mergeResult(NewList newList, NewList mr, NewList calledMethodResult) throws Exception {
        newList.merge(calledMethodResult);
        mr.merge(calledMethodResult);
    }

    private void analyseVirtualMethodCallBNode(MethodCallBNode bnode, NewList newList, NewList mr, Stack<WorkItem> workItemStack, CheckSubClassRelationShip checker) throws Throwable {
        String clazzName = bnode.getClassName();
        if (JavaArrayClass.isArrayClass(clazzName)) {
            while (JavaArrayClass.isArrayClass(clazzName)) {
                clazzName = JavaArrayClass.getElementType(clazzName);
            }
            if (JavaArrayClass.isReferenceClass(clazzName)) {
                clazzName = JavaArrayClass.getReferredType(clazzName);
            } else {
                this.dispatchRest(bnode, newList, mr, workItemStack);
                return;
            }
        }
        JavaClass clazz = this.lookupClass(clazzName);
        MethodAndClass methodAndClass = this.findMethodInClassHierarchy(clazz, bnode.getMethodName(), bnode.getMethodSig());
        clazzName = methodAndClass.getClazz().getClassName();
        String methodName = bnode.getMethodName();
        this.observer.methodCodeUsed(clazzName, methodName, bnode.getMethodSig(), true);
        if (clazzName.equals("java.lang.Float") && methodName.equals("toString")) {
            this.ensureStringInitializer(bnode, newList, mr);
        }
        if (clazzName.equals("java.lang.reflect.Method") && methodName.equals("invoke")) {
            this.ensureUnboxing(bnode, newList, mr);
            this.ensureInvocationTargetException(bnode, newList, mr);
        }
        if (clazzName.equals("java.lang.reflect.Constructor") && methodName.equals("newInstance")) {
            this.ensureUnboxing(bnode, newList, mr);
            this.ensureInvocationTargetException(bnode, newList, mr);
        }
        if (clazzName.equals("java.lang.Class")) {
            if (methodName.equals("newInstance")) {
                this.handleNewInstance(bnode, newList, mr);
            } else if (methodName.equals("getConstructor")) {
                this.handleGetConstructor(newList, mr);
            } else if (methodName.equals("getMethod")) {
                this.handleGetMethod(bnode, newList, mr);
            }
        }
        if (clazzName.equals("java.lang.Thread") && methodName.equals("start")) {
            this.handleThreadStart(bnode, newList, mr);
        }
        this.analyseMethodCallBNode(clazz, bnode, newList, mr, workItemStack, checker);
    }

    private void handleThreadStart(MethodCallBNode bnode, NewList newList, NewList mr) throws Throwable {
        JavaClass clazz = this.lookupClass("thread/ThreadUtils");
        if (clazz != null) {
            MethodEntryPoints entryPoints = this.converter.convertByteCode(bnode, clazz, "dispatchRunnable", "(Ljava/lang/Runnable;)V", true, true);
            if (entryPoints != null) {
                NewList calledMethodResult = this.analyseMethod(entryPoints, newList);
                this.mergeResult(newList, mr, calledMethodResult);
            }
            this.observer.classUsed("thread.ThreadUtils");
            this.observer.methodCodeUsed(clazz.getClassName(), "dispatchRunnable", "(Ljava/lang/Runnable;)V", true);
        }
    }

    private void handleGetConstructor(NewList newList, NewList mr) {
        String constructor = "java.lang.reflect.Constructor";
        this.classInstantiated(newList, mr, constructor);
        this.observer.classUsed(constructor);
    }

    private void ensureInvocationTargetException(MethodCallBNode bnode, NewList newList, NewList mr) throws Throwable {
        JavaClass clazz = this.lookupClass("java/lang/reflect/InvocationTargetException");
        if (clazz != null) {
            MethodEntryPoints entryPoints = this.converter.convertByteCode(bnode, clazz, "<init>", "(Ljava/lang/Throwable;)V", false, true);
            if (entryPoints != null) {
                NewList calledMethodResult = this.analyseMethod(entryPoints, newList);
                this.mergeResult(newList, mr, calledMethodResult);
            }
            this.classInstantiated(newList, mr, "java.lang.reflect.InvocationTargetException");
            this.observer.classUsed("java.lang.reflect.InvocationTargetException");
            this.observer.methodCodeUsed(clazz.getClassName(), "<init>", "(Ljava/lang/Throwable;)V", true);
        }
    }

    private void handleCurrentTimeMillis(MethodCallBNode bnode, NewList newList, NewList mr) throws Throwable {
        JavaClass clazz = this.lookupClass("devices.System");
        MethodEntryPoints entryPoints = this.converter.convertByteCode(bnode, clazz, "currentTimeMillis", "()J", true);
        if (entryPoints != null) {
            NewList calledMethodResult = this.analyseMethod(entryPoints, newList);
            this.mergeResult(newList, mr, calledMethodResult);
        }
        this.observer.classUsed("devices.System");
    }

    private void handleGetProperty(MethodCallBNode bnode, NewList newList, NewList mr) throws Throwable {
        JavaClass clazz = this.lookupClass("devices.System");
        MethodEntryPoints entryPoints = this.converter.convertByteCode(bnode, clazz, "getProperty", "(Ljava/lang/String;)Ljava/lang/String;", true);
        if (entryPoints != null) {
            NewList calledMethodResult = this.analyseMethod(entryPoints, newList);
            this.mergeResult(newList, mr, calledMethodResult);
        }
        this.observer.classUsed("devices.System");
    }

    private void handleDoPriviledge(MethodCallBNode bnode, NewList newList, NewList mr) throws Throwable {
        NewList calledMethodResult;
        String nextClass = "java.lang.Boolean";
        this.classInstantiated(newList, mr, nextClass);
        this.observer.classUsed(nextClass);
        this.observer.methodCodeUsed(nextClass, "<init>", "()V", true);
        JavaClass clazz = this.lookupClass(nextClass);
        MethodEntryPoints entryPoints = this.converter.convertByteCode(bnode, clazz, "<init>", "(Z)V", false);
        if (entryPoints != null) {
            calledMethodResult = this.analyseMethod(entryPoints, newList);
            this.mergeResult(newList, mr, calledMethodResult);
        }
        if ((entryPoints = this.converter.convertByteCode(bnode, clazz = this.lookupClass("devices.AccessController"), "doPrivileged", "(Ljava/security/PrivilegedAction;)Ljava/lang/Object;", true)) != null) {
            calledMethodResult = this.analyseMethod(entryPoints, newList);
            this.mergeResult(newList, mr, calledMethodResult);
        }
        this.observer.classUsed("devices.AccessController");
    }

    private void handleGetMethod(MethodCallBNode bnode, NewList newList, NewList mr) throws Throwable {
        String nextException = "java.lang.NoSuchMethodException";
        this.classInstantiated(newList, mr, nextException);
        this.observer.classUsed(nextException);
        this.observer.methodCodeUsed(nextException, "<init>", "()V", true);
        JavaClass clazz = this.lookupClass(nextException);
        MethodEntryPoints entryPoints = this.converter.convertByteCode(bnode, clazz, "<init>", "()V", false);
        if (entryPoints != null) {
            NewList calledMethodResult = this.analyseMethod(entryPoints, newList);
            this.mergeResult(newList, mr, calledMethodResult);
        }
        this.observer.classUsed("java.lang.reflect.Method");
    }

    private void handleNewInstance(MethodCallBNode bnode, NewList newList, NewList mr) throws Throwable {
        IcecapIterator<String> forcedincludes = this.config.getForcedIncludes();
        while (forcedincludes.hasNext()) {
            String nextClass = forcedincludes.next();
            this.classInstantiated(newList, mr, nextClass);
            this.observer.methodCodeUsed(nextClass, "<init>", "()V", true);
            JavaClass clazz = this.lookupClass(nextClass);
            MethodEntryPoints entryPoints = this.converter.convertByteCode(bnode, clazz, "<init>", "()V", false);
            if (entryPoints == null) continue;
            NewList calledMethodResult = this.analyseMethod(entryPoints, newList);
            this.mergeResult(newList, mr, calledMethodResult);
        }
    }

    private void ensureUnboxing(MethodCallBNode bnode, NewList newList, NewList mr) throws Throwable {
        String[] methods = new String[]{"unbox", "(Ljava/lang/Object;)V", "boxBoolean", "(Z)Ljava/lang/Boolean;", "boxByte", "(B)Ljava/lang/Byte;", "boxShort", "(S)Ljava/lang/Short;", "boxCharacter", "(C)Ljava/lang/Character;", "boxInteger", "(I)Ljava/lang/Integer;", "boxLong", "(J)Ljava/lang/Long;"};
        JavaClass clazz = this.lookupClass("reflect/Unboxing");
        int i = 0;
        while (i < methods.length) {
            MethodEntryPoints entryPoints = this.converter.convertByteCode(bnode, clazz, methods[i], methods[i + 1], true);
            if (entryPoints != null) {
                NewList calledMethodResult = this.analyseMethod(entryPoints, newList);
                this.mergeResult(newList, mr, calledMethodResult);
            }
            i += 2;
        }
        this.classInstantiated(newList, mr, "reflect.Unboxing");
        this.observer.classUsed("reflect.Unboxing");
    }

    private void analyseInterfaceMethodCallBNode(MethodCallBNode bnode, NewList newList, NewList mr, Stack<WorkItem> workItemStack, ImplementorChecker implementorChecker) throws Throwable {
        String clazzName = bnode.getClassName();
        JavaClass clazz = this.lookupClass(clazzName);
        JavaClass declaringClass = ClassfileUtils.findDeclaringInterface(clazz, bnode.getMethodName(), bnode.getMethodSig()).getClazz();
        this.observer.interfaceUsed(declaringClass.getClassName());
        this.analyseMethodCallBNode(clazz, bnode, newList, mr, workItemStack, implementorChecker);
    }

    private void analyseMethodCallBNode(JavaClass clazz, MethodCallBNode bnode, NewList newList, NewList mr, Stack<WorkItem> workItemStack, CheckSubClassRelationShip checker) throws Throwable {
        String[] elements = newList.getElementsAsArray();
        int count = 0;
        boolean used = false;
        NewList exitList = new NewList();
        while (count < elements.length) {
            JavaClass subClazz;
            String className;
            if (JavaArrayClass.isArrayClass(className = elements[count++]) || !checker.isSubclassOf(subClazz = this.lookupClass(className), clazz)) continue;
            subClazz = this.findMethodInClassHierarchy(subClazz, bnode.getMethodName(), bnode.getMethodSig()).getClazz();
            bnode.addTarget(subClazz);
            this.addMethodToExtent(bnode, subClazz, bnode.getMethodName(), bnode.getMethodSig(), false, newList, exitList);
            used = true;
        }
        String key = String.valueOf(clazz.getClassName()) + ": " + bnode.getMethodName();
        if (!used) {
            if (!this.leafMethods.contains(key)) {
                this.leafMethods.add(key);
            }
        } else if (this.leafMethods.contains(key)) {
            this.leafMethods.remove(key);
        }
        this.mergeResult(newList, mr, exitList);
        this.checkNatives(bnode, newList, clazz, bnode.getMethodName(), bnode.getMethodSig(), mr);
        this.dispatchRest(bnode, newList, mr, workItemStack);
    }

    private MethodAndClass findMethodInClassHierarchy(JavaClass subClazz, String methodName, String methodSig) throws Exception {
        MethodAndClass mac = this.methodCache.get(subClazz.getClassName(), methodName, methodSig);
        if (mac == null) {
            mac = ClassfileUtils.findMethodInClassHierarchy(subClazz, methodName, methodSig);
            this.methodCache.put(subClazz.getClassName(), methodName, methodSig, mac);
        }
        return mac;
    }

    private void checkNatives(MethodCallBNode cause, NewList newList, JavaClass clazz, String methodName, String methodSignature, NewList mr) throws Throwable {
        if (!cause.isNativesChecked(newList)) {
            cause.setNativesChecked(newList);
            Method method = cause.findMethodInClass(clazz);
            if (method != null && (method.isNative() || this.converter.skipMethodHack(clazz.getClassName(), methodName, methodSignature) || this.hackHack(clazz, methodName, methodSignature))) {
                Type[] types;
                Type returnType = method.getReturnType();
                if (returnType instanceof ReferenceType) {
                    String typeName = returnType.toString();
                    this.classInstantiated(newList, mr, typeName);
                }
                Type[] typeArray = types = method.getArgumentTypes();
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    Type type = typeArray[n2];
                    if (type instanceof ObjectType) {
                        ObjectType rtype = (ObjectType)type;
                        String typeName = rtype.toString();
                        JavaClass runnable = this.lookupClass("java.lang.Runnable");
                        JavaClass argClass = this.lookupClass(typeName);
                        if (this.implementorChecker.isSubclassOf(argClass, runnable)) {
                            this.registerRunables(cause, newList, mr);
                            return;
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    private boolean hackHack(JavaClass clazz, String methodName, String methodSignature) {
        return clazz.getClassName().equals("vm.Memory") && methodName.equals("getHeapArea") && methodSignature.equals("()Lvm/Memory;");
    }

    private void registerRunables(BNode cause, NewList newList, NewList mr) throws Throwable {
        String[] elements = newList.getElementsAsArray();
        int count = 0;
        boolean foundIt = false;
        JavaClass runnable = this.lookupClass("java.lang.Runnable");
        while (count < elements.length) {
            JavaClass subClazz;
            String className;
            if (JavaArrayClass.isArrayClass(className = elements[count++]) || !this.implementorChecker.isSubclassOf(subClazz = this.lookupClass(className), runnable)) continue;
            this.observer.methodCodeUsed(subClazz.getClassName(), "run", "()V", true);
            MethodEntryPoints entryPoints = this.converter.convertByteCode(cause, subClazz, "run", "()V", false);
            if (entryPoints != null) {
                entryPoints.neverCallWithArgs();
                NewList calledMethodResult = this.analyseMethod(entryPoints, newList);
                this.mergeResult(newList, mr, calledMethodResult);
            }
            foundIt = true;
        }
        if (foundIt) {
            this.observer.interfaceUsed(runnable.getClassName());
        }
    }

    private void analyseSpecialMethodCallBNode(MethodCallBNode bnode, NewList newList, boolean isStatic, NewList mr, Stack<WorkItem> workItemStack) throws Throwable {
        MethodEntryPoints entryPoints;
        JavaClass clazz = this.lookupClass(bnode.getClassName());
        JavaClass declaringClass = this.findMethodInClassHierarchy(clazz, bnode.getMethodName(), bnode.getMethodSig()).getClazz();
        if (isStatic && ClassfileUtils.hasClassInitializer(declaringClass) && (entryPoints = this.converter.convertByteCode(bnode, declaringClass, "<clinit>", "()V", true)) != null) {
            NewList calledMethodResult = this.analyseMethod(entryPoints, newList);
            this.mergeResult(newList, mr, calledMethodResult);
        }
        NewList exitList = new NewList();
        this.addMethodToExtent(bnode, declaringClass, bnode.getMethodName(), bnode.getMethodSig(), isStatic, newList, exitList);
        this.mergeResult(newList, mr, exitList);
        this.observer.classUsed(declaringClass.getClassName());
        this.observer.classUsed(clazz.getClassName());
        this.checkNatives(bnode, newList, declaringClass, bnode.getMethodName(), bnode.getMethodSig(), mr);
        if (declaringClass.getClassName().equals("java.lang.Class") && bnode.getMethodName().equals("forName")) {
            this.handleForname(bnode, newList, mr);
        }
        if (declaringClass.getClassName().equals("java.security.AccessController") && bnode.getMethodName().equals("doPrivileged")) {
            this.handleDoPriviledge(bnode, newList, mr);
        }
        if (declaringClass.getClassName().equals("java.lang.System")) {
            if (bnode.getMethodName().equals("getProperty")) {
                this.handleGetProperty(bnode, newList, mr);
            }
            if (bnode.getMethodName().equals("currentTimeMillis")) {
                this.handleCurrentTimeMillis(bnode, newList, mr);
            }
        }
        this.dispatchRest(bnode, newList, mr, workItemStack);
    }

    private void addMethodToExtent(MethodCallBNode bnode, JavaClass declaringClass, String methodName, String methodSig, boolean isStatic, NewList newList, NewList exitList) throws Throwable {
        MethodEntryPoints entryPoints;
        if (this.config.getProperties().isIncludeJMLMethods() && !methodName.equals("<init>") && !isStatic) {
            JavaClass superClass = declaringClass.getSuperClass();
            while (superClass != null) {
                if (superClass.isAbstract()) {
                    int i = 0;
                    while (i < jmlMethodNames.length) {
                        this.ensureJMLMethod(bnode, newList, exitList, superClass, jmlMethodNames[i]);
                        ++i;
                    }
                }
                superClass = superClass.getSuperClass();
            }
            JavaClass[] interfaces = declaringClass.getAllInterfaces();
            if (interfaces != null) {
                JavaClass[] javaClassArray = interfaces;
                int n = interfaces.length;
                int n2 = 0;
                while (n2 < n) {
                    JavaClass iface = javaClassArray[n2];
                    String surrogate = String.valueOf(iface.getClassName()) + "$JmlSurrogate";
                    try {
                        JavaClass jmlSurrogateClass = this.lookupClass(surrogate);
                        while (jmlSurrogateClass != null) {
                            int i = 0;
                            while (i < jmlMethodNames.length) {
                                this.ensureJMLMethod(bnode, newList, exitList, jmlSurrogateClass, jmlMethodNames[i]);
                                ++i;
                            }
                            this.ensureJMLMethod(bnode, newList, exitList, jmlSurrogateClass, "<init>");
                            jmlSurrogateClass = jmlSurrogateClass.getSuperClass();
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                    ++n2;
                }
            }
        }
        if ((entryPoints = this.converter.convertByteCode(bnode, declaringClass, methodName, methodSig, isStatic)) != null) {
            NewList calledMethodResult = this.analyseMethod(entryPoints, new NewList(newList));
            exitList.merge(calledMethodResult);
        }
    }

    private void ensureJMLMethod(MethodCallBNode bnode, NewList newList, NewList exitList, JavaClass superClass, String jmlMethodName) throws Exception, Throwable {
        Method[] methods;
        Method[] methodArray = methods = superClass.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            MethodEntryPoints entryPoints;
            Method method = methodArray[n2];
            if (method.getName().contains(jmlMethodName) && (entryPoints = this.converter.convertByteCode(bnode, superClass, method.getName(), method.getSignature(), false)) != null) {
                NewList calledMethodResult = this.analyseMethod(entryPoints, new NewList(newList));
                exitList.merge(calledMethodResult);
            }
            ++n2;
        }
    }

    private void handleForname(MethodCallBNode bnode, NewList newList, NewList mr) {
        IcecapIterator<String> forcedincludes = this.config.getForcedIncludes();
        while (forcedincludes.hasNext()) {
            String nextClass = forcedincludes.next();
            this.observer.classUsed(nextClass);
        }
    }

    private void analyseReturnBNode(BNode bnode, NewList newList, NewList mr, Stack<WorkItem> workItemStack) {
    }

    private void analyseCheckcastBNode(CheckcastBNode bnode, NewList newList, NewList mr, Stack<WorkItem> workItemStack) throws Exception {
        this.dispatchRest(bnode, newList, mr, workItemStack);
        if (!bnode.typeIsInterface()) {
            this.observer.classUsed(bnode.getType());
        } else {
            this.observer.interfaceUsed(bnode.getType());
        }
    }

    private void analyseNewBNode(NewBNode bnode, NewList newList, NewList mr, Stack<WorkItem> workItemStack) throws Exception {
        this.classInstantiated(newList, mr, bnode.getType());
        this.observer.classUsed(bnode.getType());
        this.dispatchRest(bnode, newList, mr, workItemStack);
    }

    private void analyseGotoBNode(GotoBNode bnode, NewList newList, NewList mr, Stack<WorkItem> workItemStack) throws Exception {
        this.dispatchRest(bnode, newList, mr, workItemStack);
    }

    private void analyseBranchBNode(BranchBNode bnode, NewList newList, NewList mr, Stack<WorkItem> workItemStack) throws Exception {
        this.dispatchRest(bnode, newList, mr, workItemStack);
    }

    private void analyseBasicBNode(BasicBNode bnode, NewList newList, NewList mr, Stack<WorkItem> workItemStack) throws Exception {
        this.dispatchRest(bnode, newList, mr, workItemStack);
    }

    private void analyseSwitchBNodeBNode(SwitchBNode bnode, NewList newList, NewList mr, Stack<WorkItem> workItemStack) throws Exception {
        this.dispatchRest(bnode, newList, mr, workItemStack);
    }

    public IcecapIterator<String> getLeafs() {
        return new LeafMethodsIterator(this.leafMethods.iterator());
    }

    private static class DependencyWalkerObserver
    implements AnalysisObserver {
        private AnalysisObserver delegate;

        DependencyWalkerObserver(AnalysisObserver delegate) {
            this.delegate = delegate;
        }

        @Override
        public void methodCodeUsed(String className, String targetMethodName, String targetMethodSignature, boolean report) throws CanceledByUserException {
            this.delegate.methodCodeUsed(className, targetMethodName, targetMethodSignature, report);
        }

        @Override
        public void classUsed(String newType) {
            this.delegate.classUsed(newType);
        }

        @Override
        public void classFieldUsed(String className, String fieldName) {
            this.delegate.classFieldUsed(className, fieldName);
        }

        @Override
        public void interfaceUsed(String className) {
            this.delegate.interfaceUsed(className);
        }

        @Override
        public void byteCodeUsed(byte opCode) {
            this.delegate.byteCodeUsed(opCode);
        }

        @Override
        public boolean isMethodUsed(String className, String targetMethodName, String targetMethodSignature) {
            return this.delegate.isMethodUsed(className, targetMethodName, targetMethodSignature);
        }

        @Override
        public boolean isClassFieldUsed(String className, String fieldName) {
            return this.delegate.isClassFieldUsed(className, fieldName);
        }

        @Override
        public boolean isInterfaceUsed(String className) {
            return this.delegate.isInterfaceUsed(className);
        }

        @Override
        public IcecapIterator<MethodOrFieldDesc> getUsedMethods() {
            return this.delegate.getUsedMethods();
        }

        @Override
        public Iterator<String> getUsedClasses() {
            return this.delegate.getUsedClasses();
        }

        @Override
        public void setProgressMonitor(IcecapProgressMonitor progressMonitor) {
            this.delegate.setProgressMonitor(progressMonitor);
        }

        @Override
        public boolean isClassUsed(String className) {
            return this.delegate.isClassUsed(className);
        }

        @Override
        public void registerLockingTypes(ArrayList<String> types) {
            this.delegate.registerLockingTypes(types);
        }

        @Override
        public void registerLockingType(String type) {
            this.delegate.registerLockingType(type);
        }

        @Override
        public boolean isLockingType(String className) {
            return this.delegate.isLockingType(className);
        }

        @Override
        public boolean isBytecodeUsed(int i) {
            return this.delegate.isBytecodeUsed(i);
        }

        @Override
        public void registerNativeField(String containingClass, FieldInfo field, IcecapCVar cvar) {
            this.delegate.registerNativeField(containingClass, field, cvar);
        }

        @Override
        public NativeFieldInfo isNativeField(String containingClass, FieldInfo field) {
            return this.delegate.isNativeField(containingClass, field);
        }

        @Override
        public void classInitializerUsed(String className) {
            this.delegate.classInitializerUsed(className);
        }

        @Override
        public Iterator<String> getUsedClassInitializers() {
            return this.delegate.getUsedClassInitializers();
        }

        @Override
        public IcecapIterator<MethodOrFieldDesc> getUsedMethods(String nextClass) {
            return this.delegate.getUsedMethods(nextClass);
        }

        @Override
        public void reportVtableSize(int s) {
            this.delegate.reportVtableSize(s);
        }

        @Override
        public int getMaxVtableSize() {
            return this.delegate.getMaxVtableSize();
        }

        @Override
        public void registerCFunc(String className, String name, String signature, IcecapCFunc cfunc) {
            this.delegate.registerCFunc(className, name, signature, cfunc);
        }

        @Override
        public CFuncInfo isCFunc(String className, String name, String signature) {
            return this.delegate.isCFunc(className, name, signature);
        }

        @Override
        public IcecapIterator<CFuncInfo> getCFunctions() throws Exception {
            return this.delegate.getCFunctions();
        }
    }

    private static class ImplementorChecker
    implements CheckSubClassRelationShip {
        private HashMap<String, Boolean> relations = new HashMap();

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean isSubclassOf(JavaClass subClazz, JavaClass clazz) throws ClassNotFoundException {
            key = new StringBuffer();
            key.append(subClazz.getClassName());
            key.append(clazz.getClassName());
            keyString = key.toString();
            if (!this.relations.containsKey(keyString)) ** GOTO lbl14
            return this.relations.get(keyString);
lbl-1000:
            // 1 sources

            {
                if (subClazz.implementationOf(clazz)) {
                    this.relations.put(keyString, true);
                    return true;
                }
                subClazz = subClazz.getSuperClass();
lbl14:
                // 2 sources

                ** while (subClazz != null)
            }
lbl15:
            // 1 sources

            this.relations.put(keyString, false);
            return false;
        }
    }

    private static class LeafMethodsIterator
    implements IcecapIterator<String> {
        private Iterator<String> iterator;

        public LeafMethodsIterator(Iterator<String> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public String next() {
            return this.iterator.next();
        }
    }

    private static class WorkItem {
        public BNode bnode;
        public NewList newList;

        public WorkItem(BNode bnode, NewList newList) {
            this.bnode = bnode;
            this.newList = newList;
        }
    }
}

