/*
 * Decompiled with CFR 0.152.
 */
package icecaptools;

import icecaptools.IcecapIterator;
import icecaptools.ResourceManager;
import icecaptools.StreamResource;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CompositeResourceManager
extends ResourceManager {
    private List<ResourceManager> inners = new ArrayList<ResourceManager>();

    @Override
    public IcecapIterator<StreamResource> getResources(PrintStream out) {
        return new CompositeResourceManagerIterator(this.inners, out);
    }

    public void addResourceManager(ResourceManager r) {
        this.inners.add(r);
    }

    @Override
    public StreamResource getResource(PrintStream out, String resourceName) {
        for (ResourceManager rm : this.inners) {
            StreamResource resource = rm.getResource(out, resourceName);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    @Override
    protected void setResourcesToLoad(String[] resources) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String[] getResourcesToLoad() {
        throw new UnsupportedOperationException();
    }

    protected class CompositeResourceManagerIterator
    implements IcecapIterator<StreamResource> {
        Iterator<ResourceManager> resourcesManagerIt;
        IcecapIterator<StreamResource> current;
        private PrintStream out;

        CompositeResourceManagerIterator(List<ResourceManager> resourcesManager, PrintStream out) {
            this.out = out;
            this.resourcesManagerIt = resourcesManager.iterator();
        }

        @Override
        public boolean hasNext() {
            while (this.current == null || !this.current.hasNext() && this.resourcesManagerIt.hasNext()) {
                this.current = this.resourcesManagerIt.next().getResources(this.out);
            }
            return this.current != null && this.current.hasNext();
        }

        @Override
        public StreamResource next() {
            return this.current.next();
        }
    }
}

