/*
 * Decompiled with CFR 0.152.
 */
package icecaptools;

import icecaptools.BNode;
import icecaptools.conversion.TargetAddressMap;

public class BranchBNode
extends BNode {
    protected int branchoffset;
    protected int originalBranchoffset;

    public BranchBNode(int address, int branchoffset, String locationClass, String locationMethod, String locationMethodSignature) {
        super(address, locationClass, locationMethod, locationMethodSignature);
        this.branchoffset = branchoffset;
        this.originalBranchoffset = branchoffset;
    }

    public int getBranchoffset() {
        return this.branchoffset;
    }

    @Override
    public void link(BNode[] nodes, TargetAddressMap tmap) throws Exception {
        super.link(nodes, tmap);
        BNode branchTarget = BranchBNode.findNodeWithAddress(nodes, this.address + this.branchoffset);
        tmap.markJumpTarget(branchTarget);
        this.addChild(branchTarget);
    }

    @Override
    public boolean requiresExtension() {
        return false;
    }

    @Override
    public void relocateForward(int address, int extension) {
        if (this.branchoffset < 0 && this.address + this.branchoffset <= address) {
            this.branchoffset -= extension;
        }
    }

    @Override
    public void relocateBackward(int address, int extension) {
        if (this.branchoffset > 0 && this.address + this.branchoffset > address) {
            this.branchoffset += extension;
        }
    }

    @Override
    public byte[] getRawBytes() {
        byte branchbyte2;
        byte branchbyte1;
        if (this.rawBytes[0] == -56 || this.rawBytes[0] == -55) {
            branchbyte1 = (byte)(this.branchoffset >> 24 & 0xFF);
            branchbyte2 = (byte)(this.branchoffset >> 16 & 0xFF);
            byte branchbyte3 = (byte)(this.branchoffset >> 8 & 0xFF);
            byte branchbyte4 = (byte)(this.branchoffset & 0xFF);
            this.rawBytes[3] = branchbyte3;
            this.rawBytes[4] = branchbyte4;
        } else {
            branchbyte1 = (byte)(this.branchoffset >> 8 & 0xFF);
            branchbyte2 = (byte)(this.branchoffset & 0xFF);
        }
        this.rawBytes[1] = branchbyte1;
        this.rawBytes[2] = branchbyte2;
        return super.getRawBytes();
    }

    @Override
    protected String print() {
        return "branch " + (this.originalAddress + this.originalBranchoffset) + "(" + this.originalBranchoffset + ")";
    }
}

